/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerBitType;

public class Unsigned12BitType
extends AbstractIntegerBitType<Unsigned12BitType> {
    private final long mask;
    private static final NativeTypeFactory<Unsigned12BitType, LongAccess> typeFactory = NativeTypeFactory.LONG(Unsigned12BitType::new);

    public Unsigned12BitType(NativeImg<?, ? extends LongAccess> bitStorage) {
        super(bitStorage, 12);
        this.mask = 4095L;
    }

    public Unsigned12BitType(long value) {
        this((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public Unsigned12BitType(LongAccess access) {
        this((NativeImg)null);
        this.dataAccess = access;
    }

    public Unsigned12BitType() {
        this(0L);
    }

    @Override
    public Unsigned12BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned12BitType(this.img);
    }

    @Override
    public NativeTypeFactory<Unsigned12BitType, LongAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public long get() {
        long j = this.i.get();
        long k = j * 12L;
        int i1 = (int)(k >>> 6);
        long shift = k & 0x3FL;
        long v = this.dataAccess.getValue(i1);
        long antiShift = 64L - shift;
        if (antiShift < 12L) {
            long v1 = v >>> (int)shift & this.mask >>> (int)(12L - antiShift);
            long v2 = (this.dataAccess.getValue(i1 + 1) & this.mask >>> (int)antiShift) << (int)antiShift;
            return v1 | v2;
        }
        return v >>> (int)shift & this.mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long value) {
        long j = this.i.get();
        long k = j * 12L;
        int i1 = (int)(k >>> 6);
        long shift = k & 0x3FL;
        long safeValue = value & this.mask;
        long antiShift = 64L - shift;
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            long v = this.dataAccess.getValue(i1);
            if (antiShift < 12L) {
                long v1 = v & -1L >>> (int)antiShift | (safeValue & this.mask >>> (int)(12L - antiShift)) << (int)shift;
                this.dataAccess.setValue(i1, v1);
                long v2 = this.dataAccess.getValue(i1 + 1) & -1L << (int)(12L - antiShift) | safeValue >>> (int)antiShift;
                this.dataAccess.setValue(i1 + 1, v2);
            } else if (0L == v) {
                this.dataAccess.setValue(i1, safeValue << (int)shift);
            } else {
                this.dataAccess.setValue(i1, v & (this.mask << (int)shift ^ 0xFFFFFFFFFFFFFFFFL) | safeValue << (int)shift);
            }
        }
    }

    @Override
    public Unsigned12BitType createVariable() {
        return new Unsigned12BitType(0L);
    }

    @Override
    public Unsigned12BitType copy() {
        return new Unsigned12BitType(this.dataAccess != null ? this.get() : 0L);
    }
}

