/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.View;

public class RandomAccessibleOnRealRandomAccessible<T>
extends AbstractEuclideanSpace
implements RandomAccessible<T>,
View {
    protected final RealRandomAccessible<T> source;

    public RealRandomAccessible<T> getSource() {
        return this.source;
    }

    public RandomAccessibleOnRealRandomAccessible(RealRandomAccessible<T> source) {
        super(source.numDimensions());
        this.source = source;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new RandomAccessOnRealRandomAccessible(this.source.realRandomAccess());
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return new RandomAccessOnRealRandomAccessible(this.source.realRandomAccess(interval));
    }

    @Override
    public T getType() {
        return this.source.getType();
    }

    private final class RandomAccessOnRealRandomAccessible
    implements RandomAccess<T> {
        private final RealRandomAccess<T> sourceAccess;

        public RandomAccessOnRealRandomAccessible(RealRandomAccess<T> sourceAccess) {
            this.sourceAccess = sourceAccess;
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < RandomAccessibleOnRealRandomAccessible.this.n; ++d) {
                position[d] = (int)Math.round(this.sourceAccess.getDoublePosition(d));
            }
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < RandomAccessibleOnRealRandomAccessible.this.n; ++d) {
                position[d] = Math.round(this.sourceAccess.getDoublePosition(d));
            }
        }

        @Override
        public int getIntPosition(int d) {
            return (int)Math.round(this.sourceAccess.getDoublePosition(d));
        }

        @Override
        public long getLongPosition(int d) {
            return Math.round(this.sourceAccess.getDoublePosition(d));
        }

        @Override
        public void localize(float[] position) {
            this.sourceAccess.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.sourceAccess.localize(position);
        }

        @Override
        public float getFloatPosition(int d) {
            return this.sourceAccess.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.sourceAccess.getDoublePosition(d);
        }

        @Override
        public void fwd(int d) {
            this.sourceAccess.fwd(d);
        }

        @Override
        public void bck(int d) {
            this.sourceAccess.bck(d);
        }

        @Override
        public void move(int distance, int d) {
            this.sourceAccess.move(distance, d);
        }

        @Override
        public void move(long distance, int d) {
            this.sourceAccess.move(distance, d);
        }

        @Override
        public void move(Localizable localizable) {
            this.sourceAccess.move(localizable);
        }

        @Override
        public void move(int[] distance) {
            this.sourceAccess.move(distance);
        }

        @Override
        public void move(long[] distance) {
            this.sourceAccess.move(distance);
        }

        @Override
        public void setPosition(Localizable localizable) {
            this.sourceAccess.setPosition(localizable);
        }

        @Override
        public void setPosition(int[] position) {
            this.sourceAccess.setPosition(position);
        }

        @Override
        public void setPosition(long[] position) {
            this.sourceAccess.setPosition(position);
        }

        @Override
        public void setPosition(int position, int d) {
            this.sourceAccess.setPosition(position, d);
        }

        @Override
        public void setPosition(long position, int d) {
            this.sourceAccess.setPosition(position, d);
        }

        @Override
        public T get() {
            return this.sourceAccess.get();
        }

        @Override
        public T getType() {
            return this.sourceAccess.getType();
        }

        @Override
        public RandomAccessOnRealRandomAccessible copy() {
            return new RandomAccessOnRealRandomAccessible(this.sourceAccess.copy());
        }

        @Override
        public int numDimensions() {
            return RandomAccessibleOnRealRandomAccessible.this.n;
        }
    }
}

