/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;

public class RandomAccessiblePair<A, B>
implements RandomAccessible<Pair<A, B>> {
    protected final RandomAccessible<A> sourceA;
    protected final RandomAccessible<B> sourceB;

    public RandomAccessiblePair(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB) {
        this.sourceA = sourceA;
        this.sourceB = sourceB;
    }

    @Override
    public int numDimensions() {
        return this.sourceA.numDimensions();
    }

    public RandomAccess randomAccess() {
        return new RandomAccess();
    }

    public RandomAccess randomAccess(Interval interval) {
        return new RandomAccess();
    }

    @Override
    public Pair<A, B> getType() {
        return new ValuePair(this.sourceA.getType(), this.sourceB.getType());
    }

    public class RandomAccess
    implements Pair<A, B>,
    net.imglib2.RandomAccess<Pair<A, B>> {
        protected final net.imglib2.RandomAccess<A> a;
        protected final net.imglib2.RandomAccess<B> b;

        public RandomAccess() {
            this.a = RandomAccessiblePair.this.sourceA.randomAccess();
            this.b = RandomAccessiblePair.this.sourceB.randomAccess();
        }

        @Override
        public A getA() {
            return this.a.get();
        }

        @Override
        public B getB() {
            return this.b.get();
        }

        @Override
        public void localize(int[] position) {
            this.a.localize(position);
        }

        @Override
        public void localize(long[] position) {
            this.a.localize(position);
        }

        @Override
        public int getIntPosition(int d) {
            return this.a.getIntPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.a.getLongPosition(d);
        }

        @Override
        public void localize(float[] position) {
            this.a.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.a.localize(position);
        }

        @Override
        public float getFloatPosition(int d) {
            return this.a.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.a.getDoublePosition(d);
        }

        @Override
        public int numDimensions() {
            return RandomAccessiblePair.this.numDimensions();
        }

        @Override
        public void fwd(int d) {
            this.a.fwd(d);
            this.b.fwd(d);
        }

        @Override
        public void bck(int d) {
            this.a.bck(d);
            this.b.bck(d);
        }

        @Override
        public void move(int distance, int d) {
            this.a.move(distance, d);
            this.b.move(distance, d);
        }

        @Override
        public void move(long distance, int d) {
            this.a.move(distance, d);
            this.b.move(distance, d);
        }

        @Override
        public void move(Localizable localizable) {
            this.a.move(localizable);
            this.b.move(localizable);
        }

        @Override
        public void move(int[] distance) {
            this.a.move(distance);
            this.b.move(distance);
        }

        @Override
        public void move(long[] distance) {
            this.a.move(distance);
            this.b.move(distance);
        }

        @Override
        public void setPosition(Localizable localizable) {
            this.a.setPosition(localizable);
            this.b.setPosition(localizable);
        }

        @Override
        public void setPosition(int[] position) {
            this.a.setPosition(position);
            this.b.setPosition(position);
        }

        @Override
        public void setPosition(long[] position) {
            this.a.setPosition(position);
            this.b.setPosition(position);
        }

        @Override
        public void setPosition(int position, int d) {
            this.a.setPosition(position, d);
            this.b.setPosition(position, d);
        }

        @Override
        public void setPosition(long position, int d) {
            this.a.setPosition(position, d);
            this.b.setPosition(position, d);
        }

        @Override
        public RandomAccess get() {
            return this;
        }

        @Override
        public RandomAccess getType() {
            return this;
        }

        @Override
        public RandomAccess copy() {
            RandomAccess copy = new RandomAccess();
            copy.setPosition(this);
            return copy;
        }
    }
}

