/*
 * Decompiled with CFR 0.152.
 */
package preview.net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodFactory;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodLocalizableSampler;

public class NeighborhoodRandomAccess<T>
extends NeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    public NeighborhoodRandomAccess(RandomAccessible<T> source, NeighborhoodFactory factory) {
        super(source, factory, null);
    }

    public NeighborhoodRandomAccess(RandomAccessible<T> source, NeighborhoodFactory factory, Interval interval) {
        super(source, factory, interval);
    }

    private NeighborhoodRandomAccess(NeighborhoodRandomAccess<T> c) {
        super(c);
    }

    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + localizable.getLongPosition(d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = localizable.getLongPosition(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    public NeighborhoodRandomAccess<T> copy() {
        return new NeighborhoodRandomAccess<T>(this);
    }

    public NeighborhoodRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

