/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.algorithm.convolution.kernel.SeparableKernelConvolution;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.StackView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import sc.fiji.labkit.pixel_classification.utils.views.FastViews;
import weka.core.DenseInstance;

public class RevampUtils {
    public static <T> List<RandomAccessibleInterval<T>> slices(RandomAccessibleInterval<T> output) {
        int axis = output.numDimensions() - 1;
        return LongStream.range(output.min(axis), output.max(axis) + 1L).mapToObj(pos -> Views.hyperSlice((RandomAccessibleInterval)output, (int)axis, (long)pos)).collect(Collectors.toList());
    }

    public static <T extends NativeType<T>> RandomAccessibleInterval<T> createImage(Interval interval, T type) {
        long[] min = Intervals.minAsLongArray((Interval)interval);
        long[] size = Intervals.dimensionsAsLongArray((Dimensions)interval);
        return Views.translate((RandomAccessibleInterval)new ArrayImgFactory(type).create(size), (long[])min);
    }

    public static Interval appendDimensionToInterval(Interval in, long min, long max) {
        int n = in.numDimensions();
        long[] mins = new long[n + 1];
        long[] maxs = new long[n + 1];
        for (int i = 0; i < n; ++i) {
            mins[i] = in.min(i);
            maxs[i] = in.max(i);
        }
        mins[n] = min;
        maxs[n] = max;
        return new FinalInterval(mins, maxs);
    }

    public static Interval removeLastDimension(Interval in) {
        long[] min = RevampUtils.removeLast(Intervals.minAsLongArray((Interval)in));
        long[] max = RevampUtils.removeLast(Intervals.maxAsLongArray((Interval)in));
        return new FinalInterval(min, max);
    }

    private static long[] removeLast(long[] longs) {
        return Arrays.copyOf(longs, longs.length - 1);
    }

    public static RandomAccessibleInterval<FloatType> gauss(RandomAccessibleInterval<FloatType> image, double[] sigmas) {
        return RevampUtils.gauss((RandomAccessible<FloatType>)Views.extendBorder(image), image, sigmas);
    }

    public static RandomAccessibleInterval<FloatType> gauss(RandomAccessible<FloatType> input, Interval outputInterval, double[] sigmas) {
        RandomAccessibleInterval<FloatType> blurred = RevampUtils.createImage(outputInterval, new FloatType());
        Gauss3.gauss((double[])sigmas, input, blurred);
        return blurred;
    }

    public static Interval gaussRequiredInput(Interval outputInterval, double[] sigmas) {
        long[] border = IntStream.of(Gauss3.halfkernelsizes((double[])sigmas)).mapToLong(x -> x - 1).toArray();
        return Intervals.expand((Interval)outputInterval, (long[])border);
    }

    public static RandomAccessibleInterval<FloatType> deriveX(RandomAccessible<FloatType> input, Interval outputInterval) {
        if (outputInterval.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        RandomAccessibleInterval<FloatType> output = RevampUtils.createImage(outputInterval, new FloatType());
        SeparableKernelConvolution.convolution((Kernel1D[])new Kernel1D[]{Kernel1D.centralAsymmetric((double[])new double[]{1.0, 0.0, -1.0}), Kernel1D.centralAsymmetric((double[])new double[]{1.0, 2.0, 1.0})}).process(input, output);
        return output;
    }

    public static Interval deriveXRequiredInput(Interval output) {
        if (output.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        return Intervals.expand((Interval)output, (long[])new long[]{1L, 1L});
    }

    public static RandomAccessibleInterval<FloatType> deriveY(RandomAccessible<FloatType> input, Interval outputInterval) {
        if (outputInterval.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        RandomAccessibleInterval<FloatType> output = RevampUtils.createImage(outputInterval, new FloatType());
        SeparableKernelConvolution.convolution((Kernel1D[])new Kernel1D[]{Kernel1D.centralAsymmetric((double[])new double[]{1.0, 2.0, 1.0}), Kernel1D.centralAsymmetric((double[])new double[]{1.0, 0.0, -1.0})}).process(input, output);
        return output;
    }

    public static Interval deriveYRequiredInput(Interval output) {
        if (output.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two dimensional images supported.");
        }
        return Intervals.expand((Interval)output, (long[])new long[]{1L, 1L});
    }

    public static RandomAccessible<FloatType> randomAccessibleToFloat(RandomAccessible<? extends RealType<?>> input) {
        RealType inputType = (RealType)input.randomAccess().get();
        if (inputType instanceof FloatType) {
            return (RandomAccessible)RevampUtils.uncheckedCast(input);
        }
        Converter converter = RealTypeConverters.getConverter((RealType)inputType, (RealType)new FloatType());
        return Converters.convert(input, (Converter)converter, (Type)new FloatType());
    }

    public static RandomAccessibleInterval<FloatType> copy(RandomAccessibleInterval<FloatType> input) {
        RandomAccessibleInterval<FloatType> output = RevampUtils.createImage(input, new FloatType());
        RealTypeConverters.copyFromTo(input, output);
        return output;
    }

    public static boolean containsNaN(RandomAccessibleInterval<? extends ComplexType<?>> result) {
        for (ComplexType value : Views.iterable(result)) {
            if (!Double.isNaN(value.getRealDouble())) continue;
            return true;
        }
        return false;
    }

    public static long[] nCopies(int count, long value) {
        long[] result = new long[count];
        Arrays.fill(result, value);
        return result;
    }

    public static void wrapException(RunnableWithException r) {
        try {
            r.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static <R> R wrapException(SupplierWithException<R> r) {
        try {
            return r.get();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static DenseInstance getInstance(int featureCount, int classIndex, Composite<? extends RealType<?>> featureValues) {
        double[] values = new double[featureCount + 1];
        for (int i = 0; i < featureCount; ++i) {
            values[i] = ((RealType)featureValues.get((long)i)).getRealDouble();
        }
        values[featureCount] = classIndex;
        return new DenseInstance(1.0, values);
    }

    public static <T> T uncheckedCast(Object input) {
        Object result = input;
        return (T)result;
    }

    public static <T> RandomAccessibleInterval<Composite<T>> vectorizeStack(List<RandomAccessibleInterval<T>> derivatives) {
        return (RandomAccessibleInterval)Cast.unchecked(FastViews.collapse(Views.stack((StackView.StackAccessMode)StackView.StackAccessMode.MOVE_ALL_SLICE_ACCESSES, derivatives)));
    }

    public static Interval intervalRemoveDimension(Interval interval) {
        return RevampUtils.intervalRemoveDimension(interval, interval.numDimensions() - 1);
    }

    public static Interval intervalRemoveDimension(Interval interval, int d) {
        long[] min = RevampUtils.removeElement(Intervals.minAsLongArray((Interval)interval), d);
        long[] max = RevampUtils.removeElement(Intervals.maxAsLongArray((Interval)interval), d);
        return new FinalInterval(min, max);
    }

    private static long[] removeElement(long[] values, int d) {
        long[] result = new long[values.length - 1];
        System.arraycopy(values, 0, result, 0, d);
        System.arraycopy(values, d + 1, result, d, values.length - d - 1);
        return result;
    }

    public static interface SupplierWithException<R> {
        public R get() throws Exception;
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

