/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconResources {
    private final Map<String, ImageIcon> map = new HashMap<String, ImageIcon>();
    private static final IconResources instance = new IconResources();
    private static final BufferedImage backupImage = new BufferedImage(24, 24, 2);
    private static final ImageIcon backupIcon = new ImageIcon(backupImage);

    public static URL getResource(String name) {
        return instance.getResourceImpl(name);
    }

    public static ImageIcon getIcon(String name) {
        return instance.getIconImpl(name);
    }

    public static BufferedImage getImage(String name) {
        return instance.getImageImpl(name);
    }

    private BufferedImage getImageImpl(String name) {
        try {
            return ImageIO.read(IconResources.getResource(name));
        }
        catch (IOException e) {
            return backupImage;
        }
    }

    private URL getResourceImpl(String name) {
        return ClassLoader.getSystemResource(name);
    }

    private ImageIcon getIconImpl(String name) {
        ImageIcon icon = this.map.get(name);
        if (icon == null) {
            try {
                icon = new ImageIcon(this.getResourceImpl(name));
            }
            catch (NullPointerException npe) {
                icon = backupIcon;
            }
            this.map.put(name, icon);
        }
        return icon;
    }
}

