/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.calculator;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.pixel_classification.pixel_feature.calculator.InputPreprocessor;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class MultiChannelInputPreprocessor
implements InputPreprocessor {
    private final GlobalSettings globals;

    public MultiChannelInputPreprocessor(GlobalSettings globals) {
        this.globals = globals;
    }

    @Override
    public List<RandomAccessible<FloatType>> getChannels(RandomAccessible<?> input) {
        return this.hyperSlice(this.toFloat(input));
    }

    private RandomAccessible<FloatType> toFloat(RandomAccessible<?> input) {
        Object type = input.randomAccess().get();
        if (type instanceof FloatType) {
            return input;
        }
        if (type instanceof RealType) {
            return Converters.convert(input, (in, out) -> out.setReal(in.getRealFloat()), (Type)new FloatType());
        }
        throw new UnsupportedOperationException("Input image must be of RealType.");
    }

    private List<RandomAccessible<FloatType>> hyperSlice(RandomAccessible<FloatType> input) {
        if (input.numDimensions() != this.globals.numDimensions() + 1) {
            throw new UnsupportedOperationException("Input image must have " + this.globals.numDimensions() + " plus one color channel.");
        }
        int numChannels = this.globals.channelSetting().channels().size();
        int channelAxis = input.numDimensions() - 1;
        return IntStream.range(0, numChannels).mapToObj(channel -> Views.hyperSlice((RandomAccessible)input, (int)channelAxis, (long)channel)).collect(Collectors.toList());
    }

    @Override
    public Class<?> getType() {
        return RealType.class;
    }

    @Override
    public Interval outputIntervalFromInput(RandomAccessibleInterval<?> image) {
        int n = this.globals.numDimensions();
        if (image.numDimensions() != n + 1) {
            throw new UnsupportedOperationException("Input image must have " + n + " plus one color channel.");
        }
        return RevampUtils.intervalRemoveDimension(image);
    }
}

