/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.view.Views;

public class ToString {
    public static void print(RandomAccessibleInterval<?> image) {
        System.out.println(ToString.toString(image));
    }

    public static String toString(RandomAccessibleInterval<?> image) {
        return ToString.toString(image, "");
    }

    private static <T> String toString(RandomAccessibleInterval<T> image, String prefix) {
        if (image.numDimensions() == 0) {
            return "{ numDimensions = 0 }";
        }
        if (image.numDimensions() == 1) {
            StringJoiner joiner = new StringJoiner(", ", prefix + "{", "}");
            for (Object pixel : Views.iterable(image)) {
                joiner.add(pixel.toString());
            }
            return joiner.toString();
        }
        StringJoiner joiner = new StringJoiner(",\n", prefix + "{\n", "\n" + prefix + "}");
        for (RandomAccessibleInterval<T> line : ToString.slices(image)) {
            joiner.add(ToString.toString(line, prefix + "\t"));
        }
        return joiner.toString();
    }

    private static <T> List<RandomAccessibleInterval<T>> slices(RandomAccessibleInterval<T> image) {
        int lastDim = image.numDimensions() - 1;
        long min = image.min(lastDim);
        long max = image.max(lastDim);
        ArrayList<RandomAccessibleInterval<T>> result = new ArrayList<RandomAccessibleInterval<T>>();
        for (long pos = min; pos <= max; ++pos) {
            result.add((RandomAccessibleInterval<T>)Views.hyperSlice(image, (int)lastDim, (long)pos));
        }
        return result;
    }
}

