/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.HashMap;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMultiscaleMetadata;

public class N5MultiScaleMetadata
extends SpatialMultiscaleMetadata<N5SingleScaleMetadata> {
    public N5MultiScaleMetadata(String basePath, N5SingleScaleMetadata[] childrenMetadata) {
        super(basePath, (N5SpatialDatasetMetadata[])childrenMetadata);
    }

    public static class MultiScaleParser
    implements N5MetadataParser<N5MultiScaleMetadata> {
        @Override
        public Optional<N5MultiScaleMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
            HashMap<String, N5TreeNode> scaleLevelNodes = new HashMap<String, N5TreeNode>();
            for (N5TreeNode childNode : node.childrenList()) {
                if (!MultiscaleMetadata.scaleLevelPredicate.test(childNode.getNodeName()) || !childNode.isDataset() || !(childNode.getMetadata() instanceof N5SingleScaleMetadata)) continue;
                scaleLevelNodes.put(childNode.getNodeName(), childNode);
            }
            if (scaleLevelNodes.isEmpty()) {
                return Optional.empty();
            }
            N5DatasetMetadata[] childMetadata = (N5SingleScaleMetadata[])scaleLevelNodes.values().stream().map(N5TreeNode::getMetadata).toArray(N5SingleScaleMetadata[]::new);
            if (!MultiscaleMetadata.sortScaleMetadata((N5DatasetMetadata[])childMetadata)) {
                return Optional.empty();
            }
            return Optional.of(new N5MultiScaleMetadata(node.getPath(), (N5SingleScaleMetadata[])childMetadata));
        }
    }
}

