/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

public class Axis {
    public static final String SPACE = "space";
    public static final String CHANNEL = "channel";
    public static final String TIME = "time";
    public static final String DISPLACEMENT = "displacement";
    public static final String ARRAY = "array";
    protected String type;
    protected String name;
    protected String unit;
    protected boolean discrete;

    public Axis(String type, String name, String unit, boolean discrete) {
        this.type = type;
        this.name = name;
        this.unit = unit;
        this.discrete = discrete;
    }

    public Axis(String name) {
        this(null, name, null, false);
    }

    public Axis(String type, String name) {
        this(type, name, null, false);
    }

    public Axis(String type, String name, String unit) {
        this(type, name, unit, false);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean equals(Object other) {
        if (other instanceof Axis) {
            Axis axis = (Axis)other;
            return this.name.equals(axis.name) && this.type.equals(axis.type) && this.unit.equals(axis.unit);
        }
        return false;
    }

    public String toString() {
        return String.format("axis %s: \"%s\" (%s)", this.type, this.name, this.unit);
    }

    public static Axis defaultArray(int index) {
        return new Axis(String.format("dim_%d", index), ARRAY, null, true);
    }

    public static Axis[] space(String unit, String ... names) {
        Axis[] axes = new Axis[names.length];
        for (int i = 0; i < names.length; ++i) {
            axes[i] = new Axis(names[i], SPACE, unit, false);
        }
        return axes;
    }
}

