/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.canonical;

import java.util.Arrays;
import net.imglib2.realtransform.AffineGet;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.CalibratedSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.LinearSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;

public class SpatialMetadataCanonical
implements SpatialMetadata,
AxisMetadata {
    private final SpatialTransform transform;
    private final String unit;
    private final String path;
    private final Axis[] axes;

    public SpatialMetadataCanonical(String path, SpatialTransform transform, String unit, Axis[] axes) {
        this.path = path;
        this.unit = unit;
        this.transform = transform;
        this.axes = axes;
    }

    public SpatialMetadataCanonical(String path, CalibratedSpatialTransform calTransform, Axis[] axes) {
        this.path = path;
        this.unit = calTransform.getUnit();
        this.transform = calTransform.getSpatialTransform();
        this.axes = axes;
    }

    public SpatialTransform transform() {
        return this.transform;
    }

    @Override
    public AffineGet spatialTransform() {
        if (this.transform instanceof LinearSpatialTransform) {
            return ((LinearSpatialTransform)this.transform).getTransform().copy();
        }
        return null;
    }

    @Override
    public String unit() {
        return this.unit;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public String[] getAxisLabels() {
        return (String[])Arrays.stream(this.axes).map(Axis::getName).toArray(String[]::new);
    }

    @Override
    public String[] getAxisTypes() {
        return (String[])Arrays.stream(this.axes).map(Axis::getType).toArray(String[]::new);
    }

    @Override
    public String[] getUnits() {
        return (String[])Arrays.stream(this.axes).map(Axis::getUnit).toArray(String[]::new);
    }
}

