/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching.fusion;

import fiji.stacks.Hyperstack_rearranger;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.stitching.fusion.AveragePixelFusion;
import mpicbg.stitching.fusion.AveragePixelFusionIgnoreZero;
import mpicbg.stitching.fusion.BlendingPixelFusion;
import mpicbg.stitching.fusion.BlendingPixelFusionIgnoreZero;
import mpicbg.stitching.fusion.ClassifiedRegion;
import mpicbg.stitching.fusion.ImageInterpolation;
import mpicbg.stitching.fusion.Interval;
import mpicbg.stitching.fusion.MaxPixelFusion;
import mpicbg.stitching.fusion.MaxPixelFusionIgnoreZero;
import mpicbg.stitching.fusion.MedianPixelFusion;
import mpicbg.stitching.fusion.MedianPixelFusionIgnoreZero;
import mpicbg.stitching.fusion.MinPixelFusion;
import mpicbg.stitching.fusion.MinPixelFusionIgnoreZero;
import mpicbg.stitching.fusion.OverlapFusion;
import mpicbg.stitching.fusion.OverlayFusion;
import mpicbg.stitching.fusion.PixelFusion;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import stitching.utils.CompositeImageFixer;
import stitching.utils.Log;

public class Fusion {
    public static long redrawDelay = 500L;

    public static <T extends RealType<T> & NativeType<T>> ImagePlus fuse(T targetType, ArrayList<ImagePlus> images, ArrayList<InvertibleBoundable> models, int dimensionality, boolean subpixelResolution, int fusionType, String outputDirectory, boolean noOverlap, boolean ignoreZeroValues, boolean displayImages) {
        double[] offset = new double[dimensionality];
        int[] size = new int[dimensionality];
        int numTimePoints = images.get(0).getNFrames();
        int numChannels = images.get(0).getNChannels();
        Fusion.estimateBounds(offset, size, images, models, dimensionality);
        if (subpixelResolution) {
            int d = 0;
            while (d < size.length) {
                int n = d++;
                size[n] = size[n] + 1;
            }
        }
        ImagePlusImgFactory f = new ImagePlusImgFactory();
        ImageStack stack = outputDirectory == null ? new ImageStack(size[0], size[1]) : null;
        for (int t = 1; t <= numTimePoints; ++t) {
            for (int c = 1; c <= numChannels; ++c) {
                ArrayList blockData;
                IJ.showStatus((String)("Fusing time point: " + t + " of " + numTimePoints + ", channel: " + c + " of " + numChannels + "..."));
                Img out = outputDirectory == null ? f.create(size, targetType) : f.create(new int[]{size[0], size[1]}, targetType);
                PixelFusion fusion = null;
                if (fusionType == 1) {
                    fusion = ignoreZeroValues ? new AveragePixelFusionIgnoreZero() : new AveragePixelFusion();
                } else if (fusionType == 2) {
                    fusion = ignoreZeroValues ? new MedianPixelFusionIgnoreZero() : new MedianPixelFusion();
                } else if (fusionType == 3) {
                    fusion = ignoreZeroValues ? new MaxPixelFusionIgnoreZero() : new MaxPixelFusion();
                } else if (fusionType == 4) {
                    fusion = ignoreZeroValues ? new MinPixelFusionIgnoreZero() : new MinPixelFusion();
                } else if (fusionType == 5) {
                    fusion = new OverlapFusion();
                }
                if (subpixelResolution) {
                    blockData = new ArrayList();
                    NLinearInterpolatorFactory interpolatorFactory = new NLinearInterpolatorFactory();
                    for (ImagePlus imp : images) {
                        blockData.add(new ImageInterpolation(ImageJFunctions.convertFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t)), interpolatorFactory, true));
                    }
                    if (fusionType == 0) {
                        fusion = ignoreZeroValues ? new BlendingPixelFusionIgnoreZero(blockData) : new BlendingPixelFusion(blockData);
                    }
                    if (outputDirectory == null) {
                        Fusion.fuseBlock(out, blockData, offset, models, fusion, displayImages);
                    } else {
                        int numSlices = dimensionality == 2 ? 1 : size[2];
                        Fusion.writeBlock(out, numSlices, t, numTimePoints, c, numChannels, blockData, offset, models, fusion, outputDirectory);
                    }
                } else {
                    blockData = new ArrayList();
                    NearestNeighborInterpolatorFactory interpolatorFactoryFloat = new NearestNeighborInterpolatorFactory();
                    NearestNeighborInterpolatorFactory interpolatorFactoryShort = new NearestNeighborInterpolatorFactory();
                    NearestNeighborInterpolatorFactory interpolatorFactoryByte = new NearestNeighborInterpolatorFactory();
                    for (ImagePlus imp : images) {
                        if (imp.getType() == 2) {
                            blockData.add(new ImageInterpolation(ImageJFunctions.wrapFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t)), interpolatorFactoryFloat, false));
                            continue;
                        }
                        if (imp.getType() == 1) {
                            blockData.add(new ImageInterpolation(ImageJFunctions.wrapShort((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t)), interpolatorFactoryShort, false));
                            continue;
                        }
                        blockData.add(new ImageInterpolation(ImageJFunctions.wrapByte((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t)), interpolatorFactoryByte, false));
                    }
                    if (fusionType == 0) {
                        fusion = ignoreZeroValues ? new BlendingPixelFusionIgnoreZero(blockData) : new BlendingPixelFusion(blockData);
                    }
                    if (outputDirectory == null) {
                        if (noOverlap) {
                            Fusion.fuseBlockNoOverlap(out, blockData, offset, models, displayImages);
                        } else {
                            Fusion.fuseBlock(out, blockData, offset, models, fusion, displayImages);
                        }
                    } else {
                        int numSlices = dimensionality == 2 ? 1 : size[2];
                        Fusion.writeBlock(out, numSlices, t, numTimePoints, c, numChannels, blockData, offset, models, fusion, outputDirectory);
                    }
                }
                try {
                    if (stack == null) continue;
                    ImagePlus outImp = ((ImagePlusImg)out).getImagePlus();
                    int z = 1;
                    while ((long)z <= out.dimension(2)) {
                        stack.addSlice("", outImp.getStack().getProcessor(z));
                        ++z;
                    }
                    continue;
                }
                catch (ImgLibException e) {
                    Log.error("Output image has no ImageJ type: " + (Object)((Object)e));
                }
            }
        }
        IJ.showStatus((String)"Fusion complete.");
        IJ.showProgress((double)1.01);
        if (stack == null) {
            return null;
        }
        ImagePlus result = new ImagePlus("", stack);
        if (dimensionality == 3) {
            result.setDimensions(size[2], numChannels, numTimePoints);
            result = OverlayFusion.switchZCinXYCZT(result);
            return CompositeImageFixer.makeComposite(result, 1);
        }
        result.setDimensions(numChannels, 1, numTimePoints);
        if (numChannels > 1 || numTimePoints > 1) {
            return CompositeImageFixer.makeComposite(result, 1);
        }
        return result;
    }

    protected static <T extends RealType<T>> void fuseBlock(Img<T> output, ArrayList<? extends ImageInterpolation<? extends RealType<?>>> input, double[] offset, ArrayList<InvertibleBoundable> transform, PixelFusion fusion, boolean displayFusion) {
        int numDimensions = output.numDimensions();
        int numImages = input.size();
        long size = output.dimension(0);
        for (int d = 1; d < output.numDimensions(); ++d) {
            size *= output.dimension(d);
        }
        List<ClassifiedRegion> tiles = Fusion.buildTileList(numImages, numDimensions, transform, input, offset);
        IJ.showProgress((double)0.0);
        ImagePlus[] fusionImp = new ImagePlus[1];
        if (displayFusion) {
            try {
                fusionImp[0] = ((ImagePlusImg)output).getImagePlus();
                fusionImp[0].setTitle("fusing...");
                fusionImp[0].show();
            }
            catch (ImgLibException e) {
                Log.error("Output image has no ImageJ type: " + (Object)((Object)e));
            }
        }
        Thread[] threads = SimpleMultiThreading.newThreads();
        TileProcessor[] processors = new TileProcessor[threads.length];
        ArrayList interpolators = new ArrayList();
        long positionsPerThread = size / (long)threads.length;
        int[] count = new int[1];
        ClassifiedRegion[] currentTile = new ClassifiedRegion[1];
        Vector<Chunk> threadChunks = new Vector<Chunk>();
        int[] loopDim = new int[1];
        for (int i = 0; i < threads.length; ++i) {
            processors[i] = new TileProcessor<T>(i, interpolators, input, threadChunks, numImages, output, fusion, currentTile, transform, fusionImp, count, positionsPerThread, offset, loopDim);
        }
        for (int tileIndex = 0; tileIndex < tiles.size(); ++tileIndex) {
            currentTile[0] = tiles.get(tileIndex);
            for (int threadID = 0; threadID < threads.length; ++threadID) {
                threads[threadID] = new Thread(processors[threadID]);
            }
            int dimensionSize = -1;
            for (int d = 0; d < currentTile[0].size(); ++d) {
                int tmpSize = currentTile[0].get(d).max() - currentTile[0].get(d).min() + 1;
                if (tmpSize <= dimensionSize) continue;
                dimensionSize = tmpSize;
                loopDim[0] = d;
            }
            threadChunks.clear();
            threadChunks.addAll(SimpleMultiThreading.divideIntoChunks((long)dimensionSize, (int)threads.length));
            SimpleMultiThreading.startAndJoin((Thread[])threads);
        }
        if (fusionImp[0] != null) {
            fusionImp[0].hide();
        }
    }

    private static List<ClassifiedRegion> buildTileList(int numImages, int numDimensions, ArrayList<InvertibleBoundable> transform, ArrayList<? extends ImageInterpolation<? extends RealType<?>>> input, double[] offset) {
        Stack<ClassifiedRegion> rawTiles = new Stack<ClassifiedRegion>();
        for (int i = 0; i < numImages; ++i) {
            double[] min = new double[numDimensions];
            transform.get(i).applyInPlace(min);
            ClassifiedRegion shape = new ClassifiedRegion(numDimensions);
            shape.addClass(i);
            for (int d = 0; d < numDimensions; ++d) {
                int n = d;
                min[n] = min[n] - offset[d];
                Interval ival = new Interval((int)Math.ceil(min[d]), (int)Math.floor(min[d] + (double)input.get(i).getImg().dimension(d) - 1.0));
                shape.set(ival, d);
            }
            rawTiles.push(shape);
        }
        HashSet<ClassifiedRegion> placedTiles = new HashSet<ClassifiedRegion>();
        while (!rawTiles.isEmpty()) {
            ClassifiedRegion queryTile = (ClassifiedRegion)rawTiles.pop();
            ClassifiedRegion toRemove = null;
            for (ClassifiedRegion placedTile : placedTiles) {
                if (!queryTile.intersects(placedTile)) continue;
                toRemove = placedTile;
                Fusion.splitOverlappingRegions(placedTiles, rawTiles, queryTile, placedTile);
                break;
            }
            if (toRemove != null) {
                placedTiles.remove(toRemove);
                continue;
            }
            placedTiles.add(queryTile);
        }
        return new ArrayList<ClassifiedRegion>(placedTiles);
    }

    private static void splitOverlappingRegions(Set<ClassifiedRegion> placedTiles, Stack<ClassifiedRegion> rawTiles, ClassifiedRegion queryTile, ClassifiedRegion placedTile) {
        List[] allIntervals = new List[queryTile.size()];
        for (int i = 0; i < allIntervals.length; ++i) {
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            ArrayList<Integer> points = new ArrayList<Integer>();
            points.add(queryTile.get(i).min());
            points.add(queryTile.get(i).max());
            points.add(placedTile.get(i).min());
            points.add(placedTile.get(i).max());
            Collections.sort(points);
            if (((Integer)points.get(0)).equals(points.get(1))) {
                if (((Integer)points.get(2)).equals(points.get(3))) {
                    intervals.add(new Interval((Integer)points.get(0), (Integer)points.get(2)));
                } else if (((Integer)points.get(1)).equals(points.get(2))) {
                    intervals.add(new Interval((Integer)points.get(0)));
                    intervals.add(new Interval((Integer)points.get(0) + 1, (Integer)points.get(3)));
                } else {
                    intervals.add(new Interval((Integer)points.get(0), (Integer)points.get(2)));
                    intervals.add(new Interval((Integer)points.get(2) + 1, (Integer)points.get(3)));
                }
            } else if (((Integer)points.get(1)).equals(points.get(2))) {
                if (((Integer)points.get(2)).equals(points.get(3))) {
                    intervals.add(new Interval((Integer)points.get(3)));
                    intervals.add(new Interval((Integer)points.get(0), (Integer)points.get(3) - 1));
                } else {
                    intervals.add(new Interval((Integer)points.get(0), (Integer)points.get(1) - 1));
                    intervals.add(new Interval((Integer)points.get(1)));
                    intervals.add(new Interval((Integer)points.get(1) + 1, (Integer)points.get(3)));
                }
            } else if (((Integer)points.get(2)).equals(points.get(3))) {
                intervals.add(new Interval((Integer)points.get(0), (Integer)points.get(1) - 1));
                intervals.add(new Interval((Integer)points.get(1), (Integer)points.get(3)));
            } else {
                intervals.add(new Interval((Integer)points.get(0), (Integer)points.get(1) - 1));
                intervals.add(new Interval((Integer)points.get(1), (Integer)points.get(2)));
                intervals.add(new Interval((Integer)points.get(2) + 1, (Integer)points.get(3)));
            }
            allIntervals[i] = intervals;
        }
        int[] pos = new int[allIntervals.length];
        Fusion.buildAllRegions(allIntervals, pos, 0, queryTile, placedTile, placedTiles, rawTiles);
    }

    private static void buildAllRegions(List<Interval>[] allIntervals, int[] ivalIndices, int depth, ClassifiedRegion queryTile, ClassifiedRegion placedTile, Set<ClassifiedRegion> placedTiles, Stack<ClassifiedRegion> rawTiles) {
        if (depth != ivalIndices.length) {
            for (int i = 0; i < allIntervals[depth].size(); ++i) {
                Fusion.buildAllRegions(allIntervals, ivalIndices, depth + 1, queryTile, placedTile, placedTiles, rawTiles);
                int n = depth;
                ivalIndices[n] = ivalIndices[n] + 1;
            }
            ivalIndices[depth] = 0;
            return;
        }
        ClassifiedRegion region = new ClassifiedRegion(allIntervals.length);
        boolean inQuery = true;
        boolean inPlaced = true;
        boolean validIval = true;
        for (int i = 0; validIval && i < allIntervals.length; ++i) {
            Interval newIval = new Interval(allIntervals[i].get(ivalIndices[i]));
            Interval queryIval = queryTile.get(i);
            Interval placedIval = placedTile.get(i);
            region.set(newIval, i);
            inQuery = inQuery && queryIval.contains(newIval.min()) == 0 && queryIval.contains(newIval.max()) == 0;
            inPlaced = inPlaced && placedIval.contains(newIval.min()) == 0 && placedIval.contains(newIval.max()) == 0;
            validIval = inQuery || inPlaced;
        }
        if (validIval) {
            if (inQuery) {
                region.addAllClasses(queryTile);
                rawTiles.push(region);
            }
            if (inPlaced) {
                region.addAllClasses(placedTile);
                if (!inQuery) {
                    placedTiles.add(region);
                }
            }
        }
    }

    protected static <T extends RealType<T>> void fuseBlockNoOverlap(final Img<T> output, final ArrayList<? extends ImageInterpolation<? extends RealType<?>>> input, final double[] offset, final ArrayList<InvertibleBoundable> transform, final boolean displayFusion) {
        final int numDimensions = output.numDimensions();
        int numImages = input.size();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)numImages);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myImage = ai.getAndIncrement();
                    long lastDraw = 0L;
                    ImagePlus fusionImp = null;
                    if (displayFusion && myImage == 0) {
                        try {
                            fusionImp = ((ImagePlusImg)output).getImagePlus();
                            fusionImp.setTitle("fusing...");
                            fusionImp.show();
                        }
                        catch (ImgLibException e) {
                            Log.error("Output image has no ImageJ type: " + (Object)((Object)e));
                        }
                    }
                    Img image = ((ImageInterpolation)input.get(myImage)).getImg();
                    int[] translation = new int[numDimensions];
                    InvertibleBoundable t = (InvertibleBoundable)transform.get(myImage);
                    double[] tmp = new double[numDimensions];
                    t.applyInPlace(tmp);
                    for (int d = 0; d < numDimensions; ++d) {
                        translation[d] = (int)Math.round(tmp[d]);
                    }
                    Cursor cursor = image.localizingCursor();
                    RandomAccess randomAccess = output.randomAccess();
                    int[] pos = new int[numDimensions];
                    int j = 0;
                    while (cursor.hasNext()) {
                        cursor.fwd();
                        cursor.localize(pos);
                        if (myImage == 0 && j++ % 10000 == 0) {
                            lastDraw = Fusion.drawFusion(lastDraw, fusionImp);
                            IJ.showProgress((double)((double)j / (double)image.size()));
                        }
                        for (int d = 0; d < numDimensions; ++d) {
                            int n = d;
                            pos[n] = pos[n] + translation[d];
                            int n2 = d;
                            pos[n2] = (int)((double)pos[n2] - offset[d]);
                        }
                        randomAccess.setPosition(pos);
                        ((RealType)randomAccess.get()).setReal(((RealType)cursor.get()).getRealFloat());
                    }
                    if (fusionImp != null) {
                        fusionImp.hide();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    protected static <T extends RealType<T>> void writeBlock(Img<T> outputSlice, int numSlices, int t, int numTimePoints, int c, int numChannels, ArrayList<? extends ImageInterpolation<? extends RealType<?>>> input, double[] offset, ArrayList<InvertibleBoundable> transform, PixelFusion fusion, String outputDirectory) {
        int numImages = input.size();
        int numDimensions = offset.length;
        List<ClassifiedRegion> tiles = Fusion.buildTileList(numImages, numDimensions, transform, input, offset);
        ArrayList in = new ArrayList();
        for (int i = 0; i < numImages; ++i) {
            in.add(input.get(i).createInterpolator());
        }
        PixelFusion myFusion = fusion.copy();
        try {
            long sliceSize = outputSlice.size();
            for (int slice = 0; slice < numSlices; ++slice) {
                IJ.showStatus((String)("Fusing time point: " + t + " of " + numTimePoints + ", channel: " + c + " of " + numChannels + ", slice: " + (slice + 1) + " of " + numSlices + "..."));
                RandomAccess out = outputSlice.randomAccess();
                double[][] inPos = new double[numImages][numDimensions];
                int[] count = new int[1];
                IJ.showProgress((double)0.0);
                for (long tileIndex = 0L; tileIndex < (long)tiles.size(); ++tileIndex) {
                    ClassifiedRegion currentTile = tiles.get((int)tileIndex);
                    Fusion.writeTile(currentTile, 0, slice, myFusion, transform, offset, in, out, inPos, count, sliceSize, numSlices);
                }
                ImagePlus outImp = ((ImagePlusImg)outputSlice).getImagePlus();
                FileSaver fs = new FileSaver(outImp);
                fs.saveAsTiff(new File(outputDirectory, "img_t" + Fusion.lz(t, numTimePoints) + "_z" + Fusion.lz(slice + 1, numSlices) + "_c" + Fusion.lz(c, numChannels)).getAbsolutePath());
            }
        }
        catch (NoninvertibleModelException e) {
            Log.error("Cannot invert model, qutting.");
            return;
        }
        catch (ImgLibException e) {
            Log.error("Output image has no ImageJ type: " + (Object)((Object)e));
            return;
        }
    }

    private static <T extends RealType<T>> void writeTile(ClassifiedRegion r, int depth, int slice, PixelFusion myFusion, ArrayList<InvertibleBoundable> transform, double[] offset, ArrayList<RealRandomAccess<? extends RealType<?>>> in, RandomAccess<T> out, double[][] inPos, int[] count, long sliceSize, int numSlices) throws NoninvertibleModelException {
        int index;
        double value;
        if (depth < out.numDimensions()) {
            Interval d = r.get(depth);
            int start = d.min();
            int end = d.max();
            out.setPosition(start, depth);
            for (int i = start; i < end; ++i) {
                Fusion.writeTile(r, depth + 1, slice, myFusion, transform, offset, in, out, inPos, count, sliceSize, numSlices);
                out.fwd(depth);
            }
            Fusion.writeTile(r, depth + 1, slice, myFusion, transform, offset, in, out, inPos, count, sliceSize, numSlices);
            return;
        }
        myFusion.clear();
        int[] images = r.classArray();
        for (int d = 0; d < out.numDimensions(); ++d) {
            value = out.getDoublePosition(d) + offset[d];
            for (index = 0; index < images.length; ++index) {
                inPos[images[index]][d] = value;
            }
        }
        if (r.size() > out.numDimensions()) {
            int dim = r.size() - 1;
            value = (double)slice + offset[dim];
            for (index = 0; index < images.length; ++index) {
                inPos[images[index]][dim] = value;
            }
        }
        for (int index2 = 0; index2 < images.length; ++index2) {
            int image = images[index2];
            transform.get(image).applyInverseInPlace(inPos[image]);
            in.get(image).setPosition(inPos[image]);
            myFusion.addValue(((RealType)in.get(image).get()).getRealFloat(), image, inPos[image]);
        }
        ((RealType)out.get()).setReal(myFusion.getValue());
        ((RealType)out.get()).setReal(myFusion.getValue());
        count[0] = count[0] + 1;
        if (count[0] % 10000 == 0) {
            IJ.showProgress((double)((double)((long)count[0] + (long)slice * sliceSize) / (double)((long)numSlices * sliceSize)));
        }
    }

    private static final String lz(int num, int max) {
        String out = "" + num;
        String outMax = "" + max;
        while (out.length() < outMax.length()) {
            out = "0" + out;
        }
        return out;
    }

    public static void estimateBounds(double[] offset, int[] size, List<ImagePlus> images, ArrayList<InvertibleBoundable> models, int dimensionality) {
        int[][] imgSizes = new int[images.size()][dimensionality];
        for (int i = 0; i < images.size(); ++i) {
            imgSizes[i][0] = images.get(i).getWidth();
            imgSizes[i][1] = images.get(i).getHeight();
            if (dimensionality != 3) continue;
            imgSizes[i][2] = images.get(i).getNSlices();
        }
        Fusion.estimateBounds(offset, size, imgSizes, models, dimensionality);
    }

    public static void estimateBounds(double[] offset, int[] size, int[][] imgSizes, ArrayList<InvertibleBoundable> models, int dimensionality) {
        int d;
        int i;
        int numImages = imgSizes.length;
        int numTimePoints = models.size() / numImages;
        double[][] max = new double[numImages * numTimePoints][];
        double[][] min = new double[numImages * numTimePoints][dimensionality];
        if (dimensionality == 2) {
            for (i = 0; i < numImages * numTimePoints; ++i) {
                max[i] = new double[]{imgSizes[i % numImages][0], imgSizes[i % numImages][1]};
            }
        } else {
            for (i = 0; i < numImages * numTimePoints; ++i) {
                max[i] = new double[]{imgSizes[i % numImages][0], imgSizes[i % numImages][1], imgSizes[i % numImages][2]};
            }
        }
        ArrayList<InvertibleBoundable> boundables = new ArrayList<InvertibleBoundable>();
        for (int i2 = 0; i2 < numImages * numTimePoints; ++i2) {
            InvertibleBoundable boundable = models.get(i2);
            boundables.add(boundable);
            boundable.estimateBounds(min[i2], max[i2]);
        }
        double[] minImg = new double[dimensionality];
        double[] maxImg = new double[dimensionality];
        if (max.length == 1) {
            for (d = 0; d < dimensionality; ++d) {
                maxImg[d] = Math.max(max[0][d], min[0][d]);
                minImg[d] = Math.min(max[0][d], min[0][d]);
            }
        } else {
            for (d = 0; d < dimensionality; ++d) {
                maxImg[d] = Math.max(Math.max(max[0][d], max[1][d]), Math.max(min[0][d], min[1][d]));
                minImg[d] = Math.min(Math.min(max[0][d], max[1][d]), Math.min(min[0][d], min[1][d]));
                for (int i3 = 2; i3 < numImages * numTimePoints; ++i3) {
                    maxImg[d] = Math.max(maxImg[d], Math.max(min[i3][d], max[i3][d]));
                    minImg[d] = Math.min(minImg[d], Math.min(min[i3][d], max[i3][d]));
                }
            }
        }
        for (d = 0; d < dimensionality; ++d) {
            size[d] = (int)Math.round(maxImg[d] - minImg[d]);
            offset[d] = minImg[d];
        }
    }

    private static long drawFusion(long lastDraw, ImagePlus fusion) {
        long t = System.currentTimeMillis();
        if (fusion != null && t - lastDraw > redrawDelay) {
            fusion.updateAndDraw();
            return t;
        }
        return lastDraw;
    }

    public static void main(String[] args) {
        new ImageJ();
        ArrayImgFactory f = new ArrayImgFactory();
        Img img = f.create(new int[]{400, 400}, (Object)new FloatType());
        Cursor c = img.localizingCursor();
        int numDimensions = img.numDimensions();
        double[] tmp = new double[numDimensions];
        long[] dimensions = new long[numDimensions];
        img.dimensions(dimensions);
        float percentScaling = 0.2f;
        double[] border = new double[numDimensions];
        while (c.hasNext()) {
            c.fwd();
            for (int d = 0; d < numDimensions; ++d) {
                tmp[d] = c.getFloatPosition(d);
            }
            ((FloatType)c.get()).set((float)BlendingPixelFusion.computeWeight(tmp, dimensions, border, 0.2f));
        }
        ImageJFunctions.show((RandomAccessibleInterval)img);
        Log.debug("done");
    }

    private static class TileProcessor<T extends RealType<T>>
    implements Runnable {
        private int loopOffset;
        private int loopSize;
        private final int[] loopDim;
        private Vector<Chunk> threadChunks;
        private final int threadNumber;
        private ClassifiedRegion[] currentTile;
        private ArrayList<InvertibleBoundable> transform;
        private ImagePlus[] fusionImp;
        private int[] count;
        private double positionsPerThread;
        private double[] offset;
        private long[] lastDraw = new long[1];
        private final ArrayList<RealRandomAccess<? extends RealType<?>>> in;
        private final double[][] inPos;
        private final PixelFusion myFusion;
        private final RandomAccess<T> out;

        public TileProcessor(int threadNumber, List<ArrayList<RealRandomAccess<? extends RealType<?>>>> interpolators, ArrayList<? extends ImageInterpolation<? extends RealType<?>>> input, Vector<Chunk> threadChunks, int numImages, Img<T> output, PixelFusion fusion, ClassifiedRegion[] currentTile, ArrayList<InvertibleBoundable> transform, ImagePlus[] fusionImp, int[] count, double positionsPerThread, double[] offset, int[] loopDim) {
            this.threadNumber = threadNumber;
            this.threadChunks = threadChunks;
            this.currentTile = currentTile;
            this.transform = transform;
            this.fusionImp = fusionImp;
            this.count = count;
            this.positionsPerThread = positionsPerThread;
            this.offset = offset;
            this.loopDim = loopDim;
            this.in = this.getThreadInterpolators(interpolators, threadNumber, input, numImages);
            this.inPos = new double[numImages][output.numDimensions()];
            this.myFusion = fusion.copy();
            this.out = output.randomAccess();
        }

        @Override
        public void run() {
            Chunk myChunk = this.threadChunks.get(this.threadNumber);
            this.loopOffset = (int)myChunk.getStartPosition();
            this.loopSize = (int)myChunk.getLoopSize();
            try {
                this.processTile(this.currentTile[0], 0, this.myFusion, this.transform, this.in, this.out, this.inPos, this.threadNumber, this.count, this.lastDraw, this.fusionImp[0]);
            }
            catch (NoninvertibleModelException e) {
                Log.error("Cannot invert model, qutting.");
                return;
            }
        }

        private ArrayList<RealRandomAccess<? extends RealType<?>>> getThreadInterpolators(List<ArrayList<RealRandomAccess<? extends RealType<?>>>> interpolators, int threadNumber, ArrayList<? extends ImageInterpolation<? extends RealType<?>>> input, int numImages) {
            ArrayList<RealRandomAccess<RealType<?>>> in = null;
            if (threadNumber >= interpolators.size()) {
                in = new ArrayList();
                for (int i = 0; i < numImages; ++i) {
                    in.add(input.get(i).createInterpolator());
                }
                interpolators.add(in);
            } else {
                in = interpolators.get(threadNumber);
            }
            return in;
        }

        private void processTile(ClassifiedRegion r, int depth, PixelFusion myFusion, ArrayList<InvertibleBoundable> transform, ArrayList<RealRandomAccess<? extends RealType<?>>> in, RandomAccess<T> out, double[][] inPos, int threadNumber, int[] count, long[] lastDraw, ImagePlus fusionImp) throws NoninvertibleModelException {
            this.processTile(r, r.classArray(), depth, myFusion, transform, in, out, inPos, threadNumber, count, lastDraw, fusionImp);
        }

        private void processTile(ClassifiedRegion r, int[] images, int depth, PixelFusion myFusion, ArrayList<InvertibleBoundable> transform, ArrayList<RealRandomAccess<? extends RealType<?>>> in, RandomAccess<T> out, double[][] inPos, int threadNumber, int[] count, long[] lastDraw, ImagePlus fusionImp) throws NoninvertibleModelException {
            if (depth < r.size()) {
                Interval d = r.get(depth);
                int start = d.min();
                int end = d.max();
                if (depth == this.loopDim[0]) {
                    end = (start += this.loopOffset) + this.loopSize - 1;
                }
                out.setPosition(start, depth);
                for (int i = start; i < end; ++i) {
                    this.processTile(r, images, depth + 1, myFusion, transform, in, out, inPos, threadNumber, count, lastDraw, fusionImp);
                    out.fwd(depth);
                }
                this.processTile(r, images, depth + 1, myFusion, transform, in, out, inPos, threadNumber, count, lastDraw, fusionImp);
                return;
            }
            myFusion.clear();
            for (int d = 0; d < r.size(); ++d) {
                double value = out.getDoublePosition(d) + this.offset[d];
                for (int index = 0; index < images.length; ++index) {
                    inPos[images[index]][d] = value;
                }
            }
            for (int index = 0; index < images.length; ++index) {
                int image = images[index];
                transform.get(image).applyInverseInPlace(inPos[image]);
                in.get(image).setPosition(inPos[image]);
                myFusion.addValue(((RealType)in.get(image).get()).getRealFloat(), image, inPos[image]);
            }
            ((RealType)out.get()).setReal(myFusion.getValue());
            if (threadNumber == 0) {
                count[0] = count[0] + 1;
                if (count[0] % 10000 == 0) {
                    lastDraw[0] = Fusion.drawFusion(lastDraw[0], fusionImp);
                    IJ.showProgress((double)((double)count[0] / this.positionsPerThread));
                }
            }
        }
    }
}

