/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.SingleOperandPixelBasedAbstractFunction;
import net.imglib2.type.numeric.RealType;

public final class ImgLibSine<T extends RealType<T>>
extends SingleOperandPixelBasedAbstractFunction<T> {
    public static final String DOCUMENTATION_STRING = "<h3>Element-wise sine</h3> This function computes the sine of an ImgLib image, taking each pixel as its operand (must be in radians). Calculations are done using <i>Math.sin</i>.";

    public ImgLibSine() {
        this.numberOfParameters = 1;
    }

    @Override
    public final <R extends RealType<R>> float evaluate(R alpha) {
        return (float)Math.sin(alpha.getRealDouble());
    }

    @Override
    public String getDocumentationString() {
        return DOCUMENTATION_STRING;
    }

    @Override
    public String getFunctionString() {
        return "sin";
    }

    @Override
    public String toString() {
        return "Pixel-wise sine";
    }
}

