/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.ImgLibFunction;
import java.util.Stack;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public abstract class TwoOperandsAbstractFunction<T extends RealType<T>>
extends PostfixMathCommand
implements ImgLibFunction<T> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        FloatType result = null;
        if (param1 instanceof Img) {
            if (param2 instanceof Img) {
                result = this.evaluate((RealType)((Img)param1), (Img)((Img)param2));
            } else {
                if (!(param2 instanceof RealType)) throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand 2: " + param2.getClass().getSimpleName());
                FloatType t2 = (FloatType)param2;
                result = this.evaluate((Img)param1, t2);
            }
        } else {
            if (!(param1 instanceof FloatType)) throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand 1: " + param1.getClass().getSimpleName());
            FloatType t1 = (FloatType)param1;
            if (param2 instanceof Img) {
                result = this.evaluate(t1, (Img)param2);
            } else {
                if (!(param2 instanceof FloatType)) throw new ParseException("In function '" + this.getFunctionString() + "': Bad type of operand 2: " + param2.getClass().getSimpleName());
                FloatType t2 = (FloatType)param2;
                result = new FloatType(this.evaluate(t1, t2));
            }
        }
        inStack.push(result);
    }

    public abstract <R extends RealType<R>> float evaluate(R var1, R var2) throws ParseException;

    public abstract <R extends RealType<R>> Img<FloatType> evaluate(Img<R> var1, Img<R> var2) throws ParseException;

    public abstract <R extends RealType<R>> Img<FloatType> evaluate(Img<R> var1, R var2) throws ParseException;

    public abstract <R extends RealType<R>> Img<FloatType> evaluate(R var1, Img<R> var2) throws ParseException;
}

