/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import ij.gui.Plot;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import view5d.AGenericDialog;
import view5d.APoint;
import view5d.AlternateViewer;
import view5d.AnElement;
import view5d.Bundle;
import view5d.ImgPanel;
import view5d.MarkerLists;
import view5d.My3DData;
import view5d.MyMenuProcessor;
import view5d.PositionLabel;
import view5d.View5D;
import view5d.View5D_;

public class ImageCanvas
extends Canvas
implements ImageObserver,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener,
AdjustmentListener {
    static final long serialVersionUID = 1L;
    int dadd = 0;
    int xprev = 0;
    int yprev = 0;
    int ROIs;
    int ROIe;
    boolean LineROIStarted = false;
    int LROIs = -1;
    int LROIe = -1;
    boolean ROIMoveStarted = false;
    int ROIMoveStartX;
    int ROIMoveStartY;
    int ROIMoveDX = 0;
    int ROIMoveDY = 0;
    Polygon tmpROIPolygons = null;
    boolean ImgDragStarted = false;
    int ximgdrag = 0;
    int yimgdrag = 0;
    int imgw = -1;
    int imgh = -1;
    int defaultTimeElementChoice = 1;
    double scale = 1.0;
    double[] LineData;
    double[] AxisData;
    String XAxisTitle = "X";
    String YAxisTitle = "Y";
    boolean AspectFromView = false;
    CheckboxMenuItem AspectLocked;
    boolean focus = false;
    boolean DispPlot = false;
    Image curimage;
    Container applet;
    ImgPanel myPanel;
    ImageCanvas otherCanvas1;
    ImageCanvas otherCanvas2;
    My3DData my3ddata;
    Vector<Integer> PlanesXs = new Vector();
    Vector<Integer> PlanesYs = new Vector();
    Vector<Integer> PlanesXe = new Vector();
    Vector<Integer> PlanesYe = new Vector();
    boolean hastoinit = true;
    int DimNr = 0;
    String mytitle = "A Slice";
    PositionLabel label;
    PopupMenu MyPopupMenu;
    public double PositionValue = 1.0;
    public double DataOffset = 0.0;
    private int MaxPos = 1;
    static final long updateRate = 100L;

    public ImageCanvas(Container app, ImgPanel mp, My3DData data3d, int mydimnr, String myt) {
        this.MyPopupMenu = new PopupMenu(myt);
        this.add(this.MyPopupMenu);
        Menu SubMenu = new Menu("Navigation", false);
        this.MyPopupMenu.add(SubMenu);
        MenuItem tmp = new MenuItem("Next slice [page up, ) ]");
        tmp.addActionListener(new MyMenuProcessor(this, ')'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Previous slice [page down, ( ]");
        tmp.addActionListener(new MyMenuProcessor(this, '('));
        SubMenu.add(tmp);
        tmp = new MenuItem("Next element (color) [e]");
        tmp.addActionListener(new MyMenuProcessor(this, 'e'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Previous element (color) [E]");
        tmp.addActionListener(new MyMenuProcessor(this, 'E'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Next time [shift-down, ',']");
        tmp.addActionListener(new MyMenuProcessor(this, ','));
        SubMenu.add(tmp);
        tmp = new MenuItem("Previous time [shift-up, '.']");
        tmp.addActionListener(new MyMenuProcessor(this, '.'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Display", false);
        this.MyPopupMenu.add(SubMenu);
        tmp = new MenuItem("Initialize [i]");
        tmp.addActionListener(new MyMenuProcessor(this, 'i'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Initi Global Threshold [I]");
        tmp.addActionListener(new MyMenuProcessor(this, 'I'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Toggle Plot Display [q]");
        tmp.addActionListener(new MyMenuProcessor(this, 'q'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Zoom into square ROI [Z]");
        tmp.addActionListener(new MyMenuProcessor(this, 'Z'));
        SubMenu.add(tmp);
        this.AspectLocked = new CheckboxMenuItem("Aspect Locked [@]");
        SubMenu.add(this.AspectLocked);
        this.AspectLocked.addActionListener(new MyMenuProcessor(this, '@'));
        tmp = new MenuItem("Zoom in [A]");
        tmp.addActionListener(new MyMenuProcessor(this, 'A'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Zoom out [a]");
        tmp.addActionListener(new MyMenuProcessor(this, 'a'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Zoom in perpend. [>]");
        tmp.addActionListener(new MyMenuProcessor(this, '>'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Zoom in perpend. [<]");
        tmp.addActionListener(new MyMenuProcessor(this, '<'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Projections", false);
        this.MyPopupMenu.add(SubMenu);
        tmp = new MenuItem("Toggle max intensity projection [p]");
        tmp.addActionListener(new MyMenuProcessor(this, 'p'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Toggle sum projection [P]");
        tmp.addActionListener(new MyMenuProcessor(this, 'P'));
        SubMenu.add(tmp);
        this.applet = app;
        this.myPanel = mp;
        this.my3ddata = data3d;
        this.DimNr = mydimnr;
        this.mytitle = myt;
        this.MaxPos = data3d.sizes[mydimnr];
        this.PositionValue = this.MaxPos / 2;
        this.ROIs = 0;
        this.ROIe = this.MaxPos - 1;
        this.setBounds(0, 0, 100, 100);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
    }

    public int getMaxPos() {
        return this.MaxPos;
    }

    public void TakeOtherCanvas1(ImageCanvas thecan) {
        this.otherCanvas1 = thecan;
    }

    public void TakeOtherCanvas2(ImageCanvas thecan) {
        this.otherCanvas2 = thecan;
    }

    public void ConnectLabel(PositionLabel alabel) {
        this.label = alabel;
    }

    public boolean LimitPosition(int space) {
        if ((double)space > this.scale * (double)this.MaxPos) {
            if (this.dadd < 0) {
                this.dadd = 0;
                return false;
            }
            if ((double)(space - this.dadd) - this.scale * (double)this.MaxPos < 0.0) {
                this.dadd = space - (int)(this.scale * (double)this.MaxPos);
                return false;
            }
        } else {
            if (this.dadd > 0) {
                this.dadd = 0;
                return false;
            }
            if ((double)(space - this.dadd) - this.scale * (double)this.MaxPos > 0.0) {
                this.dadd = space - (int)(this.scale * (double)this.MaxPos);
                return false;
            }
        }
        return true;
    }

    public void InitScaling() {
        Rectangle r = this.getBounds();
        double myaspect = this.my3ddata.GetScale(0, this.otherCanvas1.DimNr) / this.my3ddata.GetScale(0, this.otherCanvas2.DimNr);
        double myZaspect = this.my3ddata.GetScale(0, this.otherCanvas1.DimNr) / this.my3ddata.GetScale(0, this.DimNr);
        double scalex = (double)r.width / (double)this.otherCanvas1.MaxPos;
        double scaley = (double)r.height / (double)this.otherCanvas2.MaxPos;
        if (this.AspectLocked.getState() || this.AspectFromView) {
            if (scalex > scaley * myaspect) {
                scalex = scaley * myaspect;
            } else {
                scaley = scalex / myaspect;
            }
            scaley = scalex / myaspect;
            this.otherCanvas1.scale = scalex;
            this.otherCanvas1.dadd = 0;
            this.otherCanvas2.scale = scaley;
            this.otherCanvas2.dadd = 0;
            if (this.otherCanvas1.AspectLocked.getState() || this.otherCanvas1.AspectFromView || this.otherCanvas2.AspectLocked.getState() || this.otherCanvas2.AspectFromView) {
                this.scale = scalex / myZaspect;
            }
        }
        if (!this.otherCanvas2.AspectLocked.getState()) {
            this.otherCanvas1.scale = scalex;
            this.otherCanvas1.dadd = 0;
        }
        if (!this.otherCanvas1.AspectLocked.getState()) {
            this.otherCanvas2.scale = scaley;
            this.otherCanvas2.dadd = 0;
        }
        this.DispPlot = false;
        if (this.DimNr == 0 && this.my3ddata.GetSize(2) <= 1) {
            this.DispPlot = true;
        }
        if (this.DimNr == 1 && this.my3ddata.GetSize(2) <= 1) {
            this.DispPlot = true;
        }
        if (this.DimNr == 2 && this.my3ddata.GetSize(0) <= 1) {
            this.DispPlot = true;
        }
    }

    Color GetMarkerColor(int e) {
        return this.my3ddata.GetMarkerColor(e);
    }

    public void plot(Graphics g) {
        int pos;
        int pz;
        int py;
        int px;
        int Size;
        Rectangle r = this.getBounds();
        g.setColor(Color.black);
        g.fillRect(0, 0, r.width - 1, r.height - 1);
        g.setColor(Color.white);
        g.setFont(new Font(this.my3ddata.FontType, 0, this.my3ddata.FontSize));
        int ActPos = 0;
        int XAxisDim = 0;
        double xDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas1.DimNr];
        double yDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas2.DimNr];
        double Off = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.DimNr];
        if (this.DimNr == 0) {
            Size = this.my3ddata.SizeY;
            px = (int)this.PositionValue;
            py = (int)this.otherCanvas2.PositionValue;
            pz = (int)this.otherCanvas1.PositionValue;
            g.drawLine(r.width - 10, 10, r.width - 10, r.height - 10);
            g.setColor(Color.green);
            ActPos = (int)this.otherCanvas2.PositionValue;
            pos = this.MouseFromY(ActPos + (int)yDOff) + (int)(0.5 * this.otherCanvas2.scale);
            g.drawLine(0, pos, r.width - 1, pos);
            XAxisDim = 1;
        } else if (this.DimNr == 1) {
            Size = this.my3ddata.SizeX;
            px = (int)this.otherCanvas1.PositionValue;
            py = (int)this.PositionValue;
            pz = (int)this.otherCanvas2.PositionValue;
            g.drawLine(10, r.height - 10, r.width - 10, r.height - 10);
            g.setColor(Color.green);
            ActPos = (int)this.otherCanvas1.PositionValue;
            pos = this.MouseFromX(ActPos + (int)xDOff) + (int)(0.5 * this.otherCanvas1.scale);
            g.drawLine(pos, 0, pos, r.height - 1);
            XAxisDim = 0;
        } else {
            Size = this.my3ddata.SizeZ;
            px = (int)this.otherCanvas1.PositionValue;
            py = (int)this.otherCanvas2.PositionValue;
            pz = (int)this.PositionValue;
            g.drawLine(10, r.height - 10, r.width - 10, r.height - 10);
            g.setColor(Color.green);
            ActPos = (int)this.PositionValue;
            pos = (ActPos + (int)Off) * r.width / this.MaxPos + (int)(0.5 * this.scale);
            g.drawLine(pos, 0, pos, r.height - 1);
            XAxisDim = 2;
        }
        String XAxisName = this.my3ddata.GetAxisNames()[XAxisDim];
        String XAxisUnit = this.my3ddata.GetAxisUnits()[XAxisDim];
        this.XAxisTitle = XAxisName + " [" + XAxisUnit + "]";
        String YAxisName = this.my3ddata.GetValueName(this.my3ddata.GetActiveElement());
        String YAxisUnit = this.my3ddata.GetValueUnit(this.my3ddata.GetActiveElement());
        if (this.my3ddata.GetProjectionMode(this.DimNr)) {
            String test = !this.my3ddata.GetMIPMode(this.DimNr) ? ", Avg. Proj." : ", Max. Proj.";
            g.drawString(test, r.width - test.length() * this.my3ddata.FontSize, 12);
            this.YAxisTitle = YAxisName + " [" + YAxisUnit + "]" + test;
        } else {
            this.YAxisTitle = YAxisName + " [" + YAxisUnit + "]";
        }
        int lxnew = 0;
        int lxold = 0;
        int lynew = 0;
        int lyold = 0;
        for (int e = 0; e < this.my3ddata.Elements; ++e) {
            xDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas1.DimNr];
            yDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas2.DimNr];
            Off = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.DimNr];
            if (!this.my3ddata.InOverlayDispl(e) && this.my3ddata.ActiveElement != e) continue;
            g.setColor(this.GetMarkerColor(e));
            for (int pos2 = 0; pos2 < Size; ++pos2) {
                double val = 0.0;
                double valtrue = 0.0;
                if (!this.my3ddata.ProjMode[this.DimNr]) {
                    if (this.DimNr == 0) {
                        val = this.my3ddata.NormedValueAt(px, pos2, pz, e);
                        valtrue = this.my3ddata.ValueAt(px, pos2, pz, e);
                        lynew = this.MouseFromY(pos2 + (int)yDOff) + (int)(0.5 * this.otherCanvas2.scale);
                        lxnew = r.width - 10 - (int)((double)(r.width - 20) * val);
                    } else if (this.DimNr == 1) {
                        val = this.my3ddata.NormedValueAt(pos2, py, pz, e);
                        valtrue = this.my3ddata.ValueAt(pos2, py, pz, e);
                        lxnew = this.MouseFromX(pos2 + (int)xDOff) + (int)(0.5 * this.otherCanvas1.scale);
                        lynew = r.height - 10 - (int)((double)(r.height - 20) * val);
                    } else if (this.DimNr == 2) {
                        val = this.my3ddata.NormedValueAt(px, py, pos2, e);
                        valtrue = this.my3ddata.ValueAt(px, py, pos2, e);
                        lxnew = (pos2 + (int)Off) * r.width / Size + (int)(0.5 * this.scale);
                        lynew = r.height - 10 - (int)((double)(r.height - 20) * val);
                    }
                } else {
                    val = this.my3ddata.NormedProjValueAt(this.DimNr, pos2, e);
                    valtrue = this.my3ddata.ProjValueAt(this.DimNr, pos2, e);
                    if (this.DimNr == 0) {
                        lynew = this.MouseFromY(pos2 + (int)yDOff) + (int)(0.5 * this.otherCanvas2.scale);
                        lxnew = r.width - 10 - (int)((double)(r.width - 20) * val);
                    } else if (this.DimNr == 1) {
                        lxnew = this.MouseFromX(pos2 + (int)xDOff) + (int)(0.5 * this.otherCanvas1.scale);
                        lynew = r.height - 10 - (int)((double)(r.height - 20) * val);
                    } else if (this.DimNr == 2) {
                        lxnew = (pos2 + (int)Off) * r.width / Size + (int)(0.5 * this.scale);
                        lynew = r.height - 10 - (int)((double)(r.height - 20) * val);
                    }
                }
                if (pos2 != 0) {
                    g.drawLine(lxold, lyold, lxnew, lynew);
                }
                if (e == this.my3ddata.GetActiveElement()) {
                    if (this.LineData == null) {
                        this.LineData = new double[Size];
                    }
                    this.LineData[pos2] = valtrue;
                    if (this.AxisData == null) {
                        this.AxisData = new double[Size];
                    }
                    this.AxisData[pos2] = (double)pos2 * this.my3ddata.GetScale(0, XAxisDim) + this.my3ddata.GetOffset(0, XAxisDim);
                    if (pos2 == ActPos) {
                        g.fillOval(lxnew - 5, lynew - 5, 10, 10);
                        if (this.my3ddata.ProjMode[this.DimNr]) {
                            double ProjVal = this.my3ddata.ProjValueAt(this.DimNr, pos2, e);
                            g.drawString(this.label.CreateValueString(ProjVal), 5, this.my3ddata.FontSize);
                        } else {
                            g.drawString(this.label.GetValueString(), 5, this.my3ddata.FontSize);
                            g.drawString(this.label.GetPositionString(), 5, 2 * this.my3ddata.FontSize);
                        }
                        if (this.my3ddata.GetLogMode()) {
                            String test = "Log. Mode";
                            g.drawString(test, r.width - test.length() * this.my3ddata.FontSize, 2 * this.my3ddata.FontSize);
                        }
                    }
                }
                lxold = lxnew;
                lyold = lynew;
            }
        }
        g.setColor(Color.white);
        if (this.my3ddata.SquareROIs() && (this.otherCanvas1.ROIs >= 0 || this.otherCanvas2.ROIs >= 0)) {
            if (this.DimNr == 1) {
                int xre;
                int xrs = this.MouseFromX(this.otherCanvas1.ROIs);
                if (xrs > (xre = this.MouseFromX(this.otherCanvas1.ROIe))) {
                    int tmp = xrs;
                    xrs = xre;
                    xre = tmp;
                }
                g.drawRect(xrs, 0, xre - xrs, r.height - 9);
            } else if (this.DimNr == 0) {
                int yre;
                int yrs = this.MouseFromY(this.otherCanvas2.ROIs);
                if (yrs > (yre = this.MouseFromY(this.otherCanvas2.ROIe))) {
                    int tmp = yrs;
                    yrs = yre;
                    yre = tmp;
                }
                g.drawRect(0, yrs, r.width - 9, yre - yrs);
            } else {
                g.drawRect(this.ROIs * r.width / this.MaxPos, 0, (this.ROIe - this.ROIs) * r.width / this.MaxPos, r.height - 9);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int yp;
        Rectangle r = this.getBounds();
        if (this.hastoinit) {
            this.hastoinit = false;
            this.InitScaling();
            this.CalcPrev();
            this.otherCanvas1.repaint();
            this.otherCanvas2.repaint();
        }
        if (this.DispPlot) {
            this.plot(g);
            return;
        }
        int xm = (int)((double)this.otherCanvas1.MaxPos * this.otherCanvas1.scale);
        int ym = (int)((double)this.otherCanvas2.MaxPos * this.otherCanvas2.scale);
        int xOff = this.otherCanvas1.PixelFromDataPos(this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas1.DimNr]);
        int yOff = this.otherCanvas2.PixelFromDataPos(this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas2.DimNr]);
        g.drawImage(this.curimage, xOff, yOff, xm, ym, this);
        g.setFont(new Font(this.my3ddata.FontType, 0, this.my3ddata.FontSize));
        g.setColor(Color.black);
        g.fillRect(0, 0, r.width - 1, yOff);
        g.fillRect(0, 0, xOff, r.height - 1);
        g.fillRect(xm + 1 + xOff, 0, r.width - 1, r.height - 1);
        g.fillRect(0, ym + 1 + yOff, r.width - 1, r.height - 1);
        if (this.focus) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.darkGray);
        }
        g.drawRect(0, 0, r.width - 1, r.height - 1);
        g.setColor(Color.white);
        if (this.ROIMoveStarted) {
            g.setColor(Color.gray);
        }
        if (this.my3ddata.SquareROIs()) {
            int yre;
            int xre;
            int yrs;
            int xrs;
            if (this.myPanel.ROIstarted) {
                xrs = this.DMouseFromX(this.otherCanvas1.ROIs);
                yrs = this.DMouseFromY(this.otherCanvas2.ROIs);
                xre = this.DMouseFromX(this.otherCanvas1.ROIe);
                yre = this.DMouseFromY(this.otherCanvas2.ROIe);
            } else {
                Rectangle r2 = this.my3ddata.GetSqrROI(this.DimNr);
                xrs = this.DMouseFromX(r2.x + this.ROIMoveDX);
                yrs = this.DMouseFromY(r2.y + this.ROIMoveDY);
                xre = this.DMouseFromX(r2.x + r2.width + this.ROIMoveDX);
                yre = this.DMouseFromY(r2.y + r2.height + this.ROIMoveDY);
            }
            if (xrs > xre) {
                int tmp = xrs;
                xrs = xre;
                xre = tmp;
            }
            if (yrs > yre) {
                int tmp = yrs;
                yrs = yre;
                yre = tmp;
            }
            g.drawRect(xrs, yrs, xre - xrs, yre - yrs);
        } else {
            if (this.LineROIStarted && this.tmpROIPolygons != null) {
                int xold = 0;
                int yold = 0;
                int xnew = 0;
                int ynew = 0;
                for (int s = 0; s < this.tmpROIPolygons.npoints; ++s) {
                    xnew = this.tmpROIPolygons.xpoints[s];
                    ynew = this.tmpROIPolygons.ypoints[s];
                    xnew = this.DMouseFromX(xnew + this.ROIMoveDX);
                    ynew = this.DMouseFromY(ynew + this.ROIMoveDY);
                    if (s > 0) {
                        g.drawLine(xold, yold, xnew, ynew);
                    }
                    xold = xnew;
                    yold = ynew;
                }
                int xrs = this.DMouseFromX(this.otherCanvas1.LROIs);
                int yrs = this.DMouseFromY(this.otherCanvas2.LROIs);
                int xre = this.DMouseFromX(this.otherCanvas1.LROIe);
                int yre = this.DMouseFromY(this.otherCanvas2.LROIe);
                g.drawLine(xrs, yrs, xre, yre);
            }
            float[] coords = new float[2];
            int Rsize = this.my3ddata.GetPolyROISize(this.DimNr);
            if (Rsize > 0) {
                int ynew;
                int xnew;
                this.my3ddata.GetPolyROICoords(this.DimNr, 0, coords);
                int xold = this.DMouseFromX(coords[0] + (float)this.ROIMoveDX);
                int yold = this.DMouseFromY(coords[1] + (float)this.ROIMoveDY);
                for (int s = 1; s < Rsize; ++s) {
                    this.my3ddata.GetPolyROICoords(this.DimNr, s, coords);
                    xnew = this.DMouseFromX(coords[0] + (float)this.ROIMoveDX);
                    ynew = this.DMouseFromY(coords[1] + (float)this.ROIMoveDY);
                    g.drawLine(xold, yold, xnew, ynew);
                    xold = xnew;
                    yold = ynew;
                }
                this.my3ddata.GetPolyROICoords(this.DimNr, 0, coords);
                xnew = this.DMouseFromX(coords[0] + (float)this.ROIMoveDX);
                ynew = this.DMouseFromY(coords[1] + (float)this.ROIMoveDY);
                g.drawLine(xold, yold, xnew, ynew);
            }
        }
        int xprev = 0;
        int yprev = 0;
        int px = (int)this.myPanel.c2.PositionValue;
        int py = (int)this.myPanel.c3.PositionValue;
        int pz = (int)this.myPanel.c1.PositionValue;
        int element = this.my3ddata.ActiveElement;
        int time = this.my3ddata.ActiveTime;
        int[] ActPosition = new int[]{px, py, pz, element, time};
        NumberFormat nf2 = NumberFormat.getNumberInstance(Locale.US);
        nf2.setMaximumFractionDigits(4);
        nf2.setGroupingUsed(false);
        boolean foundactive = false;
        for (int l = 0; l < this.my3ddata.NumMarkerLists(); ++l) {
            int actlistpos = this.my3ddata.ActiveMarkerListPos();
            boolean didannotate = false;
            if (!this.my3ddata.ShowAllLists && l != actlistpos) continue;
            for (int p = 0; p < this.my3ddata.NumMarkers(l); ++p) {
                int xp;
                APoint Pt = this.my3ddata.GetPoint(p, l);
                if (this.my3ddata.ShowSpectralTrack) {
                    g.setColor(Bundle.ColFromHue((float)Pt.coord[this.my3ddata.TrackDirection] / (float)this.my3ddata.sizes[this.my3ddata.TrackDirection]));
                } else {
                    g.setColor(new Color(Pt.mycolor));
                }
                double[] coords = Pt.coord;
                if (this.DimNr == 0) {
                    xp = this.DMouseFromX(coords[2]);
                    yp = this.DMouseFromY(coords[1]);
                } else if (this.DimNr == 1) {
                    xp = this.DMouseFromX(coords[0]);
                    yp = this.DMouseFromY(coords[2]);
                } else {
                    xp = this.DMouseFromX(coords[0]);
                    yp = this.DMouseFromY(coords[1]);
                }
                Pt.isDisplayed = this.my3ddata.MarkerDisplayed(Pt, ActPosition);
                int xDOff = this.otherCanvas1.PixelFromDataPos(this.my3ddata.ElementAt((int)((int)(Pt.coord[3] + 0.5)), (int)((int)(Pt.coord[4] + 0.5))).DisplayOffset[this.otherCanvas1.DimNr]) - this.otherCanvas1.dadd;
                int yDOff = this.otherCanvas2.PixelFromDataPos(this.my3ddata.ElementAt((int)((int)(Pt.coord[3] + 0.5)), (int)((int)(Pt.coord[4] + 0.5))).DisplayOffset[this.otherCanvas2.DimNr]) - this.otherCanvas2.dadd;
                if (Pt.isDisplayed) {
                    if (Pt.tagged) {
                        g.fillOval(xp - MarkerLists.dx + xDOff, yp - MarkerLists.dy + yDOff, MarkerLists.dx * 2 + 1, MarkerLists.dx * 2 + 1);
                    } else {
                        g.drawRect(xp - MarkerLists.dx + xDOff, yp - MarkerLists.dy + yDOff, MarkerLists.dx * 2 + 1, MarkerLists.dx * 2 + 1);
                    }
                    if (this.myPanel.DraggedMarker == Pt) {
                        if (Pt.tagged) {
                            g.drawOval(xp - MarkerLists.dx - 1 + xDOff, yp - MarkerLists.dy - 1 + yDOff, MarkerLists.dx * 2 + 3, MarkerLists.dx * 2 + 3);
                        } else {
                            g.fillRect(xp - MarkerLists.dx + xDOff, yp - MarkerLists.dy + yDOff, MarkerLists.dx * 2 + 1, MarkerLists.dx * 2 + 1);
                        }
                    }
                    if (!foundactive && this.my3ddata.CheckActiveMarker(l, p, px, py, pz, element, time)) {
                        g.setColor(Color.white);
                        if (Pt.tagged) {
                            g.fillOval(xp - MarkerLists.dx - 1 + xDOff, yp - MarkerLists.dy - 1 + yDOff, MarkerLists.dx * 2 + 3, MarkerLists.dx * 2 + 3);
                        } else {
                            g.drawRect(xp - MarkerLists.dx - 1 + xDOff, yp - MarkerLists.dy - 1 + yDOff, MarkerLists.dx * 2 + 3, MarkerLists.dx * 2 + 3);
                        }
                        foundactive = true;
                    }
                    if (!didannotate && this.my3ddata.Annotate) {
                        didannotate = true;
                        String ListName = this.my3ddata.GetMarkerListName(l);
                        if (ListName != null && !ListName.equals("")) {
                            g.drawString(ListName, xp + this.my3ddata.FontSize + xDOff, yp + this.my3ddata.FontSize + yDOff);
                        }
                    }
                }
                boolean shouldDraw = true;
                if (p == 0) {
                    int ypOff;
                    int xpOff;
                    APoint oPt;
                    if (this.my3ddata.HasParent1(l)) {
                        oPt = this.my3ddata.GetParent1EndOfTrack(l);
                        xpOff = this.otherCanvas1.PixelFromDataPos(this.my3ddata.ElementAt((int)((int)(oPt.coord[3] + 0.5)), (int)((int)(oPt.coord[4] + 0.5))).DisplayOffset[this.otherCanvas1.DimNr]) - this.otherCanvas1.dadd;
                        ypOff = this.otherCanvas2.PixelFromDataPos(this.my3ddata.ElementAt((int)((int)(oPt.coord[3] + 0.5)), (int)((int)(oPt.coord[4] + 0.5))).DisplayOffset[this.otherCanvas2.DimNr]) - this.otherCanvas2.dadd;
                        coords = oPt.coord;
                        if (this.DimNr == 0) {
                            xprev = this.DMouseFromX(coords[2]) + xpOff;
                            yprev = this.DMouseFromY(coords[1]) + ypOff;
                        } else if (this.DimNr == 1) {
                            xprev = this.DMouseFromX(coords[0]) + xpOff;
                            yprev = this.DMouseFromY(coords[2]) + ypOff;
                        } else {
                            xprev = this.DMouseFromX(coords[0]) + xpOff;
                            yprev = this.DMouseFromY(coords[1]) + ypOff;
                        }
                        g.setColor(Color.gray);
                    } else {
                        shouldDraw = false;
                    }
                    if (shouldDraw && this.my3ddata.ConnectionShown && (this.my3ddata.ActiveMarkerPos() == p && l == actlistpos || this.my3ddata.ShowFullTrace && (this.my3ddata.ShowAllTrees || this.my3ddata.CommonRoot(l, actlistpos)))) {
                        g.drawLine(xprev, yprev, xp + xDOff, yp + yDOff);
                    }
                    shouldDraw = true;
                    if (this.my3ddata.HasParent2(l)) {
                        oPt = this.my3ddata.GetParent2EndOfTrack(l);
                        xpOff = this.otherCanvas1.PixelFromDataPos(this.my3ddata.ElementAt((int)((int)(oPt.coord[3] + 0.5)), (int)((int)(oPt.coord[4] + 0.5))).DisplayOffset[this.otherCanvas1.DimNr]) - this.otherCanvas1.dadd;
                        ypOff = this.otherCanvas2.PixelFromDataPos(this.my3ddata.ElementAt((int)((int)(oPt.coord[3] + 0.5)), (int)((int)(oPt.coord[4] + 0.5))).DisplayOffset[this.otherCanvas2.DimNr]) - this.otherCanvas2.dadd;
                        coords = oPt.coord;
                        if (this.DimNr == 0) {
                            xprev = this.DMouseFromX(coords[2]) + xpOff;
                            yprev = this.DMouseFromY(coords[1]) + ypOff;
                        } else if (this.DimNr == 1) {
                            xprev = this.DMouseFromX(coords[0]) + xpOff;
                            yprev = this.DMouseFromY(coords[2]) + ypOff;
                        } else {
                            xprev = this.DMouseFromX(coords[0]) + xpOff;
                            yprev = this.DMouseFromY(coords[1]) + ypOff;
                        }
                        g.setColor(Color.gray);
                    } else {
                        shouldDraw = false;
                    }
                }
                if (shouldDraw && this.my3ddata.ConnectionShown && (this.my3ddata.ActiveMarkerPos() == p && l == actlistpos || this.my3ddata.ShowFullTrace && (this.my3ddata.ShowAllTrees || this.my3ddata.CommonRoot(l, actlistpos)))) {
                    g.drawLine(xprev, yprev, xp + xDOff, yp + yDOff);
                }
                xprev = xp + xDOff;
                yprev = yp + yDOff;
            }
        }
        int xp = this.getCrossHairX();
        yp = this.getCrossHairY();
        g.setColor(Color.green);
        if (this.otherCanvas1 != null) {
            g.drawLine(xp, 0, xp, yp - 10);
            g.drawLine(xp, yp + 10, xp, r.height - 1);
        }
        if (this.otherCanvas2 != null) {
            g.drawLine(0, yp, xp - 10, yp);
            g.drawLine(xp + 10, yp, r.width - 1, yp);
        }
        g.setColor(Color.white);
        if (this.my3ddata.GetProjectionMode(this.DimNr)) {
            String test = !this.my3ddata.GetMIPMode(this.DimNr) ? "Avg. Proj." : "Max. Proj.";
            g.drawString(test, r.width - test.length() * this.my3ddata.FontSize, 12);
        }
        g.drawString(this.mytitle, 10, this.my3ddata.FontSize + 8);
    }

    public int getCrossHairX() {
        double xDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas1.DimNr];
        return this.MouseFromX(this.otherCanvas1.PositionValue + xDOff) + (int)(0.5 * this.otherCanvas1.scale);
    }

    public int getCrossHairY() {
        double yDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.otherCanvas2.DimNr];
        return this.MouseFromY(this.otherCanvas2.PositionValue + yDOff) + (int)(0.5 * this.otherCanvas2.scale);
    }

    public int getCrossHairZ() {
        double zDOff = this.my3ddata.ElementAt((int)this.my3ddata.GetActiveElement()).DisplayOffset[this.DimNr];
        return this.PixelFromDataPos(this.PositionValue + zDOff) + (int)(0.5 * this.scale);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if (img != this.curimage) {
            return false;
        }
        boolean ret = true;
        boolean dopaint = false;
        long updatetime = 0L;
        if ((infoflags & 1) != 0) {
            this.imgw = w;
            dopaint = true;
        }
        if ((infoflags & 2) != 0) {
            this.imgh = h;
            dopaint = true;
        }
        if ((infoflags & 0x30) != 0) {
            dopaint = true;
            ret = false;
        } else if ((infoflags & 8) != 0) {
            dopaint = true;
            updatetime = 100L;
        }
        if ((infoflags & 0x40) != 0) {
            ret = false;
        }
        if (dopaint) {
            this.repaint(updatetime);
        }
        return ret;
    }

    public synchronized Image pickImage() {
        if (!this.DispPlot) {
            this.curimage = this.my3ddata.GiveSection(this.DimNr, (int)this.PositionValue);
        }
        return this.curimage;
    }

    public int PixelFromDataPos(double pos) {
        return this.dadd + (int)((double)((int)pos) * this.scale + 0.5);
    }

    public int MouseFromX(double pos) {
        return this.otherCanvas1.PixelFromDataPos(pos);
    }

    public int MouseFromY(double pos) {
        return this.otherCanvas2.PixelFromDataPos(pos);
    }

    public int DPixelFromDataPos(double pos) {
        return this.dadd + (int)((pos + 0.5) * this.scale);
    }

    public int DMouseFromX(double pos) {
        return this.otherCanvas1.DPixelFromDataPos(pos);
    }

    public int DMouseFromY(double pos) {
        return this.otherCanvas2.DPixelFromDataPos(pos);
    }

    public double DataPosFromPixel(int pixelpos) {
        double result = (double)(pixelpos - this.dadd) / this.scale;
        if (result < 0.0) {
            result = 0.0;
        }
        if (result > (double)(this.MaxPos - 1)) {
            result = this.MaxPos - 1;
        }
        return result;
    }

    public double DataPosFromPixelNoLimit(int pixelpos) {
        return (double)(pixelpos - this.dadd) / this.scale;
    }

    public double XFromMouse(int xnew) {
        return this.otherCanvas1.DataPosFromPixel(xnew);
    }

    public double YFromMouse(int ynew) {
        return this.otherCanvas2.DataPosFromPixel(ynew);
    }

    public double XFromMouseNoLimit(int xnew) {
        return this.otherCanvas1.DataPosFromPixelNoLimit(xnew);
    }

    public double YFromMouseNoLimit(int ynew) {
        return this.otherCanvas2.DataPosFromPixelNoLimit(ynew);
    }

    void updateothers(int xnew, int ynew) {
        double xOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas1.DimNr];
        double yOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas2.DimNr];
        double newPos1 = this.XFromMouse((int)((double)xnew - this.otherCanvas1.scale * xOff));
        if (this.otherCanvas1 != null) {
            if (this.otherCanvas1.PositionValue != newPos1) {
                this.otherCanvas1.PositionValue = newPos1;
                this.otherCanvas1.pickImage();
            }
            this.otherCanvas1.repaint();
        }
        double newPos2 = this.YFromMouse((int)((double)ynew - this.otherCanvas2.scale * yOff));
        if (this.otherCanvas2 != null) {
            if (this.otherCanvas2.PositionValue != newPos2) {
                this.otherCanvas2.PositionValue = newPos2;
                this.otherCanvas2.pickImage();
            }
            this.otherCanvas2.repaint();
        }
    }

    public void CalcPrev() {
        this.xprev = this.otherCanvas1.DPixelFromDataPos(this.otherCanvas1.PositionValue);
        this.yprev = this.otherCanvas2.DPixelFromDataPos(this.otherCanvas2.PositionValue);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int newtime = e.getValue();
        this.my3ddata.setTime(newtime);
        this.UpdateAll();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focus = true;
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focus = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.CalcPrev();
        this.requestFocus();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isAltDown()) {
            if (e.getWheelRotation() < 0) {
                this.my3ddata.nextTime(1);
            } else {
                this.my3ddata.nextTime(-1);
            }
            this.myPanel.AdjustOffset();
            this.UpdateAll();
        } else if (e.isShiftDown() && e.isControlDown()) {
            if (e.getWheelRotation() < 0) {
                this.ChangeOrthoZoom(1.0625);
            } else {
                this.ChangeOrthoZoom(0.9411764705882353);
            }
        } else if (e.isShiftDown()) {
            int ae = this.my3ddata.GetActiveElement();
            double gamma = this.my3ddata.GetGamma(ae);
            gamma = e.getWheelRotation() < 0 ? (gamma *= 1.125) : (gamma /= 1.125);
            this.my3ddata.SetGamma(ae, gamma);
            this.UpdateAll();
        } else {
            boolean lock_aspect = e.isControlDown();
            boolean was_locked = this.otherCanvas2.AspectLocked.getState();
            if (lock_aspect) {
                this.otherCanvas2.AspectLocked.setState(true);
            }
            if (e.getWheelRotation() < 0) {
                this.ChangeZoom(1.125);
            } else {
                this.ChangeZoom(0.8888888888888888);
            }
            this.otherCanvas2.AspectLocked.setState(was_locked);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        double xOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas1.DimNr];
        double yOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas2.DimNr];
        APoint Pt = this.my3ddata.MarkerFromPosition(this.XFromMouseNoLimit(e.getX()) - 0.5 - xOff, this.YFromMouseNoLimit(e.getY()) - 0.5 - yOff, this.DimNr, (double)(2 * MarkerLists.dx + 1) / this.otherCanvas1.scale, (double)(2 * MarkerLists.dy + 1) / this.otherCanvas2.scale);
        if (Pt != null) {
            if (Pt == this.my3ddata.GetActiveMarker()) {
                Pt.Tag(-1);
                this.repaint();
                this.updateothers(this.xprev, this.yprev);
                this.label.CoordsChanged();
            } else {
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.RememberOffset();
                }
                this.my3ddata.SetActiveMarker(Pt);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.myPanel.AdjustOffset();
                    this.CalcPrev();
                    this.UpdateAll();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.MyPopupMenu.show(this, e.getX(), e.getY());
            return;
        }
        if (e.getButton() == 2 && e.isShiftDown()) {
            this.my3ddata.SetGamma(this.my3ddata.GetActiveElement(), 1.0);
            return;
        }
        double xOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas1.DimNr];
        double yOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas2.DimNr];
        if (this.myPanel.DraggedMarker != null) {
            this.myPanel.DraggedMarker.coord[0] = this.myPanel.SavedMarker.coord[0];
            this.myPanel.DraggedMarker.coord[1] = this.myPanel.SavedMarker.coord[1];
            this.myPanel.DraggedMarker.coord[2] = this.myPanel.SavedMarker.coord[2];
            this.myPanel.DraggedMarker = null;
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
            return;
        }
        if (this.LineROIStarted) {
            if (this.otherCanvas1.LROIs == (int)this.XFromMouse(e.getX()) && this.otherCanvas2.LROIs == (int)this.YFromMouse(e.getY()) && this.tmpROIPolygons != null) {
                int Rsize = this.tmpROIPolygons.npoints;
                if (Rsize <= 2) {
                    this.my3ddata.ClearPolyROIs(this.DimNr);
                } else {
                    this.tmpROIPolygons.addPoint((int)this.XFromMouse(e.getX()), (int)this.YFromMouse(e.getY()));
                    this.my3ddata.TakePolyROI(this.tmpROIPolygons, this.DimNr);
                }
                this.tmpROIPolygons = null;
                this.LineROIStarted = false;
                this.UpdateAll();
                return;
            }
            if (this.tmpROIPolygons != null) {
                this.tmpROIPolygons.addPoint((int)this.XFromMouse(e.getX()), (int)this.YFromMouse(e.getY()));
            }
            this.otherCanvas1.LROIs = (int)this.XFromMouse(e.getX());
            this.otherCanvas2.LROIs = (int)this.YFromMouse(e.getY());
            return;
        }
        if (e.isControlDown()) {
            this.ROIMoveStarted = true;
            this.ROIMoveStartX = (int)(this.XFromMouse(e.getX()) - 0.5);
            this.ROIMoveStartY = (int)(this.YFromMouse(e.getY()) - 0.5);
            return;
        }
        if (e.isShiftDown()) {
            if (this.my3ddata.SquareROIs()) {
                this.myPanel.ROIstarted = true;
                this.otherCanvas1.ROIs = (int)this.XFromMouse(e.getX());
                this.otherCanvas2.ROIs = (int)this.YFromMouse(e.getY());
                return;
            }
            if (!this.LineROIStarted) {
                this.LineROIStarted = true;
                if (this.tmpROIPolygons == null) {
                    this.tmpROIPolygons = new Polygon();
                }
                this.LROIs = -1;
                this.otherCanvas1.LROIs = (int)this.XFromMouse(e.getX());
                this.otherCanvas2.LROIs = (int)this.YFromMouse(e.getY());
                this.tmpROIPolygons.addPoint((int)this.XFromMouse(e.getX()), (int)this.YFromMouse(e.getY()));
                return;
            }
        } else {
            if (!this.DispPlot) {
                APoint Pt = this.my3ddata.MarkerFromPosition(this.XFromMouseNoLimit(e.getX()) - 0.5 - xOff, this.YFromMouseNoLimit(e.getY()) - 0.5 - yOff, this.DimNr, (double)(2 * MarkerLists.dx + 1) / this.otherCanvas1.scale, (double)(2 * MarkerLists.dy + 1) / this.otherCanvas2.scale);
                if (Pt != null) {
                    if (Pt == this.my3ddata.GetActiveMarker()) {
                        this.myPanel.DraggedMarker = Pt;
                        this.myPanel.SavedMarker = (APoint)Pt.clone();
                    }
                } else {
                    if (e.isMetaDown() || e.getClickCount() > 1 || (e.getModifiersEx() & 0x200) != 0) {
                        this.ImgDragStarted = true;
                    }
                    if (this.ImgDragStarted) {
                        this.ximgdrag = e.getX();
                        this.yimgdrag = e.getY();
                        this.ImgDragStarted = true;
                        return;
                    }
                    this.xprev = e.getX();
                    this.yprev = e.getY();
                }
            } else if (this.DimNr == 0) {
                this.yprev = e.getY();
            } else if (this.DimNr == 1) {
                this.xprev = e.getX();
            } else if (this.DimNr == 2) {
                this.PositionValue = this.MaxPos * e.getX() / this.getBounds().width;
            }
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.MyPopupMenu.show(this, e.getX(), e.getY());
            return;
        }
        if (this.ImgDragStarted) {
            this.ImgDragStarted = false;
        }
        if (this.myPanel.DraggedMarker != null) {
            this.my3ddata.UpdateMarker(this.myPanel.DraggedMarker);
            this.myPanel.DraggedMarker = null;
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
            return;
        }
        if (!e.isControlDown()) {
            this.ROIMoveStarted = false;
            this.ROIMoveDX = 0;
            this.ROIMoveDY = 0;
            this.repaint();
        }
        if (this.ROIMoveStarted & e.isControlDown()) {
            this.my3ddata.MoveROI(this.ROIMoveDX, this.ROIMoveDY, this.DimNr);
            this.ROIMoveStarted = false;
            this.ROIMoveDX = 0;
            this.ROIMoveDY = 0;
            this.LROIs = -1;
            this.UpdateAll();
            return;
        }
        int SizeX = this.otherCanvas1.MaxPos - 1;
        int SizeY = this.otherCanvas2.MaxPos - 1;
        if (this.myPanel.ROIstarted) {
            this.otherCanvas1.ROIe = (int)this.XFromMouse(e.getX());
            this.otherCanvas2.ROIe = (int)this.YFromMouse(e.getY());
            if (this.otherCanvas1.ROIe == this.otherCanvas1.ROIs && this.otherCanvas2.ROIe == this.otherCanvas2.ROIs) {
                this.my3ddata.TakeROI(0, 0, SizeX, SizeY, this.DimNr);
                this.otherCanvas1.ROIs = 0;
                this.otherCanvas1.ROIe = this.otherCanvas1.MaxPos - 1;
                this.otherCanvas2.ROIs = 0;
                this.otherCanvas2.ROIe = this.otherCanvas2.MaxPos - 1;
                this.ROIs = 0;
                this.ROIe = SizeX;
                this.UpdateAll();
            } else {
                this.my3ddata.TakeROI(this.otherCanvas1.ROIs, this.otherCanvas2.ROIs, this.otherCanvas1.ROIe, this.otherCanvas2.ROIe, this.DimNr);
                this.UpdateAll();
            }
        }
        this.myPanel.ROIstarted = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double xOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas1.DimNr];
        double yOff = this.my3ddata.ElementAt((int)this.my3ddata.ActiveElement).DisplayOffset[this.otherCanvas2.DimNr];
        if (this.ROIMoveStarted) {
            if (!e.isControlDown()) {
                this.ROIMoveStarted = false;
                this.ROIMoveDX = 0;
                this.ROIMoveDY = 0;
                this.repaint();
                return;
            }
            this.ROIMoveDX = (int)(this.XFromMouse(e.getX()) - 0.5) - this.ROIMoveStartX;
            this.ROIMoveDY = (int)(this.YFromMouse(e.getY()) - 0.5) - this.ROIMoveStartY;
            this.repaint();
            return;
        }
        if (this.myPanel.DraggedMarker != null) {
            this.myPanel.DraggedMarker.UpdatePosition(this.XFromMouse(e.getX()) - 0.5 - xOff, this.YFromMouse(e.getY()) - 0.5 - yOff, this.DimNr);
        } else if (!this.myPanel.ROIstarted && !this.LineROIStarted) {
            if (this.ImgDragStarted) {
                boolean wasmoved = false;
                this.otherCanvas1.dadd += e.getX() - this.ximgdrag;
                wasmoved |= this.otherCanvas1.LimitPosition(this.getBounds().width);
                this.otherCanvas2.dadd += e.getY() - this.yimgdrag;
                wasmoved |= this.otherCanvas2.LimitPosition(this.getBounds().height);
                this.ximgdrag = e.getX();
                this.yimgdrag = e.getY();
                this.repaint();
                return;
            }
            this.xprev = e.getX();
            this.yprev = e.getY();
        } else {
            if (this.myPanel.ROIstarted) {
                this.otherCanvas1.ROIe = (int)this.XFromMouse(e.getX());
                this.otherCanvas2.ROIe = (int)this.YFromMouse(e.getY());
            }
            if (this.LineROIStarted) {
                this.otherCanvas1.LROIe = (int)this.XFromMouse(e.getX());
                this.otherCanvas2.LROIe = (int)this.YFromMouse(e.getY());
            }
        }
        this.repaint();
        this.updateothers(this.xprev, this.yprev);
        this.label.CoordsChanged();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.LineROIStarted) {
            this.otherCanvas1.LROIe = (int)this.XFromMouse(e.getX());
            this.otherCanvas2.LROIe = (int)this.YFromMouse(e.getY());
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void RedrawAll() {
        this.repaint();
        this.otherCanvas1.repaint();
        this.otherCanvas2.repaint();
    }

    public void UpdateAllNoCoord() {
        this.pickImage();
        this.repaint();
        this.otherCanvas1.pickImage();
        this.otherCanvas1.repaint();
        this.otherCanvas2.pickImage();
        this.otherCanvas2.repaint();
    }

    public void UpdateAll() {
        if (this.my3ddata.elementsLinked) {
            this.my3ddata.copyLinkedProperties(this.my3ddata.ActiveElement);
        }
        this.UpdateAllNoCoord();
        this.label.CoordsChanged();
    }

    public void UpdateAllPanels() {
        if (!(this.applet instanceof View5D)) {
            ((View5D_)((Object)this.applet)).UpdatePanels();
        } else {
            ((View5D)this.applet).UpdatePanels();
        }
        this.label.CoordsChanged();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char myChar = e.getKeyChar();
        if (33 == e.getKeyCode()) {
            myChar = e.isShiftDown() ? (char)',' : '(';
        }
        if (34 == e.getKeyCode()) {
            myChar = e.isShiftDown() ? (char)'.' : ')';
        }
        if (36 == e.getKeyCode()) {
            myChar = '\u00b0';
        }
        if (113 == e.getKeyCode()) {
            myChar = '^';
        }
        if (112 == e.getKeyCode()) {
            myChar = '?';
        }
        int elem = this.my3ddata.ActiveElement;
        int t = this.my3ddata.ActiveTime;
        ImageCanvas PreferredCanvas = null;
        int advance = 1;
        if (40 == e.getKeyCode()) {
            advance = 1;
            PreferredCanvas = this.otherCanvas2;
        }
        if (38 == e.getKeyCode()) {
            advance = -1;
            PreferredCanvas = this.otherCanvas2;
        }
        if (39 == e.getKeyCode()) {
            advance = 1;
            PreferredCanvas = this.otherCanvas1;
        }
        if (37 == e.getKeyCode()) {
            advance = -1;
            PreferredCanvas = this.otherCanvas1;
        }
        if (PreferredCanvas != null) {
            if (e.isShiftDown()) {
                int emin = 0;
                int emax = this.my3ddata.Elements - 1;
                int pe = this.my3ddata.ActiveElement;
                if (this.my3ddata.TrackDirection != 4) {
                    emin = pe;
                    emax = pe;
                } else {
                    emin = 0;
                    emax = this.my3ddata.Elements - 1;
                }
                for (pe = emin; pe <= emax; ++pe) {
                    int n = PreferredCanvas.DimNr;
                    this.my3ddata.ElementAt((int)pe).DisplayOffset[n] = this.my3ddata.ElementAt((int)pe).DisplayOffset[n] + (double)advance;
                    this.my3ddata.InvalidateProjs(pe, t);
                }
            } else if (e.isControlDown()) {
                if (this.my3ddata.TrackDirection == 4) {
                    while (t < this.my3ddata.Times) {
                        int n = PreferredCanvas.DimNr;
                        this.my3ddata.ElementAt((int)elem, (int)t).DisplayOffset[n] = this.my3ddata.ElementAt((int)elem, (int)t).DisplayOffset[n] + (double)advance;
                        this.my3ddata.InvalidateProjs(elem, t);
                        ++t;
                    }
                } else {
                    while (elem < this.my3ddata.Elements) {
                        int n = PreferredCanvas.DimNr;
                        this.my3ddata.ElementAt((int)elem, (int)t).DisplayOffset[n] = this.my3ddata.ElementAt((int)elem, (int)t).DisplayOffset[n] + (double)advance;
                        this.my3ddata.InvalidateProjs(elem, t);
                        ++elem;
                    }
                }
            } else {
                PreferredCanvas.PositionValue += (double)advance;
                if (PreferredCanvas.PositionValue >= (double)(PreferredCanvas.MaxPos - 1)) {
                    PreferredCanvas.PositionValue = PreferredCanvas.MaxPos - 1;
                }
                if (PreferredCanvas.PositionValue <= 0.0) {
                    PreferredCanvas.PositionValue = 0.0;
                }
            }
        } else {
            this.ProcessKey(myChar);
        }
        if (myChar != '?' && myChar != '$') {
            this.UpdateAll();
        }
    }

    void centerCursor() {
        this.otherCanvas1.PositionValue = Math.floor(this.otherCanvas1.MaxPos / 2);
        this.otherCanvas2.PositionValue = Math.floor(this.otherCanvas2.MaxPos / 2);
    }

    void SpawnHistogram(boolean forceHistogram) {
        if (this.my3ddata.DataToHistogram != null) {
            this.my3ddata.ApplyHistSelection();
            if (this.myPanel.DataPanel != null) {
                this.myPanel.DataPanel.c1.UpdateAll();
            }
        } else if (this.my3ddata.MyHistogram == null || forceHistogram) {
            int MaxSize = 128;
            double HRangeX = this.my3ddata.GetScaledRange(this.my3ddata.HistoX);
            if (HRangeX <= 0.0) {
                System.out.println("No coordinate selected as X histogram coordinate");
                return;
            }
            int HBinsX = MaxSize;
            double[] Scales = new double[5];
            for (int j = 0; j < 5; ++j) {
                Scales[j] = 1.0;
            }
            double[] Offsets = new double[5];
            for (int j = 0; j < 5; ++j) {
                Offsets[j] = 0.0;
            }
            Scales[0] = HRangeX / ((double)HBinsX - 1.0);
            if (HRangeX > 50.0) {
                Scales[0] = (int)((HRangeX - 1.0) / (double)MaxSize) + 1;
                HBinsX = (int)(HRangeX / Scales[0]);
                System.out.println("X Histscale : " + HBinsX + ", " + Scales[0] + "\n");
            }
            double HRangeY = 1.0;
            double HRangeZ = 1.0;
            int HBinsY = 1;
            int HBinsZ = 1;
            Offsets[0] = this.my3ddata.GetScaledMincs(this.my3ddata.HistoX);
            if (this.my3ddata.HistoY >= 0) {
                HRangeY = this.my3ddata.GetScaledRange(this.my3ddata.HistoY);
                if (HRangeY <= 0.0) {
                    System.out.println("No coordinate selected as Y histogram coordinate");
                    return;
                }
                if (HRangeY > 50.0) {
                    Scales[1] = (int)((HRangeY - 1.0) / (double)MaxSize) + 1;
                    HBinsY = (int)(HRangeY / Scales[1]);
                    System.out.println("Y Histscale : " + HBinsY + ", " + Scales[1]);
                } else {
                    HBinsY = MaxSize;
                    Scales[1] = HRangeY / ((double)HBinsY - 1.0);
                    System.out.println("::: Y Histscale : " + HBinsY + ", " + HRangeY + ", " + Scales[1]);
                }
                Offsets[1] = this.my3ddata.GetScaledMincs(this.my3ddata.HistoY);
            }
            if (this.my3ddata.HistoZ >= 0) {
                HRangeZ = this.my3ddata.GetScaledRange(this.my3ddata.HistoZ);
                if (HRangeZ <= 0.0) {
                    System.out.println("No coordinate selected as Z histogram coordinate");
                    return;
                }
                if (HRangeZ > 50.0) {
                    Scales[2] = (int)((HRangeZ - 1.0) / (double)MaxSize) + 1;
                    HBinsZ = (int)(HRangeZ / Scales[2]);
                } else {
                    HBinsZ = MaxSize;
                    Scales[2] = HRangeZ / ((double)HBinsZ - 1.0);
                }
                Offsets[2] = this.my3ddata.GetScaledMincs(this.my3ddata.HistoZ);
            }
            My3DData Histogram = new My3DData(this.applet, HBinsX, HBinsY, HBinsZ, 1, 1, -1, -1, -1, 0, -1, -1, AnElement.IntegerType, 4, 31, Scales, Offsets, 1.0, 0.0, this.my3ddata.GetAxisNames(), this.my3ddata.GetAxisUnits());
            Histogram.TakeDataToHistogram(this.my3ddata);
            Histogram.ComputeHistogram();
            Histogram.ToggleModel(5);
            Histogram.ToggleOverlayDispl(1);
            AlternateViewer xx2 = new AlternateViewer(this.applet);
            xx2.Assign3DData(this.applet, this.myPanel, Histogram);
            if (this.my3ddata.MyHistogram == null) {
                this.my3ddata.MyHistogram = Histogram;
            }
            this.my3ddata.DataToHistogram = null;
        } else {
            if (this.my3ddata.MyHistogram.Elements == 1) {
                this.my3ddata.MyHistogram.colormode = true;
            }
            this.my3ddata.MyHistogram.CloneLastElements();
            this.my3ddata.MyHistogram.TakeDataToHistogram(this.my3ddata);
            this.my3ddata.MyHistogram.ComputeHistogram();
        }
    }

    public void ChangeZoom(double RelZoom) {
        int xp = this.getCrossHairX();
        int yp = this.getCrossHairY();
        this.otherCanvas1.scale *= RelZoom;
        this.otherCanvas2.scale *= RelZoom;
        this.otherCanvas1.dadd += xp - this.getCrossHairX();
        this.otherCanvas2.dadd += yp - this.getCrossHairY();
        this.otherCanvas1.LimitPosition(this.getBounds().width);
        this.otherCanvas2.LimitPosition(this.getBounds().height);
        if (this.otherCanvas2.AspectLocked.getState() || this.otherCanvas1.AspectLocked.getState()) {
            double zp = this.getCrossHairZ();
            this.scale *= RelZoom;
            this.dadd = (int)((double)this.dadd + (zp - (double)this.getCrossHairZ()));
            this.LimitPosition(this.getBounds().height);
        }
        this.RedrawAll();
        this.label.CoordsChanged();
    }

    public void ChangeOrthoZoom(double RelZoom) {
        if (!this.otherCanvas1.AspectLocked.getState() && !this.otherCanvas2.AspectLocked.getState() && this.scale > 1.0) {
            this.scale *= RelZoom;
            this.dadd = (int)((double)this.dadd + (1.0 - RelZoom) * this.scale * this.PositionValue);
            this.RedrawAll();
        }
    }

    public void ExportValues() {
        Plot myplot = new Plot("View5D Plot", this.XAxisTitle, this.YAxisTitle);
        myplot.add("line", this.AxisData, this.LineData);
        myplot.draw();
    }

    public boolean checkProceed(String txt) {
        AGenericDialog question = new AGenericDialog("Warning!");
        question.addMessage(txt + " modifies the data.\nDo you really want to proceed?");
        question.showDialog();
        return !question.wasCanceled();
    }

    public int checkChoice(String txt, String[] choices, String default_choice) {
        int choice = 0;
        AGenericDialog question = new AGenericDialog("Delete Element or Timepoint");
        question.addMessage(txt);
        question.addChoice("Delete", choices, default_choice);
        question.showDialog();
        choice = question.getNextChoiceIndex();
        if (question.wasCanceled()) {
            choice = -1;
        }
        return choice;
    }

    public void ProcessKey(char myChar) {
        switch (myChar) {
            case ' ': {
                this.ImgDragStarted = true;
                return;
            }
            case '\u00b0': {
                this.centerCursor();
                return;
            }
            case 'D': {
                if (this.my3ddata.Elements > 1) {
                    if (this.my3ddata.Times <= 1) {
                        if (this.checkProceed("Delete Element")) {
                            this.my3ddata.DeleteActElement();
                        }
                    } else {
                        String[] choices = new String[]{"Element", "Time"};
                        int choice = this.checkChoice("Deleting Element/Timepoint modifies the data. Do you really want to proceed?", choices, choices[this.defaultTimeElementChoice]);
                        if (choice == 0) {
                            this.my3ddata.DeleteActElement();
                        }
                        if (choice == 1) {
                            this.my3ddata.DeleteActTime();
                        }
                        this.defaultTimeElementChoice = choice;
                        this.myPanel.CheckScrollBar();
                    }
                } else if (this.my3ddata.Times > 1) {
                    if (this.checkProceed("Delete Timepoint")) {
                        this.my3ddata.DeleteActTime();
                    }
                    this.myPanel.CheckScrollBar();
                }
                this.UpdateAllPanels();
                return;
            }
            case 'f': {
                this.my3ddata.CloneFloat();
                this.UpdateAllPanels();
                return;
            }
            case 'F': {
                this.my3ddata.CloneShort();
                this.UpdateAllPanels();
                return;
            }
            case '+': {
                if (this.checkProceed("AddMarkedElement")) {
                    this.my3ddata.AddMarkedElement();
                }
                this.UpdateAllPanels();
                return;
            }
            case '_': {
                this.my3ddata.AdjustOffsetToROIMean();
                this.UpdateAllPanels();
                return;
            }
            case '-': {
                if (this.checkProceed("SubtractMarkedElement")) {
                    this.my3ddata.SubMarkedElement();
                }
                this.UpdateAllPanels();
                return;
            }
            case '*': {
                if (this.checkProceed("MultiplyMarkedElement")) {
                    this.my3ddata.MulMarkedElement();
                }
                this.UpdateAllPanels();
                return;
            }
            case '/': {
                if (this.checkProceed("DivideMarkedElement")) {
                    this.my3ddata.DivMarkedElement();
                }
                this.UpdateAllPanels();
                return;
            }
            case 'e': {
                this.myPanel.RememberOffset();
                this.my3ddata.advanceElement(1);
                this.myPanel.AdjustOffset();
                this.UpdateAll();
                return;
            }
            case 'E': {
                this.myPanel.RememberOffset();
                this.my3ddata.advanceElement(-1);
                this.myPanel.AdjustOffset();
                this.UpdateAll();
                return;
            }
            case 't': {
                if (this.my3ddata.elementsLinked) {
                    this.my3ddata.AdjustThresh();
                } else {
                    this.my3ddata.AdjustThresh(false);
                }
                this.UpdateAll();
                return;
            }
            case 'T': {
                this.my3ddata.AdjustThresh();
                this.UpdateAll();
                return;
            }
            case 'n': {
                this.my3ddata.MarkerDialog();
                this.UpdateAll();
                return;
            }
            case 'N': {
                this.my3ddata.AxesUnitsDialog();
                this.my3ddata.InvalidateProjs(-1);
                this.label.CoordsChanged();
                break;
            }
            case 'r': {
                this.my3ddata.ToggleModel(1);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'R': {
                this.my3ddata.ToggleModel(5);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'g': {
                this.my3ddata.ToggleModel(2);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'G': {
                this.my3ddata.ToggleModel(0);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'b': {
                this.my3ddata.ToggleModel(3);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'B': {
                this.my3ddata.ToggleModel(10);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'v': {
                this.my3ddata.ToggleOverlayDispl(-1);
                this.UpdateAll();
                return;
            }
            case 'V': {
                this.my3ddata.ToggleMulDispl(-1);
                this.UpdateAll();
                return;
            }
            case 'k': {
                if (this.my3ddata.NumMarkerLists() > 0 && this.my3ddata.GetActiveMarker() != null) {
                    this.my3ddata.NewMarkerList();
                }
                this.my3ddata.SetMarker(this.label.px, this.label.py, this.label.pz);
                this.UpdateAll();
                return;
            }
            case '\\': {
                this.my3ddata.DevideMarkerList(this.label.px, this.label.py, this.label.pz);
                this.UpdateAll();
                return;
            }
            case 'K': {
                this.my3ddata.RemoveMarkerList();
                this.UpdateAll();
                return;
            }
            case '&': {
                this.my3ddata.TagMarker();
                System.out.println("Error Tagged Component setValue called\n");
                this.UpdateAll();
                return;
            }
            case 'm': {
                this.my3ddata.SetMarker(this.label.px, this.label.py, this.label.pz);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.CalcPrev();
                }
                if (this.my3ddata.Advance) {
                    this.myPanel.AdvancePos();
                }
                this.UpdateAll();
                return;
            }
            case 'M': {
                this.my3ddata.RemovePoint();
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.CalcPrev();
                }
                this.UpdateAll();
                return;
            }
            case '$': {
                if (!(this.applet instanceof View5D)) {
                    this.my3ddata.cleanup();
                    this.applet.removeAll();
                    this.otherCanvas1.removeNotify();
                    this.otherCanvas2.removeNotify();
                    this.removeNotify();
                    System.gc();
                    ((View5D_)((Object)this.applet)).dispose();
                } else {
                    AlternateViewer viewer = ((View5D)this.applet).aviewer;
                    for (int i = 0; i < ((View5D)this.applet).panels.size(); ++i) {
                        Container otherviewer = ((View5D)this.applet).panels.elementAt(i).getParent();
                        if (!(otherviewer instanceof Frame) || viewer == otherviewer) continue;
                        WindowEvent closingEvent = new WindowEvent((Frame)otherviewer, 201);
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(closingEvent);
                    }
                    WindowEvent closingEvent = new WindowEvent(viewer, 201);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(closingEvent);
                }
                return;
            }
            case 'Q': {
                this.my3ddata.RemoveTrailingPoints();
                this.UpdateAll();
                return;
            }
            case '0': {
                this.myPanel.RememberOffset();
                this.my3ddata.AdvancePoint(1);
                this.myPanel.AdjustOffset();
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.CalcPrev();
                }
                this.UpdateAll();
                return;
            }
            case '9': {
                this.myPanel.RememberOffset();
                this.my3ddata.AdvancePoint(-1);
                this.myPanel.AdjustOffset();
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.CalcPrev();
                }
                this.UpdateAll();
                return;
            }
            case 'j': {
                this.my3ddata.AdvanceMarkerList(1);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.CalcPrev();
                }
                this.UpdateAll();
                return;
            }
            case 'J': {
                this.my3ddata.AdvanceMarkerList(-1);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                    this.CalcPrev();
                }
                this.UpdateAll();
                return;
            }
            case 'w': {
                this.my3ddata.ToggleMarkerListColor(1);
                this.UpdateAll();
                return;
            }
            case 'W': {
                this.my3ddata.AutoTrack();
                this.UpdateAll();
                return;
            }
            case '|': {
                this.my3ddata.AlignOffsetsToTrack();
                this.UpdateAll();
                return;
            }
            case '{': {
                this.my3ddata.ResetOffsets();
                this.UpdateAll();
                return;
            }
            case '}': {
                this.my3ddata.MarkerListDialog();
                this.UpdateAll();
                return;
            }
            case '@': {
                this.AspectLocked.setState(!this.AspectLocked.getState());
                return;
            }
            case '#': {
                this.my3ddata.SubtractTrackedSpot();
                this.my3ddata.InvalidateProjs(-1);
                this.my3ddata.InvalidateSlices();
                this.UpdateAll();
                return;
            }
            case 's': {
                AlternateViewer xx = new AlternateViewer(this.applet);
                My3DData nd = new My3DData(this.my3ddata);
                xx.Assign3DData(this.applet, null, nd);
                this.UpdateAll();
                return;
            }
            case 'P': {
                this.my3ddata.ToggleProj(this.DimNr, false);
                this.label.CoordsChanged();
                this.UpdateAll();
                return;
            }
            case 'p': {
                this.my3ddata.ToggleProj(this.DimNr, true);
                this.UpdateAll();
                return;
            }
            case '^': {
                this.my3ddata.ActElement().AdvanceReadMode();
                this.my3ddata.InvalidateSlices();
                this.my3ddata.InvalidateProjs(-1);
                this.UpdateAll();
                return;
            }
            case 'S': {
                if (!this.myPanel.ROIstarted && !this.LineROIStarted) {
                    this.my3ddata.ToggleSquareROIs();
                    this.my3ddata.InvalidateProjs(-1);
                    this.UpdateAll();
                }
                return;
            }
            case 'x': {
                this.my3ddata.MarkAsHistoDim(0);
                this.label.CoordsChanged();
                return;
            }
            case 'y': {
                this.my3ddata.MarkAsHistoDim(1);
                this.label.CoordsChanged();
                return;
            }
            case 'z': {
                this.my3ddata.MarkAsHistoDim(2);
                this.label.CoordsChanged();
                return;
            }
            case 'Z': {
                double scalex = (double)this.getBounds().width / (1.5 + (double)this.otherCanvas1.ROIe - (double)this.otherCanvas1.ROIs);
                double scaley = (double)this.getBounds().height / (1.5 + (double)this.otherCanvas2.ROIe - (double)this.otherCanvas2.ROIs);
                if (this.AspectLocked.getState()) {
                    if (scalex > scaley) {
                        scalex = scaley;
                    } else {
                        scaley = scalex;
                    }
                }
                this.otherCanvas1.scale = scalex;
                this.otherCanvas2.scale = scaley;
                this.otherCanvas1.dadd -= this.MouseFromX((double)this.otherCanvas1.ROIs - 0.5);
                this.otherCanvas2.dadd -= this.MouseFromY((double)this.otherCanvas2.ROIs - 0.5);
                this.UpdateAll();
                return;
            }
            case 'U': {
                this.my3ddata.toggleGate(-1);
                this.UpdateAll();
                return;
            }
            case 'u': {
                this.my3ddata.setGate();
                this.UpdateAll();
                return;
            }
            case 'H': 
            case 'h': {
                this.SpawnHistogram(myChar == 'H');
                this.UpdateAllPanels();
                return;
            }
            case 'C': {
                this.my3ddata.ToggleColor();
                this.UpdateAll();
                return;
            }
            case 'c': {
                this.my3ddata.ToggleModel(-1);
                this.UpdateAll();
                return;
            }
            case 'd': {
                this.my3ddata.InvertCMap();
                this.my3ddata.ToggleModel(-1);
                this.my3ddata.InvertCMap();
                this.UpdateAll();
                return;
            }
            case 'o': {
                this.my3ddata.ToggleOvUn(-1);
                this.UpdateAll();
                return;
            }
            case 'O': {
                this.my3ddata.ToggleLog(-1);
                this.UpdateAll();
                return;
            }
            case ',': {
                this.myPanel.RememberOffset();
                this.my3ddata.nextTime(1);
                this.myPanel.AdjustOffset();
                this.UpdateAll();
                return;
            }
            case '.': {
                this.myPanel.RememberOffset();
                this.my3ddata.nextTime(-1);
                this.myPanel.AdjustOffset();
                this.UpdateAll();
                return;
            }
            case '(': {
                if (this.PositionValue < (double)(this.MaxPos - 1)) {
                    this.PositionValue += 1.0;
                }
                this.UpdateAll();
                return;
            }
            case ')': {
                if (this.PositionValue > 0.0) {
                    this.PositionValue -= 1.0;
                }
                this.UpdateAll();
                return;
            }
            case 'A': {
                this.ChangeZoom(1.25);
                return;
            }
            case 'a': {
                this.ChangeZoom(0.8);
                return;
            }
            case '>': {
                this.ChangeOrthoZoom(1.215);
                return;
            }
            case '<': {
                this.ChangeOrthoZoom(0.8888888888888888);
                return;
            }
            case 'q': {
                this.DispPlot = !this.DispPlot;
                this.repaint();
                return;
            }
            case '!': {
                this.my3ddata.CThreshToValThresh(-1, 0.0, 1.0);
                this.UpdateAll();
                return;
            }
            case '1': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(0.02);
                } else {
                    this.my3ddata.adjustColorMapLThresh(0.02);
                }
                this.UpdateAll();
                return;
            }
            case '2': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(-0.02);
                } else {
                    this.my3ddata.adjustColorMapLThresh(-0.02);
                }
                this.UpdateAll();
                return;
            }
            case '3': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(0.02);
                } else {
                    this.my3ddata.adjustColorMapUThresh(0.02);
                }
                this.UpdateAll();
                return;
            }
            case '4': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(-0.02);
                } else {
                    this.my3ddata.adjustColorMapUThresh(-0.02);
                }
                this.UpdateAll();
                return;
            }
            case '5': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(0.002);
                } else {
                    this.my3ddata.adjustColorMapLThresh(0.002);
                }
                this.UpdateAll();
                return;
            }
            case '6': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(-0.002);
                } else {
                    this.my3ddata.adjustColorMapLThresh(-0.002);
                }
                this.UpdateAll();
                return;
            }
            case '7': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(0.002);
                } else {
                    this.my3ddata.adjustColorMapUThresh(0.002);
                }
                this.UpdateAll();
                return;
            }
            case '8': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(-0.002);
                } else {
                    this.my3ddata.adjustColorMapUThresh(-0.002);
                }
                this.UpdateAll();
                return;
            }
            case 'i': {
                this.InitScaling();
                this.otherCanvas1.InitScaling();
                this.otherCanvas2.InitScaling();
                this.centerCursor();
                this.CalcPrev();
                this.UpdateAll();
                return;
            }
            case 'I': {
                this.my3ddata.initGlobalThresh();
                this.InitScaling();
                this.centerCursor();
                this.CalcPrev();
                this.UpdateAll();
                return;
            }
            case 'X': {
                if (!(this.applet instanceof View5D)) {
                    if (this.DispPlot) {
                        this.ExportValues();
                    } else {
                        this.my3ddata.Export(this.DimNr, (int)this.PositionValue);
                    }
                }
                return;
            }
            case 'Y': {
                this.my3ddata.GenerateMask(this.DimNr);
                this.UpdateAll();
                return;
            }
            case 'l': {
                if (!(this.applet instanceof View5D)) {
                    ((View5D_)((Object)this.applet)).LoadImg(0);
                } else {
                    this.my3ddata.Load(this.my3ddata.PrevType, this.my3ddata.PrevBytes, this.my3ddata.PrevBits, ((View5D)this.applet).getDocumentBase() + ((View5D)this.applet).filename);
                    this.UpdateAllPanels();
                }
                this.UpdateAll();
                return;
            }
            case 'L': {
                this.my3ddata.LoadMarkers();
                this.UpdateAllPanels();
                return;
            }
            case '?': {
                this.label.Help();
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

