/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ResultsTableMacros
implements Runnable,
DialogListener,
ActionListener,
KeyListener {
    private static String NAME = "TableMacro.ijm";
    private String defaultMacro = "Sin=sin(row*0.1);\nCos=cos(row*0.1);\nSqr=Sin*Sin+Cos*Cos;";
    private GenericDialog gd;
    private ResultsTable rt;
    private ResultsTable rtBackup;
    private Button runButton;
    private Button resetButton;
    private Button openButton;
    private Button saveButton;
    private String title;
    private int runCount;
    private TextArea ta;

    public ResultsTableMacros(ResultsTable rt) {
        this.rt = rt;
        this.title = rt != null ? rt.getTitle() : null;
        Thread thread = new Thread((Runnable)this, "ResultTableMacros");
        thread.start();
    }

    private void showDialog() {
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
        }
        if (this.rt == null || this.rt.size() == 0) {
            IJ.error("Results Table required");
            return;
        }
        String[] temp = this.rt.getHeadingsAsVariableNames();
        String[] variableNames = new String[temp.length + 2];
        variableNames[0] = "Insert...";
        variableNames[1] = "row";
        for (int i = 2; i < variableNames.length; ++i) {
            variableNames[i] = temp[i - 2];
        }
        String dialogTitle = "Apply Macro to " + (this.title != null ? "\"" + this.title + "\"" : "Table");
        Frame parent = this.title != null ? WindowManager.getFrame(this.title) : null;
        this.gd = parent != null ? new GenericDialog(dialogTitle, parent) : new GenericDialog(dialogTitle);
        this.gd.setInsets(5, 5, 0);
        this.gd.addTextAreas(this.getMacro(), null, 12, 48);
        this.ta = this.gd.getTextArea1();
        this.ta.addKeyListener(this);
        Panel panel = new Panel();
        if (IJ.isMacOSX()) {
            panel.setLayout(new FlowLayout(0, 0, 0));
        }
        this.runButton = new Button("Run");
        this.runButton.addActionListener(this);
        panel.add(this.runButton);
        this.resetButton = new Button("Reset");
        this.resetButton.addActionListener(this);
        panel.add(this.resetButton);
        this.openButton = new Button("Open");
        this.openButton.addActionListener(this);
        panel.add(this.openButton);
        this.saveButton = new Button("Save");
        this.saveButton.addActionListener(this);
        panel.add(this.saveButton);
        this.gd.addPanel(panel);
        this.gd.addToSameRow();
        this.gd.addChoice("", variableNames, variableNames[0]);
        this.gd.addHelp("<html><body><h1>Macro Equations for Results Tables</h1><ul><li>The macro, or a selection, is applied to each row of the table.<li>A new variable starting with an Uppercase character creates<br>a new column.<li>A new variable starting with a lowercase character is temporary.<li>The variable <b>row</b> (row index) is pre-defined.\n<li>String operations are supported for the 'Label' column only (if<br>enabledwith Analyze&gt;Set Measurements&gt;Display Label).<li>Click \"<b>Run</b>\", or press " + (IJ.isMacOSX() ? "cmd" : "ctrl") + "-r, to apply the macro code to the table.<li>Select a line and press " + (IJ.isMacOSX() ? "cmd" : "ctrl") + "-r to apply a line of macro code.<li>Click \"<b>Reset</b>\" to revert to the original version of the table.<li>The code is saved at <b>macros/TableMacro.ijm</b>, and the<br>\"Apply Macro\" command is recorded, when you click \"<b>OK</b>\".<li>All <b>Table.</b> macro functions (such as Table.size) refer to the<br>current (frontmost) table unless the table name is given.</ul></body></html>");
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            this.rt = this.rtBackup;
            this.updateDisplay();
            return;
        }
        if (this.runCount == 0) {
            this.applyMacro();
        }
        if (IJ.recording()) {
            String macro = this.getMacroCode();
            macro = macro.replaceAll("\n", " ");
            if (Recorder.scriptMode()) {
                Recorder.recordCall("title = \"" + this.title + "\";");
                Recorder.recordCall("frame = WindowManager.getFrame(title);");
                Recorder.recordCall("rt = frame.getResultsTable();");
                Recorder.recordCall("rt.applyMacro(\"" + macro + "\");");
                Recorder.recordCall("rt.show(title);");
            } else if (this.title.equals("Results")) {
                Recorder.record("Table.applyMacro", macro);
            } else {
                Recorder.record("Table.applyMacro", macro, this.title);
            }
        }
        IJ.saveString(this.ta.getText(), IJ.getDir("macros") + NAME);
    }

    private void applyMacro() {
        String code = this.getMacroCode();
        this.rt.applyMacro(code);
        this.updateDisplay();
        ++this.runCount;
    }

    private String getMacroCode() {
        int end;
        int start = this.ta.getSelectionStart();
        return start == (end = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        final String variableName = gd.getNextChoice();
        if (e != null && e.getSource() instanceof Choice && !variableName.equals("Insert...")) {
            final int pos = this.ta.getCaretPosition();
            ((Choice)e.getSource()).select(0);
            final TextArea textArea = this.ta;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IJ.wait(100);
                    textArea.insert(variableName, pos);
                    textArea.setCaretPosition(pos + variableName.length());
                    textArea.requestFocus();
                }
            }).start();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.runButton) {
            this.applyMacro();
        } else if (source == this.resetButton) {
            this.rt = (ResultsTable)this.rtBackup.clone();
            this.updateDisplay();
        } else if (source == this.openButton) {
            String macro = IJ.openAsString(null);
            if (macro == null) {
                return;
            }
            if (macro.startsWith("Error: ")) {
                IJ.error(macro);
                return;
            }
            this.ta.setText(macro);
        } else if (source == this.saveButton) {
            this.ta.selectAll();
            String macro = this.ta.getText();
            this.ta.select(0, 0);
            IJ.saveString(macro, null);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int flags = e.getModifiers();
        boolean control = (flags & 2) != 0;
        boolean meta = (flags & 4) != 0;
        int keyCode = e.getKeyCode();
        if (keyCode == 82 && (control || meta)) {
            this.applyMacro();
        }
        if (keyCode == 90 && (control || meta)) {
            this.rt = (ResultsTable)this.rtBackup.clone();
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        if (this.title != null) {
            this.rt.show(this.title);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private String getMacro() {
        String macro = IJ.openAsString(IJ.getDir("macros") + NAME);
        if (macro == null || macro.startsWith("Error:")) {
            return this.defaultMacro;
        }
        macro = macro.replaceAll("rowNumber", "row");
        macro = macro.replaceAll("rowIndex", "row");
        return macro;
    }

    @Override
    public void run() {
        this.rtBackup = (ResultsTable)this.rt.clone();
        this.showDialog();
    }
}

