/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.StackStatistics;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class Distribution
implements PlugIn,
TextListener {
    static String parameter = "Area";
    static boolean autoBinning = true;
    static int nBins = 10;
    static String range = "0-0";
    Checkbox checkbox;
    TextField nBinsField;
    TextField rangeField;
    String defaultNBins;
    String defaultRange;

    @Override
    public void run(String arg) {
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt.size() == 0) {
            IJ.error("Distribution", "The \"Results\" table is empty");
            return;
        }
        this.run(rt);
    }

    public void run(ResultsTable rt) {
        float binWidth;
        if (rt == null) {
            return;
        }
        int count = rt.size();
        String head = rt.getColumnHeadings();
        StringTokenizer t = new StringTokenizer(head, "\t");
        int tokens = t.countTokens() - 1;
        String[] strings = new String[tokens];
        strings[0] = t.nextToken();
        for (int i = 0; i < tokens; ++i) {
            strings[i] = t.nextToken();
        }
        this.defaultNBins = "" + nBins;
        this.defaultRange = range;
        GenericDialog gd = new GenericDialog("Distribution");
        gd.addChoice("Parameter: ", strings, strings[this.getIndex(strings)]);
        gd.setInsets(0, 40, 0);
        gd.addMessage(count + " data points", null, Color.darkGray);
        gd.addCheckbox("Automatic binning", autoBinning);
        gd.addNumericField("or specify bins:", nBins, 0);
        gd.addStringField("and range:", range);
        Vector v = gd.getNumericFields();
        if (v != null) {
            this.nBinsField = (TextField)v.elementAt(0);
            this.nBinsField.addTextListener(this);
        }
        if ((v = gd.getStringFields()) != null) {
            this.rangeField = (TextField)v.elementAt(0);
            this.rangeField.addTextListener(this);
        }
        this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        parameter = gd.getNextChoice();
        autoBinning = gd.getNextBoolean();
        double nMin = 0.0;
        double nMax = 0.0;
        if (!autoBinning) {
            nBins = (int)gd.getNextNumber();
            range = gd.getNextString();
            String[] minAndMax = range.replaceAll("([0-9.])[\t ]*-", "$1,").split(",");
            nMin = Tools.parseDouble(minAndMax[0]);
            double d = nMax = minAndMax.length == 2 ? Tools.parseDouble(minAndMax[1]) : Double.NaN;
            if (Double.isNaN(nMin) || Double.isNaN(nMax)) {
                nMin = 0.0;
                nMax = 0.0;
                range = "0-0";
            }
        }
        float[] data = null;
        int index = rt.getColumnIndex(parameter);
        if (index >= 0) {
            data = rt.getColumn(index);
        }
        if (data == null) {
            IJ.error("Distribution", "No available results: \"" + parameter + "\"");
            return;
        }
        float[] pars = new float[11];
        this.stats(count, data, pars);
        if (autoBinning && (nBins = (int)Math.floor((double)((pars[4] - pars[3]) / (binWidth = (float)(3.49 * (double)pars[7] * (double)((float)Math.pow(count, -0.3333333333333333))))) + 0.5)) < 2) {
            nBins = 2;
        }
        FloatProcessor ip = new FloatProcessor(count, 1, data, null);
        ImagePlus imp = new ImagePlus("", ip);
        StackStatistics stats = new StackStatistics(imp, nBins, nMin, nMax);
        int maxCount = 0;
        for (int i = 0; i < stats.histogram.length; ++i) {
            if (stats.histogram[i] <= maxCount) continue;
            maxCount = stats.histogram[i];
        }
        stats.histYMax = maxCount;
        HistogramWindow hw = new HistogramWindow(parameter + " Distribution", imp, stats);
        try {
            ResultsTable rt2 = hw.getResultsTable();
            int col = rt2.getColumnIndex("bin start");
            float[] xvalues = rt2.getColumn(col);
            col = rt2.getColumnIndex("count");
            float[] yvalues = rt2.getColumn(col);
            ImagePlus img = hw.getImagePlus();
            img.setProperty("XValues", xvalues);
            img.setProperty("YValues", yvalues);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int getIndex(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(parameter)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void textValueChanged(TextEvent e) {
        if (!this.defaultNBins.equals(this.nBinsField.getText())) {
            this.checkbox.setState(false);
        }
        if (!this.defaultRange.equals(this.rangeField.getText())) {
            this.checkbox.setState(false);
        }
    }

    void stats(int nc, float[] data, float[] pars) {
        int i;
        float s = 0.0f;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float totl = 0.0f;
        float ave = 0.0f;
        float adev = 0.0f;
        float sdev = 0.0f;
        float var = 0.0f;
        float skew = 0.0f;
        float kurt = 0.0f;
        for (i = 0; i < nc; ++i) {
            totl += data[i];
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        ave = totl / (float)nc;
        for (i = 0; i < nc; ++i) {
            s = data[i] - ave;
            adev += Math.abs(s);
            float p = s * s;
            var += p;
            skew += (p *= s);
            kurt += (p *= s);
        }
        adev /= (float)nc;
        sdev = (float)Math.sqrt(var /= (float)(nc - 1));
        if (var > 0.0f) {
            skew /= (float)nc * (float)Math.pow(sdev, 3.0);
            kurt = kurt / ((float)nc * (float)Math.pow(var, 2.0)) - 3.0f;
        }
        pars[1] = nc;
        pars[2] = totl;
        pars[3] = min;
        pars[4] = max;
        pars[5] = ave;
        pars[6] = adev;
        pars[7] = sdev;
        pars[8] = var;
        pars[9] = skew;
        pars[10] = kurt;
    }
}

