/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.PlotMaker;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugIn,
Measurements,
PlotMaker {
    private static String[] choices = new String[]{"time", "z-axis"};
    private static String choice = choices[0];
    private boolean showingDialog;
    private ImagePlus imp;
    private boolean isPlotMaker;
    private boolean timeProfile;
    private boolean firstTime = true;
    private String options;

    public static Plot getPlot(ImagePlus imp) {
        return ZAxisProfiler.getPlot(imp, "time");
    }

    public static Plot getPlot(ImagePlus imp, String options) {
        ZAxisProfiler zap = new ZAxisProfiler();
        zap.imp = imp;
        zap.options = options;
        zap.isPlotMaker = true;
        Plot plot = zap.getPlot();
        return plot;
    }

    @Override
    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp.getStackSize() < 2) {
            IJ.error("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        this.isPlotMaker = true;
        Plot plot = this.getPlot();
        if (plot != null) {
            if (this.isPlotMaker) {
                plot.setPlotMaker(this);
            }
            plot.show();
        }
    }

    @Override
    public Plot getPlot() {
        double[] a;
        boolean useConnectedCircles;
        String title;
        Roi roi = this.imp.getRoi();
        ImageProcessor ip = this.imp.getProcessor();
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        boolean hyperstack = this.imp.isHyperStack();
        float[] y = hyperstack ? this.getHyperstackProfile(this.imp, minThreshold, maxThreshold) : this.getZAxisProfile(this.imp, minThreshold, maxThreshold);
        if (y == null) {
            return null;
        }
        float[] x = new float[y.length];
        String xAxisLabel = this.showingDialog && choice.equals(choices[0]) ? "Frame" : "Slice";
        Calibration cal = this.imp.getCalibration();
        double calFactor = 1.0;
        double origin = -1.0;
        if (cal.scaled()) {
            if (this.timeProfile) {
                String timeUnit;
                boolean zeroInterval;
                calFactor = (float)cal.frameInterval;
                boolean bl = zeroInterval = calFactor == 0.0;
                if (zeroInterval) {
                    calFactor = 1.0;
                } else {
                    origin = 0.0;
                }
                xAxisLabel = timeUnit = zeroInterval ? "Frame" : "[" + cal.getTimeUnit() + "]";
            } else {
                String depthUnit;
                boolean zeroDepth;
                calFactor = (float)cal.pixelDepth;
                boolean bl = zeroDepth = calFactor == 0.0;
                if (zeroDepth) {
                    calFactor = 1.0;
                } else {
                    origin = cal.zOrigin;
                }
                xAxisLabel = depthUnit = zeroDepth ? "Slice" : "[" + cal.getZUnit() + "]";
            }
        }
        for (int i = 0; i < x.length; ++i) {
            x[i] = (float)(((double)i - origin) * calFactor);
        }
        if (roi != null) {
            Rectangle r = roi.getBounds();
            title = this.imp.getTitle() + "-" + r.x + "-" + r.y;
        } else {
            title = this.imp.getTitle() + "-0-0";
        }
        Plot plot = new Plot(title, xAxisLabel, "Mean", x, y);
        boolean bl = useConnectedCircles = x.length <= 60;
        if (useConnectedCircles) {
            plot.setStyle(0, "black, gray, 1, connected");
        }
        plot.setColor(Color.black);
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        if (ymin != 0.0 || ymax != 0.0) {
            a = Tools.getMinMax(x);
            double xmin = a[0];
            double xmax = a[1];
            plot.setLimits(xmin, xmax, ymin, ymax);
        } else {
            a = Tools.getMinMax(y);
            ymin = a[0];
            ymax = a[1];
        }
        int pos = this.imp.getCurrentSlice();
        if (hyperstack) {
            pos = this.timeProfile ? this.imp.getT() : this.imp.getZ();
        }
        double xx = ((double)(pos - 1) - origin) * calFactor;
        if (!useConnectedCircles) {
            if (pos == 1) {
                xx += calFactor * Math.min(0.4, (double)x.length * 0.7 / (double)plot.getDrawingFrame().width);
            } else if (pos == x.length) {
                xx -= calFactor * Math.min(0.4, (double)x.length * 0.7 / (double)plot.getDrawingFrame().width);
            }
        }
        if (this.firstTime) {
            xx = Double.NaN;
        }
        plot.setColor(Color.blue);
        plot.drawLine(xx, ymin - 10.0 * (ymax - ymin), xx, ymax + 10.0 * (ymax - ymin));
        plot.setColor(Color.black);
        plot.setLineWidth(1);
        this.firstTime = false;
        return plot;
    }

    @Override
    public ImagePlus getSourceImage() {
        return this.imp;
    }

    private float[] getHyperstackProfile(ImagePlus imp, double minThreshold, double maxThreshold) {
        Roi roi = imp.getRoi();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int c = imp.getC();
        int z = imp.getZ();
        int t = imp.getT();
        int size = slices;
        if (this.firstTime) {
            boolean bl = this.timeProfile = slices == 1 && frames > 1;
        }
        if (this.options == null && slices > 1 && frames > 1 && (!this.isPlotMaker || this.firstTime)) {
            this.showingDialog = true;
            GenericDialog gd = new GenericDialog("Profiler");
            gd.addChoice("Profile", choices, choice);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            choice = gd.getNextChoice();
            this.timeProfile = choice.equals(choices[0]);
        }
        if (this.options != null) {
            this.timeProfile = frames > 1 && !this.options.contains("z");
        }
        size = this.timeProfile ? frames : slices;
        float[] values = new float[size];
        Calibration cal = imp.getCalibration();
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, rt);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = !this.isPlotMaker && measurements != 0 && measurements != 256;
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        ImageStack stack = imp.getStack();
        boolean showProgress = size > 400 || stack.isVirtual();
        for (int i = 1; i <= size; ++i) {
            if (showProgress) {
                IJ.showProgress(i, size);
            }
            int index = 1;
            index = this.timeProfile ? imp.getStackIndex(c, z, i) : imp.getStackIndex(c, i, t);
            ImageProcessor ip = stack.getProcessor(index);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            values[i - 1] = (float)stats.mean;
        }
        if (showResults) {
            rt.show("Results");
        }
        return values;
    }

    private float[] getZAxisProfile(ImagePlus imp, double minThreshold, double maxThreshold) {
        int size;
        Roi roi = imp.getRoi();
        ImageStack stack = imp.getStack();
        if (this.firstTime) {
            int slices = imp.getNSlices();
            int frames = imp.getNFrames();
            this.timeProfile = slices == 1 && frames > 1;
        }
        boolean showProgress = (size = stack.size()) > 400 || stack.isVirtual();
        float[] values = new float[size];
        Calibration cal = imp.getCalibration();
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, rt);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = !this.isPlotMaker && measurements != 0 && measurements != 256;
        boolean showingLabels = this.firstTime && showResults && ((measurements & 0x400) != 0 || (measurements & 0x100000) != 0);
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        boolean isLine = roi != null && roi.isLine();
        int current = imp.getCurrentSlice();
        for (int i = 1; i <= size; ++i) {
            ImageProcessor ip;
            if (showProgress) {
                IJ.showProgress(i, size);
            }
            if (showingLabels) {
                imp.setSlice(i);
            }
            if ((ip = stack.getProcessor(i)) == null) {
                IJ.log("ZAxisProfiler: stack.getProcessor(" + i + ") returned null (" + stack.getClass().getName() + "," + imp + ")");
                values[i - 1] = Float.NaN;
                continue;
            }
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = null;
            stats = isLine ? this.getLineStatistics(roi, ip, measurements, cal) : ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            values[i - 1] = (float)stats.mean;
        }
        if (showResults) {
            rt.show("Results");
        }
        if (showingLabels) {
            imp.setSlice(current);
        }
        return values;
    }

    private ImageStatistics getLineStatistics(Roi roi, ImageProcessor ip, int measurements, Calibration cal) {
        ImagePlus imp = new ImagePlus("", ip);
        imp.setRoi(roi);
        ProfilePlot profile = new ProfilePlot(imp);
        double[] values = profile.getProfile();
        FloatProcessor ip2 = new FloatProcessor(values.length, 1, values);
        return ImageStatistics.getStatistics(ip2, measurements, cal);
    }
}

