/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.transform.CoordinateTransform;

public class MovingLeastSquaresTransform2
extends mpicbg.models.MovingLeastSquaresTransform2
implements CoordinateTransform {
    private static final long serialVersionUID = 4878940232249133983L;

    public float[][] getP() {
        return this.p;
    }

    public float[][] getQ() {
        return this.q;
    }

    public float[] getWeight() {
        return this.w;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void init(String data) throws NumberFormatException {
        String[] fields = data.split("\\s+");
        if (fields.length <= 3) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        int n = Integer.parseInt(fields[1]);
        if ((fields.length - 3) % (2 * n + 1) != 0) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        int l = (fields.length - 3) / (2 * n + 1);
        if (n == 2) {
            if (fields[0].equals("translation")) {
                this.model = new TranslationModel2D();
            } else if (fields[0].equals("rigid")) {
                this.model = new RigidModel2D();
            } else if (fields[0].equals("similarity")) {
                this.model = new SimilarityModel2D();
            } else {
                if (!fields[0].equals("affine")) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
                this.model = new AffineModel2D();
            }
        } else {
            if (n != 3) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
            if (!fields[0].equals("affine")) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
            this.model = new AffineModel3D();
        }
        this.alpha = Float.parseFloat(fields[2]);
        this.p = new float[n][l];
        this.q = new float[n][l];
        this.w = new float[l];
        int i = 2;
        int j = 0;
        while (i < fields.length - 1) {
            int d;
            for (d = 0; d < n; ++d) {
                this.p[d][j] = Float.parseFloat(fields[++i]);
            }
            for (d = 0; d < n; ++d) {
                this.q[d][j] = Float.parseFloat(fields[++i]);
            }
            this.w[j] = Float.parseFloat(fields[++i]);
            ++j;
        }
    }

    public void init2(String s) throws Exception {
        int len = s.length();
        int i = 0;
        while (' ' != s.charAt(++i)) {
        }
        char modelLastChar = s.charAt(i - 1);
        int n = s.charAt(i + 1) - 48;
        block0 : switch (n) {
            case 3: {
                this.model = new AffineModel3D();
                break;
            }
            case 2: {
                switch (modelLastChar) {
                    case 'n': {
                        this.model = new TranslationModel2D();
                        break block0;
                    }
                    case 'd': {
                        this.model = new RigidModel2D();
                        break block0;
                    }
                    case 'y': {
                        this.model = new SimilarityModel2D();
                        break block0;
                    }
                    case 'e': {
                        this.model = new AffineModel2D();
                        break block0;
                    }
                }
                throw new Exception("Unknown model " + s.substring(0, i));
            }
            default: {
                throw new NumberFormatException("Unsupported model dimensions: " + n + " for " + this.getClass().getCanonicalName());
            }
        }
        int cut = (i += 2) - 1;
        while (' ' != s.charAt(++i)) {
        }
        float[] f = new float[1];
        MovingLeastSquaresTransform2.parse(s, cut, i - 1, f, 0);
        this.alpha = f[0];
        int nVals = 0;
        for (int k = i; k < len; ++k) {
            if (' ' != s.charAt(k)) continue;
            ++nVals;
        }
        int cell = n + n + 1;
        if (0 != nVals % cell) {
            throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        }
        this.p = new float[n][nVals / cell];
        this.q = new float[n][this.p[0].length];
        this.w = new float[this.p[0].length];
        cut = i - 1;
        i = len - 1;
        int count = 0;
        if (2 == n) {
            while (i > cut) {
                switch (count % cell) {
                    case 0: {
                        f = this.w;
                        break;
                    }
                    case 1: {
                        f = this.q[1];
                        break;
                    }
                    case 2: {
                        f = this.q[0];
                        break;
                    }
                    case 3: {
                        f = this.p[1];
                        break;
                    }
                    case 4: {
                        f = this.p[0];
                    }
                }
                i = MovingLeastSquaresTransform2.parse(s, cut, i, f, this.w.length - count / cell - 1);
                ++count;
            }
        } else {
            while (i > cut) {
                switch (count % (n + n + 1)) {
                    case 0: {
                        f = this.w;
                        break;
                    }
                    case 1: {
                        f = this.q[2];
                        break;
                    }
                    case 2: {
                        f = this.q[1];
                        break;
                    }
                    case 3: {
                        f = this.q[0];
                        break;
                    }
                    case 4: {
                        f = this.p[2];
                        break;
                    }
                    case 5: {
                        f = this.p[1];
                        break;
                    }
                    case 6: {
                        f = this.p[0];
                    }
                }
                i = MovingLeastSquaresTransform2.parse(s, cut, i, f, this.w.length - count / cell - 1);
                ++count;
            }
        }
    }

    private static final int parse(String s, int cut, int i, float[] f, int k) {
        int last = i + 1;
        while (i > cut) {
            if (' ' == s.charAt(i)) {
                f[k] = Float.parseFloat(s.substring(i + 1, last));
                return i - 1;
            }
            --i;
        }
        return Integer.MIN_VALUE;
    }

    private static final int parse1(String s, int cut, int i, float[] f, int k) {
        int pos = 1;
        int numI = 0;
        float numF = 0.0f;
        int sign = 1;
        int exp = 0;
        while (i > cut) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    f[k] = (float)((double)(((float)numI + numF) * (float)sign) * Math.pow(10.0, exp));
                    return i - 1;
                }
                case '-': {
                    sign = -1;
                    break;
                }
                case '.': {
                    numF = numI;
                    numF /= (float)pos;
                    numI = 0;
                    pos = 1;
                    break;
                }
                case 'E': {
                    exp = numI * sign;
                    numI = 0;
                    sign = 1;
                    break;
                }
                default: {
                    numI += (c - 48) * pos;
                    pos *= 10;
                }
            }
            --i;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public String toDataString() {
        StringBuilder data = new StringBuilder();
        this.toDataString(data);
        return data.toString();
    }

    private final void toDataString(StringBuilder data) {
        if (AffineModel2D.class.isInstance(this.model)) {
            data.append("affine 2");
        } else if (TranslationModel2D.class.isInstance(this.model)) {
            data.append("translation 2");
        } else if (RigidModel2D.class.isInstance(this.model)) {
            data.append("rigid 2");
        } else if (SimilarityModel2D.class.isInstance(this.model)) {
            data.append("similarity 2");
        } else if (AffineModel3D.class.isInstance(this.model)) {
            data.append("affine 3");
        } else {
            data.append("unknown");
        }
        data.append(' ').append(this.alpha);
        int n = this.p.length;
        int l = this.p[0].length;
        for (int i = 0; i < l; ++i) {
            int d;
            for (d = 0; d < n; ++d) {
                data.append(' ').append(this.p[d][i]);
            }
            for (d = 0; d < n; ++d) {
                data.append(' ').append(this.q[d][i]);
            }
            data.append(' ').append(this.w[i]);
        }
    }

    @Override
    public final String toXML(String indent) {
        StringBuilder xml = new StringBuilder(80000);
        xml.append(indent).append("<ict_transform class=\"").append(this.getClass().getCanonicalName()).append("\" data=\"");
        this.toDataString(xml);
        return xml.append("\"/>").toString();
    }

    @Override
    public final MovingLeastSquaresTransform2 copy() {
        int k;
        int i;
        MovingLeastSquaresTransform2 t = new MovingLeastSquaresTransform2();
        t.model = this.model.copy();
        t.alpha = this.alpha;
        t.p = new float[this.p.length][this.p[0].length];
        for (i = 0; i < this.p.length; ++i) {
            for (k = 0; k < this.p[0].length; ++k) {
                t.p[i][k] = this.p[i][k];
            }
        }
        t.q = new float[this.q.length][this.q[0].length];
        for (i = 0; i < this.q.length; ++i) {
            for (k = 0; k < this.q[0].length; ++k) {
                t.q[i][k] = this.q[i][k];
            }
        }
        t.w = new float[this.w.length];
        for (i = 0; i < this.w.length; ++i) {
            t.w[i] = this.w[i];
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyInPlace(double[] location) {
        float[] ww = new float[this.w.length];
        for (int i = 0; i < this.w.length; ++i) {
            int d;
            double s = 0.0;
            for (d = 0; d < location.length; ++d) {
                double dx = (double)this.p[d][i] - location[d];
                s += dx * dx;
            }
            if (s <= 0.0) {
                for (d = 0; d < location.length; ++d) {
                    location[d] = this.q[d][i];
                }
                return;
            }
            ww[i] = (float)((double)this.w[i] * this.weigh(s));
        }
        try {
            Model model = this.model;
            synchronized (model) {
                this.model.fit(this.p, this.q, ww);
                this.model.applyInPlace(location);
            }
        }
        catch (IllDefinedDataPointsException illDefinedDataPointsException) {
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            // empty catch block
        }
    }
}

