/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.SplitFunction;
import ai.Splitter;
import ij.IJ;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import weka.core.Instance;
import weka.core.Instances;

public class BalancedRandomTree
implements Serializable {
    private static final long serialVersionUID = 41518309467L;
    private final BaseNode rootNode;

    public BalancedRandomTree(Instances data, ArrayList<Integer> bagIndices, Splitter splitter) {
        this.rootNode = this.createNode(data, bagIndices, splitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BaseNode createNode(Instances data, ArrayList<Integer> bagIndices, Splitter splitter) {
        long start = System.currentTimeMillis();
        try {
            InteriorNode interiorNode = this.createTree(data, bagIndices, 0, splitter);
            return interiorNode;
        }
        finally {
            long end = System.currentTimeMillis();
            IJ.log((String)("Creating tree took: " + (end - start) + "ms"));
        }
    }

    public double[] evaluate(Instance instance) {
        if (null == this.rootNode) {
            return null;
        }
        return this.rootNode.eval(instance);
    }

    private InteriorNode createTree(Instances data, ArrayList<Integer> indices, int depth, Splitter splitFnProducer) {
        int maxDepth = depth;
        InteriorNode root = new InteriorNode(depth, splitFnProducer.getSplitFunction(data, indices));
        LinkedList<InteriorNode> remainingNodes = new LinkedList<InteriorNode>();
        remainingNodes.add(root);
        LinkedList<ArrayList<Integer>> remainingIndices = new LinkedList<ArrayList<Integer>>();
        remainingIndices.add(indices);
        while (!remainingNodes.isEmpty()) {
            InteriorNode currentNode = (InteriorNode)remainingNodes.removeLast();
            ArrayList currentIndices = (ArrayList)remainingIndices.removeLast();
            ArrayList<Integer> leftArray = new ArrayList<Integer>();
            ArrayList<Integer> rightArray = new ArrayList<Integer>();
            for (Integer it : currentIndices) {
                if (currentNode.splitFn.evaluate(data.get(it.intValue()))) {
                    leftArray.add(it);
                    continue;
                }
                rightArray.add(it);
            }
            if (currentNode.depth > maxDepth) {
                maxDepth = currentNode.depth;
            }
            if (leftArray.isEmpty()) {
                currentNode.left = new LeafNode(data, rightArray);
                continue;
            }
            if (rightArray.isEmpty()) {
                currentNode.left = new LeafNode(data, leftArray);
                continue;
            }
            currentNode.left = new InteriorNode(currentNode.depth + 1, splitFnProducer.getSplitFunction(data, leftArray));
            remainingNodes.add((InteriorNode)currentNode.left);
            remainingIndices.add(leftArray);
            currentNode.right = new InteriorNode(currentNode.depth + 1, splitFnProducer.getSplitFunction(data, rightArray));
            remainingNodes.add((InteriorNode)currentNode.right);
            remainingIndices.add(rightArray);
        }
        System.out.println("Max depth = " + maxDepth);
        return root;
    }

    class InteriorNode
    extends BaseNode
    implements Serializable {
        private static final long serialVersionUID = 9972970234021L;
        private BaseNode left;
        private BaseNode right;
        private final int depth;
        private final SplitFunction splitFn;

        private InteriorNode(int depth, SplitFunction splitFn) {
            this.depth = depth;
            this.splitFn = splitFn;
        }

        @Override
        public double[] eval(Instance instance) {
            if (null != this.right) {
                if (this.splitFn.evaluate(instance)) {
                    return this.left.eval(instance);
                }
                return this.right.eval(instance);
            }
            return this.left.eval(instance);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }
    }

    class LeafNode
    extends BaseNode
    implements Serializable {
        private static final long serialVersionUID = 2019873470157L;
        private double[] probability;

        @Override
        public double[] eval(Instance instance) {
            return this.probability;
        }

        public LeafNode(double[] probability) {
            this.probability = probability;
        }

        public LeafNode(Instances data, ArrayList<Integer> indices) {
            this.probability = new double[data.numClasses()];
            for (Integer it : indices) {
                int n = (int)data.get(it.intValue()).classValue();
                this.probability[n] = this.probability[n] + 1.0;
            }
            int i = 0;
            while (i < data.numClasses()) {
                int n = i++;
                this.probability[n] = this.probability[n] / (double)indices.size();
            }
        }
    }

    abstract class BaseNode
    implements Serializable {
        private static final long serialVersionUID = 46734234231L;

        BaseNode() {
        }

        public abstract double[] eval(Instance var1);

        public int getDepth() {
            return 0;
        }
    }
}

