/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.unsupervised;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorSpaceConverter;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import trainableSegmentation.FeatureStack;
import trainableSegmentation.FeatureStackArray;
import trainableSegmentation.ReusableDenseInstance;
import trainableSegmentation.unsupervised.PixelClustering;
import weka.clusterers.AbstractClusterer;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializationHelper;

public class ColorClustering {
    private ArrayList<Channel> channels = new ArrayList();
    private Instances featuresInstances;
    private ImagePlus image;
    private FeatureStackArray featureStackArray;
    private int numSamples;
    private AbstractClusterer theClusterer;

    public ColorClustering(ImagePlus image) {
        this.featuresInstances = null;
        this.image = image;
        this.featureStackArray = null;
        this.numSamples = image.getHeight() * image.getWidth() * image.getNSlices() / 2;
        this.theClusterer = null;
    }

    public ColorClustering(ImagePlus image, int numSamples, ArrayList<Channel> selectedChannels) {
        for (Channel element : selectedChannels) {
            this.channels.add(element);
        }
        this.setImage(image);
        this.setNumSamples(numSamples);
        this.featureStackArray = new FeatureStackArray(image.getStackSize());
        this.createFeatures();
    }

    public AbstractClusterer createClusterer(AbstractClusterer selectedClusterer) {
        PixelClustering pixelClustering = new PixelClustering(this.getFeaturesInstances(), selectedClusterer);
        pixelClustering.buildClusterer();
        AbstractClusterer clusterer = pixelClustering.getSelectedClusterer();
        return clusterer;
    }

    public void createFeatures() {
        int numSlices = this.image.getNSlices();
        int samplesPerSlice = this.numSamples / numSlices;
        this.featureStackArray = new FeatureStackArray(this.image.getStackSize());
        for (int slice = 1; slice <= this.image.getStackSize(); ++slice) {
            ImagePlus hsb;
            ImagePlus rgb;
            int i;
            boolean labactive = false;
            boolean rgbactive = false;
            boolean hsbactive = false;
            ImageStack stack = new ImageStack(this.image.getWidth(), this.image.getHeight());
            ColorSpaceConverter converter = new ColorSpaceConverter();
            for (i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get(i).toString() == "Red" || this.channels.get(i).toString() == "Blue" || this.channels.get(i).toString() == "Green") {
                    rgbactive = true;
                    continue;
                }
                if (this.channels.get(i).toString() == "Lightness" || this.channels.get(i).toString() == "a" || this.channels.get(i).toString() == "b") {
                    labactive = true;
                    continue;
                }
                if (this.channels.get(i).toString() != "Hue" && this.channels.get(i).toString() != "Saturation" && this.channels.get(i).toString() != "Brightness") continue;
                hsbactive = true;
            }
            ImagePlus lab = labactive ? converter.RGBToLab(new ImagePlus("Lab", this.image.getStack().getProcessor(slice))) : null;
            if (rgbactive) {
                rgb = new ImagePlus("RGB", this.image.getStack().getProcessor(slice));
                ImageConverter ic = new ImageConverter(rgb);
                ic.convertToRGBStack();
            } else {
                rgb = null;
            }
            if (hsbactive) {
                hsb = new ImagePlus("HSB", this.image.getStack().getProcessor(slice));
                ImageConverter ic2 = new ImageConverter(hsb);
                ic2.convertToHSB();
            } else {
                hsb = null;
            }
            block13: for (i = 0; i < this.channels.size(); ++i) {
                switch (this.channels.get(i)) {
                    case Lightness: {
                        stack.addSlice("L", lab.getStack().getProcessor(1));
                        continue block13;
                    }
                    case a: {
                        stack.addSlice("a", lab.getStack().getProcessor(2));
                        continue block13;
                    }
                    case b: {
                        stack.addSlice("b", lab.getStack().getProcessor(3));
                        continue block13;
                    }
                    case Red: {
                        stack.addSlice("Red", (ImageProcessor)rgb.getStack().getProcessor(1).convertToFloatProcessor());
                        continue block13;
                    }
                    case Green: {
                        stack.addSlice("Green", (ImageProcessor)rgb.getStack().getProcessor(2).convertToFloatProcessor());
                        continue block13;
                    }
                    case Blue: {
                        stack.addSlice("Blue", (ImageProcessor)rgb.getStack().getProcessor(3).convertToFloatProcessor());
                        continue block13;
                    }
                    case Hue: {
                        stack.addSlice("Hue", (ImageProcessor)hsb.getStack().getProcessor(1).convertToFloatProcessor());
                        continue block13;
                    }
                    case Saturation: {
                        stack.addSlice("Saturation", (ImageProcessor)hsb.getStack().getProcessor(2).convertToFloatProcessor());
                        continue block13;
                    }
                    case Brightness: {
                        stack.addSlice("Brightness", (ImageProcessor)hsb.getStack().getProcessor(3).convertToFloatProcessor());
                    }
                }
            }
            FeatureStack features = new FeatureStack(stack.getWidth(), stack.getHeight(), false);
            features.setStack(stack);
            this.featureStackArray.set(features, slice - 1);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (int i2 = 1; i2 <= this.featureStackArray.get(slice - 1).getSize(); ++i2) {
                String attString = this.featureStackArray.get(slice - 1).getSliceLabel(i2);
                attributes.add(new Attribute(attString));
            }
            this.featuresInstances = new Instances(this.image.getShortTitle() + "-features", attributes, 1);
            ArrayList<Point> positions = new ArrayList<Point>();
            for (int x = 0; x < this.image.getWidth(); ++x) {
                for (int y = 0; y < this.image.getHeight(); ++y) {
                    positions.add(new Point(x, y));
                }
            }
            Collections.shuffle(positions);
            for (int i3 = 0; i3 < samplesPerSlice; ++i3) {
                this.featuresInstances.add((Instance)this.featureStackArray.get(slice - 1).createInstance(((Point)positions.get((int)i3)).x, ((Point)positions.get((int)i3)).y));
            }
        }
    }

    public FeatureStackArray createFSArray(ImagePlus image) {
        FeatureStackArray fsa = new FeatureStackArray(image.getStackSize());
        for (int slice = 1; slice <= image.getStackSize(); ++slice) {
            ImagePlus hsb;
            ImagePlus rgb;
            int i;
            boolean labactive = false;
            boolean rgbactive = false;
            boolean hsbactive = false;
            ImageStack stack = new ImageStack(image.getWidth(), image.getHeight());
            ColorSpaceConverter converter = new ColorSpaceConverter();
            for (i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get(i).toString() == "Red" || this.channels.get(i).toString() == "Blue" || this.channels.get(i).toString() == "Green") {
                    rgbactive = true;
                    continue;
                }
                if (this.channels.get(i).toString() == "Lightness" || this.channels.get(i).toString() == "a" || this.channels.get(i).toString() == "b") {
                    labactive = true;
                    continue;
                }
                if (this.channels.get(i).toString() != "Hue" && this.channels.get(i).toString() != "Saturation" && this.channels.get(i).toString() != "Brightness") continue;
                hsbactive = true;
            }
            ImagePlus lab = labactive ? converter.RGBToLab(new ImagePlus("Lab", image.getStack().getProcessor(slice))) : null;
            if (rgbactive) {
                rgb = new ImagePlus("RGB", image.getStack().getProcessor(slice));
                ImageConverter ic = new ImageConverter(rgb);
                ic.convertToRGBStack();
            } else {
                rgb = null;
            }
            if (hsbactive) {
                hsb = new ImagePlus("HSB", image.getStack().getProcessor(slice));
                ImageConverter ic2 = new ImageConverter(hsb);
                ic2.convertToHSB();
            } else {
                hsb = null;
            }
            block13: for (i = 0; i < this.channels.size(); ++i) {
                switch (this.channels.get(i)) {
                    case Lightness: {
                        stack.addSlice("L", lab.getStack().getProcessor(1));
                        continue block13;
                    }
                    case a: {
                        stack.addSlice("a", lab.getStack().getProcessor(2));
                        continue block13;
                    }
                    case b: {
                        stack.addSlice("b", lab.getStack().getProcessor(3));
                        continue block13;
                    }
                    case Red: {
                        stack.addSlice("Red", (ImageProcessor)rgb.getStack().getProcessor(1).convertToFloatProcessor());
                        continue block13;
                    }
                    case Green: {
                        stack.addSlice("Green", (ImageProcessor)rgb.getStack().getProcessor(2).convertToFloatProcessor());
                        continue block13;
                    }
                    case Blue: {
                        stack.addSlice("Blue", (ImageProcessor)rgb.getStack().getProcessor(3).convertToFloatProcessor());
                        continue block13;
                    }
                    case Hue: {
                        stack.addSlice("Hue", (ImageProcessor)hsb.getStack().getProcessor(1).convertToFloatProcessor());
                        continue block13;
                    }
                    case Saturation: {
                        stack.addSlice("Saturation", (ImageProcessor)hsb.getStack().getProcessor(2).convertToFloatProcessor());
                        continue block13;
                    }
                    case Brightness: {
                        stack.addSlice("Brightness", (ImageProcessor)hsb.getStack().getProcessor(3).convertToFloatProcessor());
                    }
                }
            }
            FeatureStack features = new FeatureStack(stack.getWidth(), stack.getHeight(), false);
            features.setStack(stack);
            fsa.set(features, slice - 1);
        }
        return fsa;
    }

    public ImagePlus createProbabilityMaps(FeatureStackArray featureStackArray) {
        int numClusters = 0;
        try {
            numClusters = this.theClusterer.numberOfClusters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calibration calibration = new Calibration();
        calibration = this.image.getCalibration();
        int height = featureStackArray.getHeight();
        int width = featureStackArray.getWidth();
        int numInstances = height * width;
        ImageStack clusteringResult = new ImageStack(width, height);
        for (int slice = 1; slice <= featureStackArray.getSize(); ++slice) {
            int i;
            double[][] clusterArray = new double[numClusters][numInstances];
            FeatureStack features = featureStackArray.get(slice - 1);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStackArray.get(slice - 1).getSize(); ++i) {
                String attString = featureStackArray.get(slice - 1).getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStackArray.get(slice - 1).useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            Instances instances = new Instances(this.image.getTitle() + "-features", attributes, 1);
            double[] values = new double[features.getSize()];
            ReusableDenseInstance ins = new ReusableDenseInstance(1.0, values);
            ins.setDataset(instances);
            String[] classLabels = new String[numClusters];
            for (int i2 = 0; i2 < numClusters; ++i2) {
                classLabels[i2] = "Cluster " + i2;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    features.setInstance(x, y, ins, values);
                    try {
                        double[] prob = this.theClusterer.distributionForInstance((Instance)ins);
                        for (int k = 0; k < numClusters; ++k) {
                            clusterArray[k][x + y * width] = prob[k];
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
            for (int k = 0; k < numClusters; ++k) {
                FloatProcessor processor = new FloatProcessor(width, height, clusterArray[k]);
                try {
                    processor.setMinAndMax(0.0, 1.0);
                }
                catch (Exception e) {
                    IJ.log((String)("Error when setting histogram range in slice: " + slice));
                }
                clusteringResult.addSlice(classLabels[k], (ImageProcessor)processor);
            }
        }
        ImagePlus result = new ImagePlus("Probability map image", clusteringResult);
        result.setCalibration(calibration);
        result.setDimensions(numClusters, this.image.getNSlices(), this.image.getNFrames());
        if (this.image.getNSlices() * this.image.getNFrames() > 1) {
            result.setOpenAsHyperStack(true);
        }
        return result;
    }

    public ImagePlus createClusteredImage(FeatureStackArray featureStackArray) {
        Calibration calibration = new Calibration();
        calibration = this.image.getCalibration();
        int height = featureStackArray.getHeight();
        int width = featureStackArray.getWidth();
        int numInstances = height * width;
        ImageStack clusteringResult = new ImageStack(width, height);
        for (int slice = 1; slice <= featureStackArray.getSize(); ++slice) {
            byte[] clusterArray = new byte[numInstances];
            FeatureStack features = featureStackArray.get(slice - 1);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (int i = 1; i <= featureStackArray.get(slice - 1).getSize(); ++i) {
                String attString = featureStackArray.get(slice - 1).getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            Instances instances = new Instances(this.image.getShortTitle() + "-features", attributes, 1);
            double[] values = new double[features.getSize()];
            ReusableDenseInstance ins = new ReusableDenseInstance(1.0, values);
            ins.setDataset(instances);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    features.setInstance(x, y, ins, values);
                    try {
                        clusterArray[x + y * width] = (byte)this.theClusterer.clusterInstance((Instance)ins);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
            ByteProcessor processor = new ByteProcessor(width, height, clusterArray);
            try {
                processor.setMinAndMax(0.0, (double)this.theClusterer.numberOfClusters());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            clusteringResult.addSlice((ImageProcessor)processor);
        }
        ImagePlus result = new ImagePlus("Clustered image", clusteringResult);
        result.setCalibration(calibration);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFile(String path, Instances theInstances) {
        boolean saved = false;
        if (path != null) {
            File file = new File(path);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
                Instances header = new Instances(theInstances, 0);
                out.write(header.toString());
                for (int i = 0; i < theInstances.numInstances(); ++i) {
                    out.write(theInstances.get(i).toString() + "\n");
                }
                saved = true;
            }
            catch (Exception e) {
                saved = false;
                IJ.log((String)"Error: couldn't write instances into .ARFF file.");
                IJ.showMessage((String)"Exception while saving data as ARFF file");
                e.printStackTrace();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            IJ.log((String)"Error when choosing path");
        }
        return saved;
    }

    public boolean saveClusterer(String filename) {
        File sFile = null;
        boolean saveOK = true;
        IJ.log((String)"Saving model to file...");
        try {
            sFile = new File(filename);
            OutputStream os = new FileOutputStream(sFile);
            if (sFile.getName().endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
            objectOutputStream.writeObject(this.theClusterer);
            Instances trainHeader = new Instances(this.featuresInstances, 0);
            objectOutputStream.writeObject(trainHeader);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception e) {
            IJ.error((String)"Save Failed", (String)"Error when saving classifier into a file");
            saveOK = false;
        }
        if (saveOK) {
            IJ.log((String)("Saved model into " + filename));
        }
        return saveOK;
    }

    public boolean loadClusterer(String path) {
        File selected = new File(path);
        try {
            ObjectInputStream objectInputStream;
            AbstractClusterer clusterer;
            InputStream is = new FileInputStream(selected);
            if (selected.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            if (null == (clusterer = (AbstractClusterer)(objectInputStream = SerializationHelper.getObjectInputStream((InputStream)is)).readObject())) {
                return false;
            }
            Instances ins = (Instances)objectInputStream.readObject();
            if (null == ins) {
                return false;
            }
            this.theClusterer = clusterer;
            this.featuresInstances = ins;
            objectInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public void setImage(ImagePlus image) {
        this.image = image;
    }

    public FeatureStackArray getFeatureStackArray() {
        return this.featureStackArray;
    }

    public void setFeatureStackArray(FeatureStackArray featureStackArray) {
        this.featureStackArray = featureStackArray;
    }

    public Instances getFeaturesInstances() {
        return this.featuresInstances;
    }

    public void setFeaturesInstances(Instances featuresInstances) {
        this.featuresInstances = featuresInstances;
    }

    public AbstractClusterer getTheClusterer() {
        return this.theClusterer;
    }

    public void setTheClusterer(AbstractClusterer theClusterer) {
        this.theClusterer = theClusterer;
    }

    public void setChannels(ArrayList<Channel> selectedChannels) {
        this.channels = selectedChannels;
    }

    public static enum Channel {
        Red("Red"),
        Green("Green"),
        Blue("Blue"),
        Lightness("Lightness"),
        a("a"),
        b("b"),
        Hue("Hue"),
        Saturation("Saturation"),
        Brightness("Brightness");

        private final String label;

        private Channel(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static int numChannels() {
            return Channel.getAllLabels().length;
        }

        public static String[] getAllLabels() {
            int n = Channel.values().length;
            String[] result = new String[n];
            int i = 0;
            for (Channel ch : Channel.values()) {
                result[i++] = ch.label;
            }
            return result;
        }

        public static Channel fromLabel(String chLabel) {
            if (chLabel != null) {
                chLabel = chLabel.toLowerCase();
                for (Channel ch : Channel.values()) {
                    String cmp = ch.label.toLowerCase();
                    if (!cmp.equals(chLabel)) continue;
                    return ch;
                }
                throw new IllegalArgumentException("Unable to parse Channel with label: " + chLabel);
            }
            return null;
        }
    }
}

