/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.measure.ResultsTable;
import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.jogamp.vecmath.Point3f;
import trainableSegmentation.metrics.ClassificationStatistics;
import util.FindConnectedRegions;

public final class Utils {
    private Utils() throws InstantiationException {
        throw new InstantiationException("This class is not created for instantiation");
    }

    public static FindConnectedRegions.Results connectedComponents(ImagePlus im, int adjacency) {
        if (adjacency != 4 && adjacency != 8) {
            return null;
        }
        boolean diagonal = adjacency == 8;
        FindConnectedRegions fcr = new FindConnectedRegions();
        try {
            FindConnectedRegions.Results r = fcr.run(im, diagonal, false, true, false, false, false, false, 0.0, 1.0, -1, true);
            return r;
        }
        catch (IllegalArgumentException iae) {
            IJ.error((String)("" + iae));
            return null;
        }
    }

    public static FindConnectedRegions.Results connectedComponents(ImagePlus im, int adjacency, int minSize) {
        if (adjacency != 4 && adjacency != 8) {
            return null;
        }
        boolean diagonal = adjacency == 8;
        FindConnectedRegions fcr = new FindConnectedRegions();
        try {
            FindConnectedRegions.Results r = fcr.run(im, diagonal, false, true, false, false, false, false, 0.0, (double)minSize, -1, true);
            return r;
        }
        catch (IllegalArgumentException iae) {
            IJ.error((String)("" + iae));
            return null;
        }
    }

    public static void plotPrecisionRecall(ArrayList<ClassificationStatistics> stats) {
        float[] precision = new float[stats.size()];
        float[] recall = new float[stats.size()];
        for (int i = 0; i < precision.length; ++i) {
            precision[i] = (float)stats.get((int)i).precision;
            recall[i] = (float)stats.get((int)i).recall;
        }
        Plot pl = new Plot("Precision-Recall curve", "Recall [tp / (tp + fn)]", "Precision [tp / (tp+fp)]", recall, precision);
        pl.setLimits(0.0, 1.0, 0.0, 1.0);
        pl.setSize(540, 512);
        pl.setColor(Color.GREEN);
        pl.show();
    }

    public static void plotROC(ArrayList<ClassificationStatistics> stats) {
        float[] tpr = new float[stats.size()];
        float[] fpr = new float[stats.size()];
        for (int i = 0; i < tpr.length; ++i) {
            tpr[i] = (float)stats.get((int)i).recall;
            fpr[i] = (float)(1.0 - stats.get((int)i).specificity);
        }
        Plot pl = new Plot("Receiver Operating Characteristic curve", "False Positive Rate (1 - specificity)", "True Positive Rate or sensitivity", fpr, tpr);
        pl.setLimits(0.0, 1.0, 0.0, 1.0);
        pl.setSize(540, 512);
        pl.setColor(Color.RED);
        pl.show();
    }

    public static double getPrecRecArea(ArrayList<ClassificationStatistics> stats) {
        int n = stats.size();
        double area = 0.0;
        double xlast = stats.get((int)(n - 1)).recall;
        for (int i = n - 2; i >= 0; --i) {
            double recallDelta = stats.get((int)i).recall - xlast;
            area += stats.get((int)i).precision * recallDelta;
            xlast = stats.get((int)i).recall;
        }
        return area;
    }

    public static double getROCArea(ArrayList<ClassificationStatistics> stats) {
        int n = stats.size();
        double area = 0.0;
        double cumNeg = 0.0;
        double totalPos = stats.get((int)0).truePositives;
        double totalNeg = stats.get((int)0).falsePositives;
        for (int i = 0; i < n; ++i) {
            double cin;
            double cip;
            if (i < n - 1) {
                cip = stats.get((int)i).truePositives - stats.get((int)(i + 1)).truePositives;
                cin = stats.get((int)i).falsePositives - stats.get((int)(i + 1)).falsePositives;
            } else {
                cip = stats.get((int)(n - 1)).truePositives;
                cin = stats.get((int)(n - 1)).falsePositives;
            }
            area += cip * (cumNeg + 0.5 * cin);
            cumNeg += cin;
        }
        return area /= totalNeg * totalPos;
    }

    public static double getKappa(ClassificationStatistics stats) {
        double correct = stats.truePositives + stats.trueNegatives;
        double numSamples = stats.truePositives + stats.falsePositives + stats.falseNegatives + stats.trueNegatives;
        double chanceAgreement = (stats.truePositives + stats.falsePositives) * (stats.truePositives + stats.falseNegatives) + (stats.falseNegatives + stats.trueNegatives) * (stats.falsePositives + stats.trueNegatives);
        chanceAgreement /= numSamples * numSamples;
        correct /= numSamples;
        double kappa = 1.0;
        if (chanceAgreement < 1.0) {
            kappa = (correct - chanceAgreement) / (1.0 - chanceAgreement);
        }
        return kappa;
    }

    public static Plot createPrecisionRecallPlot(ArrayList<ClassificationStatistics> stats) {
        float[] precision = new float[stats.size()];
        float[] recall = new float[stats.size()];
        for (int i = 0; i < precision.length; ++i) {
            precision[i] = (float)stats.get((int)i).precision;
            recall[i] = (float)stats.get((int)i).recall;
        }
        Plot pl = new Plot("Precision-Recall curve", "Recall [tp / (tp + fn)]", "Precision [tp / (tp+fp)]", recall, precision);
        pl.setLimits(0.0, 1.0, 0.0, 1.0);
        pl.setSize(540, 512);
        pl.setColor(Color.GREEN);
        return pl;
    }

    public static ImageStack normalize(ImageStack inputStack) {
        ImageStack is = new ImageStack(inputStack.getWidth(), inputStack.getHeight());
        for (int slice = 1; slice <= inputStack.getSize(); ++slice) {
            is.addSlice(inputStack.getSliceLabel(slice), (ImageProcessor)Utils.normalize(inputStack.getProcessor(slice)));
        }
        return is;
    }

    private static FloatProcessor normalize(ImageProcessor ip) {
        ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)6, null);
        FloatProcessor fp = (FloatProcessor)ip.convertToFloat();
        fp.subtract(stats.mean);
        fp.multiply(1.0 / stats.stdDev);
        return fp;
    }

    public static void smooth(FloatProcessor fp, float f1, float f2, float f3) {
        int idx;
        int x;
        int y;
        float[] cm = (float[])fp.getPixels();
        int xres = fp.getWidth();
        int yres = fp.getHeight();
        for (y = 0; y < yres; ++y) {
            for (x = 0; x < xres - 2; ++x) {
                idx = y * xres + x;
                cm[idx] = f1 * cm[idx] + f2 * cm[idx + 1] + f3 * cm[idx + 2];
            }
        }
        for (y = 0; y < yres; ++y) {
            for (x = xres - 1; x >= 2; --x) {
                idx = y * xres + x;
                cm[idx] = f3 * cm[idx - 2] + f2 * cm[idx - 1] + f1 * cm[idx];
            }
        }
        for (y = 0; y < yres - 2; ++y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = f1 * cm[idx] + f2 * cm[(y + 1) * xres + x] + f3 * cm[(y + 2) * xres + x];
            }
        }
        for (y = yres - 1; y >= 2; --y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = f3 * cm[(y - 2) * xres + x] + f2 * cm[(y - 1) * xres + x] + f1 * cm[idx];
            }
        }
    }

    public static void erode(FloatProcessor fp) {
        int idx;
        int x;
        int y;
        float[] cm = (float[])fp.getPixels();
        int xres = fp.getWidth();
        int yres = fp.getHeight();
        for (y = 0; y < yres; ++y) {
            for (x = 0; x < xres - 1; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[idx], cm[idx + 1]);
            }
        }
        for (y = 0; y < yres; ++y) {
            for (x = xres - 1; x >= 1; --x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[idx - 1], cm[idx]);
            }
        }
        for (y = 0; y < yres - 1; ++y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[idx], cm[(y + 1) * xres + x]);
            }
        }
        for (y = yres - 1; y >= 1; --y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[(y - 1) * xres + x], cm[idx]);
            }
        }
    }

    public static void dilate(FloatProcessor fp) {
        int idx;
        int x;
        int y;
        float[] cm = (float[])fp.getPixels();
        int xres = fp.getWidth();
        int yres = fp.getHeight();
        for (y = 0; y < yres; ++y) {
            for (x = 0; x < xres - 1; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[idx], cm[idx + 1]);
            }
        }
        for (y = 0; y < yres; ++y) {
            for (x = xres - 1; x >= 1; --x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[idx - 1], cm[idx]);
            }
        }
        for (y = 0; y < yres - 1; ++y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[idx], cm[(y + 1) * xres + x]);
            }
        }
        for (y = yres - 1; y >= 1; --y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[(y - 1) * xres + x], cm[idx]);
            }
        }
    }

    public static ByteProcessor threshold(ImageProcessor ip, double thresholdValue) {
        ByteProcessor result = new ByteProcessor(ip.getWidth(), ip.getHeight());
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                if ((double)ip.getPixelValue(x, y) > thresholdValue) {
                    result.putPixelValue(x, y, 255.0);
                    continue;
                }
                result.putPixelValue(x, y, 0.0);
            }
        }
        return result;
    }

    public static void postProcess(FloatProcessor probabilityMap, int smoothIterations, double threshold, int minSize, boolean binarize) {
        GaussianBlur gb = new GaussianBlur();
        gb.blurGaussian((ImageProcessor)probabilityMap, 2.0);
        Utils.normalize01(probabilityMap);
        Utils.erode(probabilityMap);
        Utils.filterSmallObjectsAndHoles(probabilityMap, threshold, minSize);
        for (int i = 0; i < smoothIterations; ++i) {
            gb.blurGaussian((ImageProcessor)probabilityMap, 2.0);
        }
        Utils.normalize01(probabilityMap);
        Utils.filterSmallObjectsAndHoles(probabilityMap, threshold, minSize);
        if (binarize) {
            float[] pixels = (float[])probabilityMap.getPixels();
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (double)pixels[i] > threshold ? 1.0f : 0.0f;
            }
        }
        Utils.dilate(probabilityMap);
        Utils.normalize01(probabilityMap);
    }

    public static void normalize01(FloatProcessor fp) {
        fp.resetMinAndMax();
        double max = fp.getMax();
        double min = fp.getMin();
        double scale = max > min ? 1.0 / (max - min) : 1.0;
        int size = fp.getWidth() * fp.getHeight();
        float[] pixels = (float[])fp.getPixels();
        for (int i = 0; i < size; ++i) {
            double v = (double)pixels[i] - min;
            if (v < 0.0) {
                v = 0.0;
            }
            if ((v *= scale) > 1.0) {
                v = 1.0;
            }
            pixels[i] = (float)v;
        }
    }

    public static void filterSmallObjectsAndHoles(FloatProcessor probabilityMap, double thresholdValue, int minSize) {
        int i;
        ByteProcessor thresholded = Utils.threshold((ImageProcessor)probabilityMap, thresholdValue);
        FindConnectedRegions.Results res = Utils.connectedComponents(new ImagePlus("thresholded", (ImageProcessor)thresholded), 4, minSize);
        ByteProcessor th = Utils.threshold(res.allRegions.getProcessor(), 0.5);
        ByteProcessor th2 = (ByteProcessor)th.duplicate();
        th2.copyBits((ImageProcessor)thresholded, 0, 0, 8);
        byte[] th2pixels = (byte[])th2.getPixels();
        float[] probPixels = (float[])probabilityMap.getPixels();
        for (i = 0; i < th2pixels.length; ++i) {
            if (th2pixels[i] == 0) continue;
            probPixels[i] = 0.0f;
        }
        th2 = (ByteProcessor)th.duplicate();
        Utils.fill((ImageProcessor)th2, 255, 0);
        th2.copyBits((ImageProcessor)th, 0, 0, 8);
        th2pixels = (byte[])th2.getPixels();
        for (i = 0; i < th2pixels.length; ++i) {
            if (th2pixels[i] == 0) continue;
            probPixels[i] = 1.0f;
        }
    }

    public static void fill(ImageProcessor ip, int foreground, int background) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        FloodFiller ff = new FloodFiller(ip);
        ip.setColor(127);
        for (int y = 0; y < height; ++y) {
            if (ip.getPixel(0, y) == background) {
                ff.fill(0, y);
            }
            if (ip.getPixel(width - 1, y) != background) continue;
            ff.fill(width - 1, y);
        }
        for (int x = 0; x < width; ++x) {
            if (ip.getPixel(x, 0) == background) {
                ff.fill(x, 0);
            }
            if (ip.getPixel(x, height - 1) != background) continue;
            ff.fill(x, height - 1);
        }
        byte[] pixels = (byte[])ip.getPixels();
        int n = width * height;
        for (int i = 0; i < n; ++i) {
            pixels[i] = pixels[i] == 127 ? (byte)background : (byte)foreground;
        }
    }

    public static ArrayList<Point3f>[] getClassCoordinates(ImagePlus labelImage, ImagePlus mask) {
        ArrayList[] classPoints = new ArrayList[]{new ArrayList(), new ArrayList()};
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        int size = labelImage.getImageStackSize();
        if (null != mask) {
            for (int slice = 1; slice <= size; ++slice) {
                float[] labelsPix = (float[])labelImage.getImageStack().getProcessor(slice).convertToFloat().getPixels();
                float[] maskPix = (float[])mask.getImageStack().getProcessor(slice).convertToFloat().getPixels();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (!(maskPix[x + y * width] > 0.0f)) continue;
                        if (labelsPix[x + y * width] != 0.0f) {
                            classPoints[1].add(new Point3f(new float[]{x, y, slice - 1}));
                            continue;
                        }
                        classPoints[0].add(new Point3f(new float[]{x, y, slice - 1}));
                    }
                }
            }
        } else {
            for (int slice = 1; slice <= size; ++slice) {
                float[] labelsPix = (float[])labelImage.getImageStack().getProcessor(slice).convertToFloat().getPixels();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (labelsPix[x + y * width] != 0.0f) {
                            classPoints[1].add(new Point3f(new float[]{x, y, slice - 1}));
                            continue;
                        }
                        classPoints[0].add(new Point3f(new float[]{x, y, slice - 1}));
                    }
                }
            }
        }
        return classPoints;
    }

    public static ImagePlus[] maxPool(ImagePlus input, ImagePlus label, int sizeX, int sizeY) {
        int maxPoolWidth = input.getWidth() / sizeX;
        int maxPoolHeight = input.getHeight() / sizeY;
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        ImageStack isMaxPoolInput = new ImageStack(maxPoolWidth, maxPoolHeight);
        ImageStack isMaxPoolLabel = new ImageStack(maxPoolWidth, maxPoolHeight);
        ImagePlus[] maxPool = new ImagePlus[2];
        for (int slice = 1; slice <= input.getImageStackSize(); ++slice) {
            IJ.log((String)("Processing slice " + slice + "..."));
            double[] inputPix = new double[maxPoolWidth * maxPoolHeight];
            byte[] labelPix = new byte[maxPoolWidth * maxPoolHeight];
            int pos2 = 0;
            for (int y = 0; y < inputHeight; y += sizeY) {
                for (int x = 0; x < inputWidth; x += sizeX) {
                    double max = 0.0;
                    for (int x2 = 0; x2 < sizeX; ++x2) {
                        for (int y2 = 0; y2 < sizeY; ++y2) {
                            int pos = (y2 + y) * inputWidth + x2 + x;
                            double val = ((float[])input.getImageStack().getProcessor(slice).getPixels())[pos];
                            if (!(val > max)) continue;
                            inputPix[pos2] = val;
                            labelPix[pos2] = ((byte[])label.getImageStack().getProcessor(slice).getPixels())[pos];
                        }
                    }
                    ++pos2;
                }
            }
            isMaxPoolInput.addSlice((ImageProcessor)new FloatProcessor(maxPoolWidth, maxPoolHeight, inputPix));
            isMaxPoolLabel.addSlice((ImageProcessor)new ByteProcessor(maxPoolWidth, maxPoolHeight, labelPix, null));
        }
        maxPool[0] = new ImagePlus("Input", isMaxPoolInput);
        maxPool[1] = new ImagePlus("Labels", isMaxPoolLabel);
        return maxPool;
    }

    public static ImagePlus[] maxPoolNoReduction(ImagePlus input, ImagePlus label, int sizeX, int sizeY) {
        int width = input.getWidth();
        int height = input.getHeight();
        ImageStack isMaxPoolInput = new ImageStack(width, height);
        ImageStack isMaxPoolLabel = new ImageStack(width, height);
        ImagePlus[] maxPool = new ImagePlus[2];
        for (int slice = 1; slice <= input.getImageStackSize(); ++slice) {
            IJ.log((String)("Processing slice " + slice + "..."));
            double[] inputPix = new double[width * height];
            byte[] labelPix = new byte[width * height];
            for (int y = 0; y < height; y += sizeY) {
                for (int x = 0; x < width; x += sizeX) {
                    int pos;
                    int y2;
                    int x2;
                    double max = 0.0;
                    double maxVal = 0.0;
                    byte maxLabel = 0;
                    for (x2 = 0; x2 < sizeX; ++x2) {
                        for (y2 = 0; y2 < sizeY; ++y2) {
                            pos = (y2 + y) * width + x2 + x;
                            double val = ((float[])input.getImageStack().getProcessor(slice).getPixels())[pos];
                            if (!(val > max)) continue;
                            maxVal = val;
                            maxLabel = ((byte[])label.getImageStack().getProcessor(slice).getPixels())[pos];
                        }
                    }
                    for (x2 = 0; x2 < sizeX; ++x2) {
                        for (y2 = 0; y2 < sizeY; ++y2) {
                            pos = (y2 + y) * width + x2 + x;
                            inputPix[pos] = maxVal;
                            labelPix[pos] = maxLabel;
                        }
                    }
                }
            }
            isMaxPoolInput.addSlice((ImageProcessor)new FloatProcessor(width, height, inputPix));
            isMaxPoolLabel.addSlice((ImageProcessor)new ByteProcessor(width, height, labelPix, null));
        }
        maxPool[0] = new ImagePlus("Input", isMaxPoolInput);
        maxPool[1] = new ImagePlus("Labels", isMaxPoolLabel);
        return maxPool;
    }

    public static LUT getGoldenAngleLUT() {
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        float hue = 0.0f;
        float saturation = 1.0f;
        for (int i = 0; i < 256; ++i) {
            Color c = Color.getHSBColor(hue, saturation, 1.0f);
            red[i] = (byte)c.getRed();
            green[i] = (byte)c.getGreen();
            blue[i] = (byte)c.getBlue();
            if ((hue += 0.38197f) > 1.0f) {
                hue -= 1.0f;
            }
            if ((saturation += 0.38197f) > 1.0f) {
                saturation -= 1.0f;
            }
            saturation = 0.5f * saturation + 0.5f;
        }
        return new LUT(red, green, blue);
    }

    public static LUT createLUT(Color[] colors) {
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        for (int i = 0; i < colors.length; ++i) {
            red[i] = (byte)colors[i].getRed();
            green[i] = (byte)colors[i].getGreen();
            blue[i] = (byte)colors[i].getBlue();
        }
        return new LUT(red, green, blue);
    }

    public static boolean insertImage(ImagePlus src, ImagePlus dst, int[] origin) {
        if (src.getNDimensions() != dst.getNDimensions()) {
            IJ.log((String)"Error in insertImage: different source and destination image dimensions.");
            return false;
        }
        int firstZ = 1;
        int lastZ = 1;
        if (origin.length == 3) {
            firstZ = origin[2] + 1;
            lastZ = src.getNSlices() + origin[2];
        }
        ImageStack srcStack = src.getStack();
        ImageStack dstStack = dst.getStack();
        for (int t = 1; t <= src.getNFrames(); ++t) {
            for (int c = 1; c <= src.getNChannels(); ++c) {
                int z0 = 1;
                int z = firstZ;
                while (z <= lastZ) {
                    int n0 = src.getStackIndex(c, z0, t);
                    int n = dst.getStackIndex(c, z, t);
                    ImageProcessor srcIp = srcStack.getProcessor(n0);
                    ImageProcessor dstIp = dstStack.getProcessor(n);
                    dstIp.copyBits(srcIp, origin[0], origin[1], 0);
                    dstStack.setProcessor(dstIp, n);
                    ++z;
                    ++z0;
                }
            }
        }
        return true;
    }

    public static ResultsTable confusionMatrix(ImageProcessor prediction, ImageProcessor groundtruth, ArrayList<String> classes, int[] classIndexToLabel) {
        if (prediction.getWidth() != groundtruth.getWidth() || prediction.getHeight() != groundtruth.getHeight()) {
            IJ.log((String)"Error: size of predicted label image and groundtruth image does not match.");
            return null;
        }
        if (classes.size() != classIndexToLabel.length) {
            IJ.log((String)"Error: the number of class names and class/label correspondences do not match.");
            return null;
        }
        HashMap<Integer, Integer> labelToClassIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < classIndexToLabel.length; ++i) {
            labelToClassIndex.put(classIndexToLabel[i], i);
        }
        int[][] cm = new int[classes.size()][classes.size()];
        for (int i = 0; i < prediction.getWidth(); ++i) {
            for (int j = 0; j < prediction.getHeight(); ++j) {
                int predLabel = (int)prediction.getf(i, j);
                int gtLabel = (int)groundtruth.getf(i, j);
                if (null == labelToClassIndex.get(predLabel) || null == labelToClassIndex.get(gtLabel)) continue;
                int[] nArray = cm[(Integer)labelToClassIndex.get(gtLabel)];
                int n = (Integer)labelToClassIndex.get(predLabel);
                nArray[n] = nArray[n] + 1;
            }
        }
        ResultsTable cmTable = new ResultsTable();
        double[] totalPositive = new double[classes.size()];
        for (int j = 0; j < classes.size(); ++j) {
            cmTable.incrementCounter();
            cmTable.addLabel("Predicted " + classes.get(j));
            double predPositive = 0.0;
            for (int i = 0; i < classes.size(); ++i) {
                cmTable.addValue("Groundtruth " + classes.get(i), (double)cm[i][j]);
                predPositive += (double)cm[i][j];
                int n = i;
                totalPositive[n] = totalPositive[n] + (double)cm[i][j];
            }
            cmTable.addValue("Precision ", (double)cm[j][j] / predPositive);
        }
        cmTable.incrementCounter();
        cmTable.addLabel("Recall");
        double allPositive = 0.0;
        double all = 0.0;
        for (int j = 0; j < classes.size(); ++j) {
            allPositive += (double)cm[j][j];
            all += totalPositive[j];
            cmTable.addValue("Groundtruth " + classes.get(j), (double)cm[j][j] / totalPositive[j]);
        }
        cmTable.addValue("Precision ", allPositive / all);
        return cmTable;
    }

    public static ResultsTable confusionMatrix(ImageStack prediction, ImageStack groundtruth, ArrayList<String> classes, int[] classIndexToLabel) {
        if (prediction.getWidth() != groundtruth.getWidth() || prediction.getHeight() != groundtruth.getHeight() || prediction.getSize() != groundtruth.getSize()) {
            IJ.log((String)"Error: size of predicted label image and groundtruth image does not match.");
            return null;
        }
        if (classes.size() != classIndexToLabel.length) {
            IJ.log((String)"Error: the number of class names and class/label correspondences do not match.");
            return null;
        }
        HashMap<Integer, Integer> labelToClassIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < classIndexToLabel.length; ++i) {
            labelToClassIndex.put(classIndexToLabel[i], i);
        }
        int[][] cm = new int[classes.size()][classes.size()];
        for (int k = 0; k < prediction.getSize(); ++k) {
            ImageProcessor p = prediction.getProcessor(k + 1);
            ImageProcessor gt = groundtruth.getProcessor(k + 1);
            for (int i = 0; i < prediction.getWidth(); ++i) {
                for (int j = 0; j < prediction.getHeight(); ++j) {
                    int predLabel = (int)p.getf(i, j);
                    int gtLabel = (int)gt.getf(i, j);
                    if (null == labelToClassIndex.get(predLabel) || null == labelToClassIndex.get(gtLabel)) continue;
                    int[] nArray = cm[(Integer)labelToClassIndex.get(gtLabel)];
                    int n = (Integer)labelToClassIndex.get(predLabel);
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        ResultsTable cmTable = new ResultsTable();
        double[] totalPositive = new double[classes.size()];
        for (int j = 0; j < classes.size(); ++j) {
            cmTable.incrementCounter();
            cmTable.addLabel("Predicted " + classes.get(j));
            double predPositive = 0.0;
            for (int i = 0; i < classes.size(); ++i) {
                cmTable.addValue("Groundtruth " + classes.get(i), (double)cm[i][j]);
                predPositive += (double)cm[i][j];
                int n = i;
                totalPositive[n] = totalPositive[n] + (double)cm[i][j];
            }
            cmTable.addValue("Precision ", (double)cm[j][j] / predPositive);
        }
        cmTable.incrementCounter();
        cmTable.addLabel("Recall");
        double allPositive = 0.0;
        double all = 0.0;
        for (int j = 0; j < classes.size(); ++j) {
            allPositive += (double)cm[j][j];
            all += totalPositive[j];
            cmTable.addValue("Groundtruth " + classes.get(j), (double)cm[j][j] / totalPositive[j]);
        }
        cmTable.addValue("Precision ", allPositive / all);
        return cmTable;
    }

    public static ResultsTable confusionMatrix(ImagePlus prediction, ImagePlus groundtruth, ArrayList<String> classes, int[] classIndexToLabel) {
        return Utils.confusionMatrix(prediction.getStack(), groundtruth.getStack(), classes, classIndexToLabel);
    }
}

