/*
 * Decompiled with CFR 0.152.
 */
package io.scif.media.imageio.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileChannelImageInputStream
extends ImageInputStreamImpl {
    private FileChannel channel;
    private MappedByteBuffer mappedBuffer;
    private long mappedPos;
    private long mappedUpperBound;

    public FileChannelImageInputStream(FileChannel channel) throws IOException {
        long channelPosition;
        if (channel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!channel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = channel;
        this.streamPos = this.flushedPos = (channelPosition = channel.position());
        long fullSize = channel.size() - channelPosition;
        long mappedSize = Math.min(fullSize, Integer.MAX_VALUE);
        this.mappedPos = 0L;
        this.mappedUpperBound = this.mappedPos + mappedSize;
        this.mappedBuffer = channel.map(FileChannel.MapMode.READ_ONLY, channelPosition, mappedSize);
    }

    private MappedByteBuffer getMappedBuffer(int len) throws IOException {
        if (this.streamPos < this.mappedPos || this.streamPos + (long)len >= this.mappedUpperBound) {
            this.mappedPos = this.streamPos;
            long mappedSize = Math.min(this.channel.size() - this.mappedPos, Integer.MAX_VALUE);
            this.mappedUpperBound = this.mappedPos + mappedSize;
            this.mappedBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.mappedPos, mappedSize);
            this.mappedBuffer.order(super.getByteOrder());
        }
        return this.mappedBuffer;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(1);
        if (byteBuffer.remaining() < 1) {
            return -1;
        }
        int value = byteBuffer.get() & 0xFF;
        ++this.streamPos;
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (len == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(len);
        int numBytesRemaining = byteBuffer.remaining();
        if (numBytesRemaining < 1) {
            return -1;
        }
        if (len > numBytesRemaining) {
            len = numBytesRemaining;
        }
        byteBuffer.get(b, off, len);
        this.streamPos += (long)len;
        return len;
    }

    public void close() throws IOException {
        super.close();
        this.channel = null;
    }

    public void readFully(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 2 * len;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(byteLen);
        if (byteBuffer.remaining() < byteLen) {
            throw new EOFException();
        }
        CharBuffer viewBuffer = byteBuffer.asCharBuffer();
        viewBuffer.get(c, off, len);
        this.seek(this.streamPos + (long)byteLen);
    }

    public void readFully(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 2 * len;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(byteLen);
        if (byteBuffer.remaining() < byteLen) {
            throw new EOFException();
        }
        ShortBuffer viewBuffer = byteBuffer.asShortBuffer();
        viewBuffer.get(s, off, len);
        this.seek(this.streamPos + (long)byteLen);
    }

    public void readFully(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 4 * len;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(byteLen);
        if (byteBuffer.remaining() < byteLen) {
            throw new EOFException();
        }
        IntBuffer viewBuffer = byteBuffer.asIntBuffer();
        viewBuffer.get(i, off, len);
        this.seek(this.streamPos + (long)byteLen);
    }

    public void readFully(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 8 * len;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(byteLen);
        if (byteBuffer.remaining() < byteLen) {
            throw new EOFException();
        }
        LongBuffer viewBuffer = byteBuffer.asLongBuffer();
        viewBuffer.get(l, off, len);
        this.seek(this.streamPos + (long)byteLen);
    }

    public void readFully(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 4 * len;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(byteLen);
        if (byteBuffer.remaining() < byteLen) {
            throw new EOFException();
        }
        FloatBuffer viewBuffer = byteBuffer.asFloatBuffer();
        viewBuffer.get(f, off, len);
        this.seek(this.streamPos + (long)byteLen);
    }

    public void readFully(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 8 * len;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(byteLen);
        if (byteBuffer.remaining() < byteLen) {
            throw new EOFException();
        }
        DoubleBuffer viewBuffer = byteBuffer.asDoubleBuffer();
        viewBuffer.get(d, off, len);
        this.seek(this.streamPos + (long)byteLen);
    }

    public long length() {
        long length = -1L;
        try {
            length = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return length;
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        if (pos >= this.mappedPos && pos < this.mappedUpperBound) {
            this.mappedBuffer.position((int)(pos - this.mappedPos));
        } else {
            int len = (int)Math.min(this.channel.size() - pos, Integer.MAX_VALUE);
            this.mappedBuffer = this.getMappedBuffer(len);
        }
    }

    public void setByteOrder(ByteOrder networkByteOrder) {
        super.setByteOrder(networkByteOrder);
        this.mappedBuffer.order(networkByteOrder);
    }
}

