/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.curve;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import sc.fiji.kappa.curve.BSpline;
import sc.fiji.kappa.curve.BezierCurve;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.KappaFrame;

public class BezierGroup
extends ArrayList<Curve> {
    private static final long serialVersionUID = 1L;
    private int noSelected;
    private int count;
    protected KappaFrame frame;

    public BezierGroup(KappaFrame frame) {
        this.frame = frame;
        this.noSelected = 0;
        this.count = 0;
    }

    @Override
    public boolean add(Curve curve) {
        this.setAllUnselected();
        this.noSelected = 1;
        return super.add(curve);
    }

    public void addCurve(List<Point2D> defPoints, int t, int noCtrlPts, int curveType, boolean isOpen, int dataRadius) {
        if (curveType == 0) {
            this.add(new BezierCurve(defPoints, t, noCtrlPts, "CURVE " + ++this.count, dataRadius, this.frame));
        } else if (isOpen) {
            this.add(new BSpline(defPoints, t, noCtrlPts, "CURVE " + ++this.count, true, dataRadius, this.frame));
        } else {
            this.add(new BSpline(defPoints, t, noCtrlPts, "CURVE " + ++this.count, false, dataRadius, this.frame));
        }
    }

    @Override
    public Curve remove(int i) {
        --this.noSelected;
        return (Curve)super.remove(i);
    }

    public void draw(Graphics2D g, double scale, int currentPoint, boolean showBoundingBox, boolean scaleCurveStrokes, boolean showTangent, boolean showThresholdedRegion) {
        for (Curve curve : this) {
            curve.draw(scale, g, currentPoint, showBoundingBox, scaleCurveStrokes, showTangent, showThresholdedRegion);
        }
    }

    public Curve[] getSelected() {
        Curve[] selectedCurves = new Curve[this.noSelected];
        int n = this.noSelected;
        int j = 0;
        for (int i = this.size() - 1; i >= 0 && n > 0; --i) {
            if (!((Curve)this.get(i)).isSelected()) continue;
            selectedCurves[j++] = (Curve)this.get(i);
            --n;
        }
        return selectedCurves;
    }

    public void setSelected(int[] selectedIndices) {
        this.setAllUnselected();
        for (int i : selectedIndices) {
            ((Curve)this.get(i)).setSelected(true);
        }
        this.noSelected = selectedIndices.length;
    }

    public double getAvgAverageCurvature(boolean selectedOnly) {
        double total = 0.0;
        for (Curve curve : this) {
            if ((!selectedOnly || !curve.isSelected()) && selectedOnly) continue;
            total += curve.getAverageCurvature();
        }
        if (!selectedOnly) {
            return total / (double)this.size();
        }
        return total / (double)this.noSelected;
    }

    public double getAvgApproxCurveLength(boolean selectedOnly) {
        double length = 0.0;
        for (Curve curve : this) {
            if ((!selectedOnly || !curve.isSelected()) && selectedOnly) continue;
            length += curve.getApproxCurveLength();
        }
        if (!selectedOnly) {
            return length / (double)this.size();
        }
        return length / (double)this.noSelected;
    }

    public double getAvgPointCurvature(int currentPoint, boolean selectedOnly) {
        double total = 0.0;
        for (Curve curve : this) {
            if ((!selectedOnly || !curve.isSelected()) && selectedOnly) continue;
            total += curve.getPointCurvature(currentPoint);
        }
        if (!selectedOnly) {
            return total / (double)this.size();
        }
        return total / (double)this.noSelected;
    }

    public double getStdDevOfAvgCurvature(boolean selectedOnly) {
        double variance = 0.0;
        double mu = this.getAvgAverageCurvature(selectedOnly);
        for (Curve curve : this) {
            variance += (curve.getAverageCurvature() - mu) * (curve.getAverageCurvature() - mu);
        }
        variance = selectedOnly ? (variance /= (double)(this.size() - 1)) : (variance /= (double)(this.noSelected - 1));
        return Math.sqrt(variance);
    }

    public void setSelected(Curve curve) {
        curve.setSelected(true);
        ++this.noSelected;
    }

    public void setUnselected(Curve curve) {
        curve.setSelected(false);
        --this.noSelected;
    }

    public void setAllUnselected() {
        for (Curve curve : this) {
            curve.setSelected(false);
        }
        this.noSelected = 0;
    }

    public void setAllSelected() {
        for (Curve curve : this) {
            curve.setSelected(true);
        }
        this.noSelected = this.size();
    }

    public void updateIntensities() {
        for (Curve curve : this) {
            curve.updateIntensities();
        }
    }

    public void changeFrame(int newFrame) {
        for (Curve curve : this) {
            curve.translateCurve(newFrame);
        }
    }

    public void recalculateCurvature(int t) {
        for (Curve curve : this) {
            curve.recalculateCurvature(t);
        }
    }

    public int getNoSelected() {
        return this.noSelected;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isCurveSelected() {
        return this.noSelected != 0;
    }

    public void rescaleCurves(double scaleFactor) {
        BezierGroup newCurves = new BezierGroup(this.frame);
        for (Curve curve : this) {
            List<Point2D> points = curve.getCtrlPts().stream().map(c -> new Point2D.Double(c.getX() * scaleFactor, c.getY() * scaleFactor)).collect(Collectors.toList());
            if (curve instanceof BezierCurve) {
                newCurves.add(new BezierCurve(points, curve.getT(), curve.getNoCtrlPts(), curve.getName(), (int)((double)curve.getDataRadius() * scaleFactor), this.frame));
                continue;
            }
            if (!(curve instanceof BSpline)) continue;
            if (((BSpline)curve).isOpen()) {
                newCurves.add(new BSpline(points, curve.getT(), curve.getNoCtrlPts(), curve.getName(), true, curve.getDataRadius(), this.frame));
                continue;
            }
            newCurves.add(new BSpline(points, curve.getT(), curve.getNoCtrlPts(), curve.getName(), false, (int)((double)curve.getDataRadius() * scaleFactor), this.frame));
        }
        this.clear();
        this.addAll(newCurves);
    }
}

