/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.MipmapInfo;
import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.HDF5Access;
import bdv.img.hdf5.Partition;
import bdv.img.hdf5.Util;
import bdv.img.hdf5.ViewLevelId;
import bdv.img.n5.DataTypeProperties;
import bdv.util.ConstantRandomAccessible;
import bdv.util.MipmapTransforms;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import hdf.hdf5lib.HDF5Constants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.util.Cast;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;

public class Hdf5ImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader {
    private final File hdf5File;
    private final IHDF5Reader existingHdf5Reader;
    private final ArrayList<Partition> partitions;
    private final AbstractSequenceDescription<?, ?, ?> seq;
    private final Map<Integer, SetupImgLoader> setupImgLoaders = new HashMap<Integer, SetupImgLoader>();
    private volatile boolean isOpen = false;
    private SharedQueue createdSharedQueue;
    private VolatileGlobalCellCache cache;
    private IHDF5Reader hdf5Reader;
    private HDF5Access hdf5Access;
    private int requestedNumFetcherThreads = -1;
    private SharedQueue requestedSharedQueue;

    public Hdf5ImageLoader(File hdf5File, ArrayList<Partition> hdf5Partitions, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this(hdf5File, hdf5Partitions, sequenceDescription, false);
    }

    public Hdf5ImageLoader(File hdf5File, ArrayList<Partition> hdf5Partitions, AbstractSequenceDescription<?, ?, ?> sequenceDescription, boolean doOpen) {
        this(hdf5File, null, hdf5Partitions, sequenceDescription, doOpen);
    }

    protected Hdf5ImageLoader(File hdf5File, IHDF5Reader existingHdf5Reader, ArrayList<Partition> hdf5Partitions, AbstractSequenceDescription<?, ?, ?> sequenceDescription, boolean doOpen) {
        this.existingHdf5Reader = existingHdf5Reader;
        this.hdf5File = hdf5File;
        this.seq = sequenceDescription;
        this.partitions = new ArrayList();
        if (hdf5Partitions != null) {
            this.partitions.addAll(hdf5Partitions);
        }
        if (doOpen) {
            this.open();
        }
    }

    @Override
    public synchronized void setNumFetcherThreads(int n) {
        this.requestedNumFetcherThreads = n;
    }

    @Override
    public void setCreatedSharedQueue(SharedQueue createdSharedQueue) {
        this.requestedSharedQueue = createdSharedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        if (!this.isOpen) {
            Hdf5ImageLoader hdf5ImageLoader = this;
            synchronized (hdf5ImageLoader) {
                if (this.isOpen) {
                    return;
                }
                try {
                    this.hdf5Reader = this.existingHdf5Reader != null ? this.existingHdf5Reader : HDF5Factory.openForReading((File)this.hdf5File);
                    this.hdf5Access = new HDF5Access(this.hdf5Reader);
                    int maxNumLevels = 0;
                    List setups = this.seq.getViewSetupsOrdered();
                    for (BasicViewSetup setup : setups) {
                        int setupId = setup.getId();
                        SetupImgLoader setupImgLoader = this.createSetupImgLoader(setupId);
                        this.setupImgLoaders.put(setupId, setupImgLoader);
                        maxNumLevels = Math.max(maxNumLevels, setupImgLoader.numMipmapLevels());
                    }
                    int numFetcherThreads = this.requestedNumFetcherThreads >= 0 ? this.requestedNumFetcherThreads : 1;
                    SharedQueue queue = this.requestedSharedQueue != null ? this.requestedSharedQueue : (this.createdSharedQueue = new SharedQueue(numFetcherThreads, maxNumLevels));
                    this.cache = new VolatileGlobalCellCache(queue);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.isOpen = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isOpen) {
            Hdf5ImageLoader hdf5ImageLoader = this;
            synchronized (hdf5ImageLoader) {
                if (!this.isOpen) {
                    return;
                }
                if (this.createdSharedQueue != null) {
                    this.createdSharedQueue.shutdown();
                }
                this.cache.clearCache();
                this.hdf5Access.closeAllDataSets();
                if (this.existingHdf5Reader == null) {
                    this.hdf5Access.close();
                }
                this.createdSharedQueue = null;
                this.isOpen = false;
            }
        }
    }

    public File getHdf5File() {
        return this.hdf5File;
    }

    public ArrayList<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public CacheControl getCacheControl() {
        this.open();
        return this.cache;
    }

    public boolean existsImageData(ViewLevelId id) {
        return this.getDimsAndExistence(id).exists();
    }

    public DimsAndExistence getDimsAndExistence(ViewLevelId id) {
        this.open();
        return this.hdf5Access.getDimsAndExistence(Util.getCellsPath(id));
    }

    public void printMipmapInfo() {
        this.open();
        for (BasicViewSetup setup : this.seq.getViewSetupsOrdered()) {
            Object[] res;
            int level;
            int setupId = setup.getId();
            System.out.println("setup " + setupId);
            MipmapInfo mipmapInfo = ((SetupImgLoader)this.getSetupImgLoader(setupId)).getMipmapInfo();
            double[][] reslevels = mipmapInfo.getResolutions();
            int[][] subdiv = mipmapInfo.getSubdivisions();
            int numLevels = mipmapInfo.getNumLevels();
            System.out.println("    resolutions:");
            for (level = 0; level < numLevels; ++level) {
                res = reslevels[level];
                System.out.println("    " + level + ": " + net.imglib2.util.Util.printCoordinates(res));
            }
            System.out.println("    subdivisions:");
            for (level = 0; level < numLevels; ++level) {
                res = subdiv[level];
                System.out.println("    " + level + ": " + net.imglib2.util.Util.printCoordinates((int[])res));
            }
            System.out.println("    level sizes:");
            int timepointId = ((TimePoint)this.seq.getTimePoints().getTimePointsOrdered().get(0)).getId();
            for (int level2 = 0; level2 < numLevels; ++level2) {
                DimsAndExistence dims = this.getDimsAndExistence(new ViewLevelId(timepointId, setupId, level2));
                long[] dimensions = dims.getDimensions();
                System.out.println("    " + level2 + ": " + net.imglib2.util.Util.printCoordinates(dimensions));
            }
        }
    }

    @Override
    public SetupImgLoader<?, ?> getSetupImgLoader(int setupId) {
        this.open();
        return this.setupImgLoaders.get(setupId);
    }

    private <T extends NativeType<T>, V extends Volatile<T>> SetupImgLoader<T, V> createSetupImgLoader(int setupId) throws IOException {
        boolean legacyInt16;
        DataType dataType = this.tryGetDataType(setupId);
        boolean bl = legacyInt16 = dataType == null;
        if (legacyInt16) {
            dataType = DataType.UINT16;
        }
        return new SetupImgLoader(this.hdf5Reader, this.hdf5Access, setupId, (DataTypeProperties)Cast.unchecked(DataTypeProperties.of(dataType)), legacyInt16);
    }

    private DataType tryGetDataType(int setupId) {
        try {
            return DataType.fromString((String)this.hdf5Reader.string().getAttr(Util.getSetupPath(setupId), "dataType"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class Hdf5CacheArrayLoader<T, A extends DataAccess>
    implements CacheArrayLoader<A> {
        private final HDF5Access hdf5Access;
        private final String pathName;
        private final DataType dataType;
        private final long memTypeId;
        private final Function<T, A> createVolatileArrayAccess;

        Hdf5CacheArrayLoader(HDF5Access hdf5Access, String pathName, DataTypeProperties<?, ?, T, A> typeProps, boolean legacyInt16) {
            this.hdf5Access = hdf5Access;
            this.pathName = pathName;
            this.dataType = typeProps.dataType();
            this.memTypeId = legacyInt16 ? HDF5Constants.H5T_NATIVE_INT16 : Util.memTypeId(this.dataType);
            this.createVolatileArrayAccess = typeProps.createVolatileArrayAccess();
        }

        @Override
        public A loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            DataBlock dataBlock = (DataBlock)Cast.unchecked(this.hdf5Access.readBlock(this.pathName, this.dataType, this.memTypeId, dimensions, min));
            return (A)((DataAccess)this.createVolatileArrayAccess.apply(dataBlock.getData()));
        }
    }

    public class SetupImgLoader<T extends NativeType<T>, V extends Volatile<T>>
    extends AbstractViewerSetupImgLoader<T, V>
    implements MultiResolutionSetupImgLoader<T> {
        private final HDF5Access hdf5Access;
        private final DataTypeProperties<?, ?, ?, ?> typeProps;
        private final int setupId;
        private final MipmapInfo mipmapInfo;
        private final boolean legacyInt16;

        public SetupImgLoader(IHDF5Reader hdf5Reader, HDF5Access hdf5Access, int setupId, DataTypeProperties<T, V, ?, ?> typeProps, boolean legacyInt16) {
            super(typeProps.type(), typeProps.volatileType());
            this.hdf5Access = hdf5Access;
            this.typeProps = typeProps;
            this.setupId = setupId;
            double[][] mipmapResolutions = hdf5Reader.readDoubleMatrix(Util.getResolutionsPath(setupId));
            AffineTransform3D[] mipmapTransforms = new AffineTransform3D[mipmapResolutions.length];
            for (int level = 0; level < mipmapResolutions.length; ++level) {
                mipmapTransforms[level] = MipmapTransforms.getMipmapTransformDefault(mipmapResolutions[level]);
            }
            int[][] subdivisions = hdf5Reader.readIntMatrix(Util.getSubdivisionsPath(setupId));
            this.mipmapInfo = new MipmapInfo(mipmapResolutions, mipmapTransforms, subdivisions);
            this.legacyInt16 = legacyInt16;
        }

        @Override
        public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BUDGETED, (NativeType)((Object)this.volatileType));
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
        }

        public MipmapInfo getMipmapInfo() {
            return this.mipmapInfo;
        }

        public double[][] getMipmapResolutions() {
            return this.mipmapInfo.getResolutions();
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return this.mipmapInfo.getTransforms();
        }

        public int numMipmapLevels() {
            return this.mipmapInfo.getNumLevels();
        }

        public Dimensions getImageSize(int timepointId, int level) {
            String pathName = Util.getCellsPath(timepointId, this.setupId, level);
            DimsAndExistence dims = this.hdf5Access.getDimsAndExistence(pathName);
            if (dims.exists()) {
                return new FinalDimensions(dims.getDimensions());
            }
            return null;
        }

        public VoxelDimensions getVoxelSize(int timepointId) {
            return null;
        }

        private <T extends NativeType<T>> RandomAccessibleInterval<T> prepareCachedImage(int timepointId, int level, LoadingStrategy loadingStrategy, T type) {
            String pathName = Util.getCellsPath(timepointId, this.setupId, level);
            DimsAndExistence dims = this.hdf5Access.getDimsAndExistence(pathName);
            if (!dims.exists()) {
                System.err.println(String.format("image data for timepoint %d setup %d level %d could not be found. Partition file missing?", timepointId, this.setupId, level));
                return Views.interval(new ConstantRandomAccessible(type.createVariable(), 3), new FinalInterval(1L, 1L, 1L));
            }
            long[] dimensions = dims.getDimensions();
            int[] cellDimensions = dims.getBlockSize() != null ? dims.getBlockSize() : this.mipmapInfo.getSubdivisions()[level];
            CellGrid grid = new CellGrid(dimensions, cellDimensions);
            int priority = this.mipmapInfo.getMaxLevel() - level;
            CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
            Hdf5CacheArrayLoader loader = new Hdf5CacheArrayLoader(this.hdf5Access, pathName, this.typeProps, this.legacyInt16);
            return Hdf5ImageLoader.this.cache.createImg(grid, timepointId, this.setupId, level, cacheHints, loader, type);
        }
    }
}

