/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.PartialComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListPartialComponent;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.LongType;

final class PixelListPartialComponentGenerator<T extends Type<T>>
implements PartialComponent.Generator<T, PixelListPartialComponent<T>> {
    private final T maxValue;
    final long[] dimensions;
    final Img<LongType> linkedList;

    PixelListPartialComponentGenerator(T maxValue, RandomAccessibleInterval<T> input, ImgFactory<LongType> imgFactory) {
        this.maxValue = maxValue;
        this.dimensions = new long[input.numDimensions()];
        input.dimensions(this.dimensions);
        this.linkedList = imgFactory.create(this.dimensions);
    }

    @Override
    public PixelListPartialComponent<T> createComponent(T value) {
        return new PixelListPartialComponent<T>(value, this);
    }

    @Override
    public PixelListPartialComponent<T> createMaxComponent() {
        return new PixelListPartialComponent<T>(this.maxValue, this);
    }
}

