/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.gauss3.ConvolverFactory;
import net.imglib2.type.numeric.RealType;

@Deprecated
public final class FloatConvolverRealTypeBuffered<S extends RealType<S>, T extends RealType<T>>
implements Runnable {
    private final float[] kernel;
    private final RandomAccess<S> in;
    private final RandomAccess<T> out;
    private final int d;
    private final int k;
    private final int k1;
    private final int k1k1;
    private final int buflen;
    private final float[] buf;

    public static <S extends RealType<S>, T extends RealType<T>> ConvolverFactory<S, T> factory() {
        return new ConvolverFactory<S, T>(){

            @Override
            public Runnable create(double[] halfkernel, RandomAccess<S> in, RandomAccess<T> out, int d, long lineLength) {
                return new FloatConvolverRealTypeBuffered(halfkernel, in, out, d, lineLength);
            }
        };
    }

    private FloatConvolverRealTypeBuffered(double[] kernel, RandomAccess<S> in, RandomAccess<T> out, int d, long lineLength) {
        this.kernel = new float[kernel.length];
        for (int i = 0; i < kernel.length; ++i) {
            this.kernel[i] = (float)kernel[i];
        }
        this.in = in;
        this.out = out;
        this.d = d;
        this.k = this.kernel.length;
        this.k1 = this.k - 1;
        this.k1k1 = this.k1 + this.k1;
        this.buflen = (int)lineLength + 2 * this.k1k1;
        this.buf = new float[this.buflen];
    }

    @Override
    public void run() {
        int max = this.buflen - this.k1;
        for (int i = this.k1; i < max; ++i) {
            float w = ((RealType)this.in.get()).getRealFloat();
            int n = i;
            this.buf[n] = this.buf[n] + w * this.kernel[0];
            for (int j = 1; j < this.k1; ++j) {
                float wk = w * this.kernel[j];
                int n2 = i + j;
                this.buf[n2] = this.buf[n2] + wk;
                int n3 = i - j;
                this.buf[n3] = this.buf[n3] + wk;
            }
            float wk = w * this.kernel[this.k1];
            int n4 = i - this.k1;
            this.buf[n4] = this.buf[n4] + wk;
            this.buf[i + this.k1] = wk;
            this.in.fwd(this.d);
        }
        this.writeLine();
    }

    private void writeLine() {
        int max = this.buflen - this.k1k1;
        for (int i = this.k1k1; i < max; ++i) {
            ((RealType)this.out.get()).setReal(this.buf[i]);
            this.out.fwd(this.d);
        }
    }
}

