/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.HashMap;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.Sampler;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.Util;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;

public class FunctionRandomAccess<C extends RealType<C>, O extends RealType<O>>
extends Point
implements RandomAccess<O> {
    private final IFunction operation;
    private final C computeType;
    private final O outputType;
    private final Converter<RealType<?>, C> inConverter;
    private final Converter<C, O> outConverter;
    private final Sampler<O> sampler;

    public FunctionRandomAccess(IFunction operation, Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
        super(Util.findFirstInterval(operation).numDimensions());
        boolean are_same_type;
        if (null == inConverter) {
            inConverter = Util.genericRealTypeConverter();
        }
        boolean bl = are_same_type = computeType.getClass() == outputType.getClass();
        if (null == outConverter && !are_same_type) {
            outConverter = computeType instanceof IntegerType && outputType instanceof IntegerType ? Util.genericIntegerTypeConverter() : Util.genericRealTypeConverter();
        }
        this.sampler = are_same_type ? new FunctionSamplerDirect(this, (Point)this, operation, inConverter, outputType) : new FunctionSampler(this, (Point)this, operation, inConverter, computeType, outputType, outConverter);
        this.operation = operation;
        this.inConverter = inConverter;
        this.outConverter = outConverter;
        this.computeType = computeType;
        this.outputType = outputType;
    }

    @Override
    public O get() {
        return (O)((RealType)this.sampler.get());
    }

    @Override
    public O getType() {
        return this.outputType;
    }

    @Override
    public RandomAccess<O> copy() {
        return new FunctionRandomAccess<C, O>(this.operation, this.inConverter, this.computeType, this.outputType, this.outConverter);
    }

    private static final class FunctionSamplerDirect
    implements Sampler<O> {
        private final Point point;
        private final IFunction operation;
        private final O outputType;
        private final Converter<RealType<?>, O> inConverter;
        private final OFunction<O> f;
        final /* synthetic */ FunctionRandomAccess this$0;

        FunctionSamplerDirect(Point point, IFunction operation, Converter<RealType<?>, O> inConverter, O outputType) {
            this.this$0 = var1_1;
            this.point = point;
            this.operation = operation;
            this.outputType = (RealType)outputType.createVariable();
            this.inConverter = inConverter;
            this.f = operation.reInit((RealType)outputType.createVariable(), new HashMap(), inConverter, null);
        }

        @Override
        public final Sampler<O> copy() {
            return new FunctionSamplerDirect(this.this$0, this.point, this.operation, this.inConverter, this.outputType);
        }

        @Override
        public final O get() {
            return this.f.eval(this.point);
        }

        @Override
        public O getType() {
            return this.outputType;
        }
    }

    private static final class FunctionSampler
    implements Sampler<O> {
        private final Point point;
        private final IFunction operation;
        private final C computeType;
        private final O outputType;
        private final Converter<RealType<?>, C> inConverter;
        private final Converter<C, O> outConverter;
        private final OFunction<C> f;
        final /* synthetic */ FunctionRandomAccess this$0;

        FunctionSampler(Point point, IFunction operation, Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
            this.this$0 = var1_1;
            this.point = point;
            this.operation = operation;
            this.computeType = computeType;
            this.outputType = (RealType)outputType.createVariable();
            this.inConverter = inConverter;
            this.outConverter = outConverter;
            this.f = operation.reInit((RealType)computeType.createVariable(), new HashMap(), inConverter, null);
        }

        @Override
        public final Sampler<O> copy() {
            return new FunctionSampler(this.this$0, this.point, this.operation, this.inConverter, this.computeType, this.outputType, this.outConverter);
        }

        @Override
        public O get() {
            this.outConverter.convert(this.f.eval(this.point), this.outputType);
            return this.outputType;
        }

        @Override
        public O getType() {
            return this.outputType;
        }
    }
}

