/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class BIJutil {
    public static ImageStack imageStackFromMatrix(float[][] a, int width) {
        ImageStack is = new ImageStack(width, a[0].length / width);
        for (int j = 0; j < a.length; ++j) {
            is.addSlice("" + j, (ImageProcessor)new FloatProcessor(width, a[j].length / width, a[j], null));
        }
        return is;
    }

    public static ImageStack imageStackFromMatrix(short[][] a, int width) {
        ImageStack is = new ImageStack(width, a[0].length / width);
        for (int j = 0; j < a.length; ++j) {
            is.addSlice("" + j, (ImageProcessor)new ShortProcessor(width, a[0].length / width, a[j], null));
        }
        return is;
    }

    public static int getMatrixWidth(ImagePlus imp) {
        int width = imp.getWidth();
        if (imp.getRoi() != null) {
            Rectangle roiRect = imp.getRoi().getBoundingRect();
            width = roiRect.width;
        }
        return width;
    }

    public static int getMatrixWidth(ImagePlus imp, double scaleFactor) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageProcessor ipp = imp.getStack().getProcessor(1);
        ipp.setInterpolate(true);
        if (scaleFactor != 1.0 && scaleFactor != 0.0) {
            ipp = ipp.resize((int)((double)width * scaleFactor), (int)((double)height * scaleFactor));
        }
        return ipp.getWidth();
    }

    public static float[][] matrixFromImageStack(ImagePlus imp) {
        return BIJutil.matrixFromImageStack(imp.getStack());
    }

    public static float[][] matrixFromImageStack(ImageStack is) {
        float[][] a = new float[is.getSize()][];
        try {
            int width = is.getWidth();
            int height = is.getHeight();
            boolean x = false;
            boolean y = false;
            for (int i = 0; i < a.length; ++i) {
                ImageProcessor ipp = is.getProcessor(i + 1);
                a[i] = BIJutil.getFloatPixels(ipp.getPixels());
            }
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    public static ImagePlus showVectorAsImage(float[] v, int width) {
        ImagePlus imp = new ImagePlus("v", (ImageProcessor)new FloatProcessor(width, v.length / width, v, null));
        imp.show();
        return imp;
    }

    public static float[] vectorFromImageStack(ImagePlus imp, int i) {
        ImageProcessor ipp = imp.getStack().getProcessor(i + 1);
        return BIJutil.getFloatPixels(ipp.getPixels());
    }

    public static float[] vectorFromImageStack(ImagePlus imp, int i, float scaleFactor) {
        float[] a = null;
        try {
            int width = imp.getWidth();
            int height = imp.getHeight();
            ImageProcessor ipp = imp.getStack().getProcessor(i + 1);
            ipp.setInterpolate(true);
            if (scaleFactor != 1.0f) {
                ipp = ipp.resize((int)((float)width * scaleFactor), (int)((float)height * scaleFactor));
            }
            a = BIJutil.getFloatPixels(ipp.getPixels());
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    public static float[] vectorFromImageStackRoi(ImagePlus imp) {
        return BIJutil.vectorFromImageStackRoi(imp, 0);
    }

    public static float[] vectorFromImageStackRoi(ImagePlus imp, int i) {
        ImageProcessor ipp = imp.getStackSize() > 1 ? imp.getStack().getProcessor(i + 1) : imp.getProcessor();
        float[] a = null;
        try {
            int width = imp.getWidth();
            int height = imp.getHeight();
            int x = 0;
            int y = 0;
            if (imp.getRoi() != null) {
                Rectangle roiRect = imp.getRoi().getBoundingRect();
                width = roiRect.width;
                height = roiRect.height;
                x = roiRect.x;
                y = roiRect.y;
                ipp.setRoi(x, y, width, height);
                ipp = ipp.crop();
            }
            a = BIJutil.getFloatPixels(ipp.getPixels());
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    public static float[] crop(float[] image, int width, int height, int x, int y, int newwidth, int newheight) {
        FloatProcessor ipp = new FloatProcessor(width, height, image, null);
        float[] a = null;
        try {
            ipp.setRoi(x, y, newwidth, newheight);
            ipp = ipp.crop();
            a = (float[])ipp.getPixels();
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    protected static float[] getFloatPixels(Object array) {
        float[] pixels32 = null;
        if (array instanceof float[]) {
            pixels32 = (float[])array;
        } else if (array instanceof short[]) {
            short[] pixels16 = (short[])array;
            pixels32 = new float[pixels16.length];
            for (int i = 0; i < pixels16.length; ++i) {
                pixels32[i] = (pixels16[i] & 0xFFFF) - 32768;
            }
        } else if (array instanceof byte[]) {
            byte[] pixels8 = (byte[])array;
            pixels32 = new float[pixels8.length];
            for (int i = 0; i < pixels8.length; ++i) {
                pixels32[i] = pixels8[i] & 0xFF;
            }
        } else {
            System.out.println("PLEASE IMPLEMENT pixel conversions!");
            throw new Error("PLEASE IMPLEMENT pixel conversions!");
        }
        return pixels32;
    }

    public static float[][] matrixFromImageStack(ImagePlus imp, double scaleFactor) {
        float[][] a = new float[imp.getStackSize()][];
        try {
            int width = imp.getWidth();
            int height = imp.getHeight();
            IJ.showStatus((String)("Downsampling images " + (double)width * scaleFactor + " x " + (double)height * scaleFactor));
            for (int i = 0; i < imp.getStackSize(); ++i) {
                ImageProcessor ipp = imp.getStack().getProcessor(i + 1);
                ipp.setInterpolate(true);
                if (scaleFactor != 1.0) {
                    ipp = ipp.resize((int)((double)width * scaleFactor), (int)((double)height * scaleFactor));
                }
                a[i] = (float[])ipp.convertToFloat().getPixels();
            }
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    public static float[][] matrixFromImageStackRoi(ImagePlus imp) {
        float[][] a = new float[imp.getStackSize()][];
        try {
            int width = imp.getWidth();
            int height = imp.getHeight();
            int x = 0;
            int y = 0;
            if (imp.getRoi() != null) {
                Rectangle roiRect = imp.getRoi().getBoundingRect();
                width = roiRect.width;
                height = roiRect.height;
                x = roiRect.x;
                y = roiRect.y;
            }
            IJ.showStatus((String)("reading images " + width + " x " + height));
            for (int i = 0; i < imp.getStackSize(); ++i) {
                ImageProcessor ipp = imp.getStack().getProcessor(i + 1);
                if (imp.getRoi() != null) {
                    ipp.setRoi(x, y, width, height);
                    ipp = ipp.crop();
                }
                a[i] = (float[])ipp.convertToFloat().getPixels();
            }
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    public static short[][] shortMatrixFromImageStack(ImagePlus imp) {
        short[][] a = new short[imp.getStackSize()][];
        try {
            int width = imp.getWidth();
            int height = imp.getHeight();
            int x = 0;
            int y = 0;
            if (imp.getRoi() != null) {
                Rectangle roiRect = imp.getRoi().getBoundingRect();
                width = roiRect.width;
                height = roiRect.height;
                x = roiRect.x;
                y = roiRect.y;
            }
            IJ.showStatus((String)"reading images");
            for (int i = 0; i < imp.getStackSize(); ++i) {
                ImageProcessor ipp = imp.getStack().getProcessor(i + 1);
                if (imp.getRoi() != null) {
                    ipp.setRoi(x, y, width, height);
                    ipp = ipp.crop();
                }
                a[i] = (short[])ipp.convertToShort(false).getPixels();
            }
        }
        catch (Exception e) {
            CharArrayWriter c = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(c));
            IJ.log((String)c.toString());
        }
        return a;
    }

    public static float[] montage(float[][] a, int awidth, int columns) {
        int aheight = a[0].length / awidth;
        float scale = 1.0f;
        int montageWidth = awidth * columns;
        int rows = a.length / columns;
        if (a.length % columns != 0) {
            ++rows;
        }
        int montageHeight = aheight * rows;
        FloatProcessor montage = new FloatProcessor(montageWidth, montageHeight);
        montage.setColor(Color.white);
        montage.fill();
        montage.setColor(Color.black);
        int x = 0;
        int y = 0;
        boolean embellish = false;
        for (int j = 0; j < a.length; ++j) {
            FloatProcessor as = new FloatProcessor(awidth, aheight, a[j], null);
            if ((double)scale != 1.0) {
                as = as.resize(awidth, aheight);
            }
            montage.insert((ImageProcessor)as, x, y);
            if (embellish) {
                montage.moveTo(x, y);
                montage.lineTo(x + awidth, y);
                montage.lineTo(x + awidth, y + aheight);
                montage.lineTo(x, y + aheight);
                montage.lineTo(x, y);
                String s = "" + j;
                int swidth = montage.getStringWidth(s);
                montage.moveTo(x + awidth / 2 - swidth / 2, y + aheight);
                montage.drawString(s);
            }
            if ((x += awidth) < montageWidth) continue;
            x = 0;
            if ((y += aheight) >= montageHeight) break;
        }
        return (float[])montage.getPixels();
    }

    public static int minPower2(int n) {
        int newn;
        for (newn = 2; newn < n; newn *= 2) {
        }
        return newn;
    }

    public static void bin(double[] x, int binwidth) {
        for (int i = binwidth / 2; i < x.length - binwidth / 2; i += binwidth) {
            int j;
            double d = 0.0;
            for (j = 0; j < binwidth; ++j) {
                d += x[i + j];
            }
            for (j = 0; j < binwidth; ++j) {
                x[i + j] = d;
            }
        }
    }

    public static float[] makePower2(float[] v) {
        int newlength = BIJutil.minPower2(v.length);
        float[] n = new float[newlength];
        int min = n.length / 2 - v.length / 2;
        int max = min + v.length;
        for (int i = 0; i < n.length; ++i) {
            n[i] = i < min ? v[min - i] : (i >= min && i < max ? v[i - min] : v[max - i + (v.length - 1)]);
        }
        return n;
    }

    public static float[] tile(float[] image, int width) {
        int j;
        int i;
        int height = image.length / width;
        int maxSize = Math.max(width, height);
        int newwidth = BIJutil.minPower2(maxSize);
        int x = (int)Math.round((double)(newwidth - width) / 2.0);
        int y = (int)Math.round((double)(newwidth - height) / 2.0);
        if (x < 0 || x > newwidth - 1 || y < 0 || y > newwidth - 1) {
            IJ.error((String)"Image to be tiled is out of bounds.");
            return null;
        }
        FloatProcessor ip = new FloatProcessor(width, height, image, null);
        ImageProcessor ipout = ip.createProcessor(newwidth, newwidth);
        ImageProcessor ip2 = ip.crop();
        int w2 = ip2.getWidth();
        int h2 = ip2.getHeight();
        int i1 = (int)Math.ceil((double)x / (double)w2);
        int i2 = (int)Math.ceil((double)(newwidth - x) / (double)w2);
        int j1 = (int)Math.ceil((double)y / (double)h2);
        int j2 = (int)Math.ceil((double)(newwidth - y) / (double)h2);
        if ((double)(i1 % 2) > 0.5) {
            ip2.flipHorizontal();
        }
        if ((double)(j1 % 2) > 0.5) {
            ip2.flipVertical();
        }
        for (i = -i1; i < i2; i += 2) {
            for (j = -j1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        ip2.flipHorizontal();
        for (i = -i1 + 1; i < i2; i += 2) {
            for (j = -j1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        ip2.flipVertical();
        for (i = -i1 + 1; i < i2; i += 2) {
            for (j = -j1 + 1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        ip2.flipHorizontal();
        for (i = -i1; i < i2; i += 2) {
            for (j = -j1 + 1; j < j2; j += 2) {
                ipout.insert(ip2, x - i * w2, y - j * h2);
            }
        }
        float[] out = (float[])ipout.getPixels();
        return out;
    }

    public static float[] fit(float[] image, int width) {
        int newwidth;
        int height = image.length / width;
        int maxSize = Math.max(width, height);
        for (newwidth = 2; newwidth != maxSize && (double)newwidth < 1.1 * (double)maxSize; newwidth *= 2) {
        }
        int x = (int)Math.round((double)(newwidth - width) / 2.0);
        int y = (int)Math.round((double)(newwidth - height) / 2.0);
        if (x < 0 || x > newwidth - 1 || y < 0 || y > newwidth - 1) {
            IJ.error((String)"Image to be fitted is out of bounds.");
            return null;
        }
        FloatProcessor ip = new FloatProcessor(width, height, image, null);
        ImageProcessor ipout = ip.createProcessor(newwidth, newwidth);
        ImageProcessor ip2 = ip.crop();
        int w2 = ip2.getWidth();
        int h2 = ip2.getHeight();
        ipout.insert(ip2, x, y);
        float[] out = (float[])ipout.getPixels();
        return out;
    }

    public static float[] fit(float[] spectrum, int width, int height) {
        int oldwidth = (int)Math.sqrt(spectrum.length);
        float[] newimage = new float[width * height];
        int xcenterNew = width / 2;
        int ycenterNew = height / 2;
        int xcenterOld = oldwidth / 2;
        int ycenterOld = oldwidth / 2;
        for (int y = -height / 2; y < height / 2; ++y) {
            for (int x = -width / 2; x < width / 2; ++x) {
                int indexnew = (ycenterNew + y) * width + xcenterNew + x;
                int indexold = (ycenterOld + y) * oldwidth + xcenterOld + x;
                newimage[indexnew] = spectrum[indexold];
            }
        }
        return newimage;
    }

    public static byte[] fit(byte[] image, int width) {
        int newwidth;
        int height = image.length / width;
        int maxSize = Math.max(width, height);
        for (newwidth = 2; newwidth != maxSize && (double)newwidth < 1.1 * (double)maxSize; newwidth *= 2) {
        }
        int x = (int)Math.round((double)(newwidth - width) / 2.0);
        int y = (int)Math.round((double)(newwidth - height) / 2.0);
        if (x < 0 || x > newwidth - 1 || y < 0 || y > newwidth - 1) {
            IJ.error((String)"Image to be fitted is out of bounds.");
            return null;
        }
        ByteProcessor ip = new ByteProcessor(width, height, image, null);
        ImageProcessor ipout = ip.createProcessor(newwidth, newwidth);
        ImageProcessor ip2 = ip.crop();
        ipout.insert(ip2, x, y);
        return (byte[])ipout.getPixels();
    }

    public static float[] getMask(Roi roi, int width, int height) {
        ByteProcessor mp = new ByteProcessor(width, height);
        ImagePlus np = new ImagePlus("mask in getMask", (ImageProcessor)mp);
        np.setRoi(roi);
        np.show();
        ByteProcessor bmask = (ByteProcessor)roi.getMask();
        mp.setColor(1);
        mp.fill((ImageProcessor)bmask);
        byte[] mask = (byte[])mp.getPixels();
        float[] fmask = new float[mask.length];
        for (int i = 0; i < mask.length; ++i) {
            fmask[i] = mask[i] & 0xFF;
        }
        return fmask;
    }

    public static float[] center(float[] image0, int width0, float[] image1, int width1, float scaling) {
        return BIJutil.center(image0, width0, image1, width1, scaling, 0, 0);
    }

    public static float[] center(float[] image0, int width0, float[] image1, int width1, float scaling, int offset_x, int offset_y) {
        int height0 = image0.length / width0;
        int height1 = image1.length / width1;
        ImageProcessor ip0 = new FloatProcessor(width0, height0, image0, null).duplicate();
        ImageProcessor ip1 = new FloatProcessor(width1, height1, image1, null).duplicate();
        int newwidth1 = (int)((float)width1 * scaling);
        int newheight1 = (int)((float)height1 * scaling);
        ip1 = ip1.resize(newwidth1, newheight1);
        int x = (int)Math.round((double)(width0 - ip1.getWidth()) / 2.0);
        int y = (int)Math.round((double)(height0 - ip1.getHeight()) / 2.0);
        ip0.insert(ip1, x + offset_x, y + offset_y);
        return (float[])ip0.getPixels();
    }

    public static boolean saveAsText(float[] v, String path) {
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error((String)("Cannot save vector (saveAsText)" + path + " " + e));
            return false;
        }
        for (int j = 0; j < v.length; ++j) {
            pw.println(v[j]);
        }
        pw.close();
        return true;
    }

    public static float[] tofloat(double[] v) {
        float[] n = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            n[i] = (float)v[i];
        }
        return n;
    }

    public static String toString(float[][] m) {
        StringBuffer sb = new StringBuffer("Matrix (");
        int iN = m.length;
        int iM = m[0].length;
        sb.append(iN);
        sb.append("x");
        sb.append(iM);
        sb.append("):\n");
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                sb.append(m[j][i]);
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(double[][] m) {
        StringBuffer sb = new StringBuffer("Matrix (");
        int iN = m.length;
        int iM = m[0].length;
        sb.append(iN);
        sb.append("x");
        sb.append(iM);
        sb.append("):\n");
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                sb.append(m[j][i]);
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(int[][] m) {
        StringBuffer sb = new StringBuffer("Matrix (");
        int iN = m.length;
        int iM = m[0].length;
        sb.append(iN);
        sb.append("x");
        sb.append(iM);
        sb.append("):\n");
        for (int j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                sb.append(m[j][i]);
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(float[] m) {
        StringBuffer sb = new StringBuffer("Vector (");
        int iN = m.length;
        sb.append(iN);
        sb.append("), ");
        for (int j = 0; j < iN; ++j) {
            sb.append(m[j]);
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toString(double[] m) {
        StringBuffer sb = new StringBuffer("");
        int iN = m.length;
        sb.append(iN);
        sb.append("):\n");
        for (int j = 0; j < iN; ++j) {
            sb.append(m[j]);
            sb.append("\t");
        }
        return sb.toString();
    }
}

