/*
 * Decompiled with CFR 0.152.
 */
package volume;

import bijnum.BIJmatrix;
import volume.Convolver;
import volume.GaussianDerivative;

public class Hessian {
    public static void smallest(float[] result, float[] image, int width, double scale) {
        GaussianDerivative k0 = new GaussianDerivative(scale, 0);
        GaussianDerivative k1 = new GaussianDerivative(scale, 1);
        GaussianDerivative k2 = new GaussianDerivative(scale, 2);
        float[] hxx = Convolver.convolvex(image, width, image.length / width, k2);
        hxx = Convolver.convolvey(hxx, width, image.length / width, k0);
        float[] hxy = Convolver.convolvex(image, width, image.length / width, k1);
        hxy = Convolver.convolvey(hxy, width, image.length / width, k1);
        float[] hyy = Convolver.convolvex(image, width, image.length / width, k0);
        hyy = Convolver.convolvey(hyy, width, image.length / width, k2);
        for (int j = 0; j < image.length / width; ++j) {
            for (int i = 0; i < width; ++i) {
                float b = -(hxx[j * width + i] + hyy[j * width + i]);
                float c = hxx[j * width + i] * hyy[j * width + i] - hxy[j * width + i] * hxy[j * width + i];
                float h1 = (float)(-0.5 * ((double)b + (double)(b < 0.0f ? -1 : 1) * Math.sqrt(b * b - 4.0f * c)));
                float h2 = c / h1;
                result[j * width + i] = h1 > h2 ? h2 : h1;
            }
        }
    }

    public static void largest(float[] result, float[] image, int width, double scale) throws IllegalArgumentException {
        GaussianDerivative k0 = new GaussianDerivative(scale, 0);
        GaussianDerivative k1 = new GaussianDerivative(scale, 1);
        GaussianDerivative k2 = new GaussianDerivative(scale, 2);
        float[] hxx = Convolver.convolvex(image, width, image.length / width, k2);
        hxx = Convolver.convolvey(hxx, width, image.length / width, k0);
        float[] hxy = Convolver.convolvex(image, width, image.length / width, k1);
        hxy = Convolver.convolvey(hxy, width, image.length / width, k1);
        float[] hyy = Convolver.convolvex(image, width, image.length / width, k0);
        hyy = Convolver.convolvey(hyy, width, image.length / width, k2);
        for (int j = 0; j < image.length / width; ++j) {
            for (int i = 0; i < width; ++i) {
                double b = -(hxx[j * width + i] + hyy[j * width + i]);
                double c = hxx[j * width + i] * hyy[j * width + i] - hxy[j * width + i] * hxy[j * width + i];
                double d = b * b - 4.0 * c;
                double e = 0.0;
                if (d > 0.0) {
                    e = Math.sqrt(d);
                }
                double h1 = -0.5 * (b + (double)(b < 0.0 ? -1 : 1) * d);
                double h2 = h1 != 0.0 ? c / h1 : 0.0;
                result[j * width + i] = h1 > h2 ? (float)h1 : (float)h2;
                if (!Float.isNaN(result[j * width + i])) continue;
                result[j * width + i] = 0.0f;
            }
        }
    }

    public static float[] largest(float[] image, int width, double scale) {
        float[] result = new float[image.length];
        Hessian.largest(result, image, width, scale);
        return result;
    }

    public static float[] smallest(float[] image, int width, double scale) {
        float[] result = new float[image.length];
        Hessian.smallest(result, image, width, scale);
        return result;
    }

    public static float[] det(float[] image, int width, double scale) {
        GaussianDerivative k0 = new GaussianDerivative(scale, 0);
        GaussianDerivative k1 = new GaussianDerivative(scale, 1);
        GaussianDerivative k2 = new GaussianDerivative(scale, 2);
        float[] hxx = Convolver.convolvex(image, width, image.length / width, k2);
        hxx = Convolver.convolvey(hxx, width, image.length / width, k0);
        float[] hxy = Convolver.convolvex(image, width, image.length / width, k1);
        hxy = Convolver.convolvey(hxy, width, image.length / width, k1);
        float[] hyy = Convolver.convolvex(image, width, image.length / width, k0);
        hyy = Convolver.convolvey(hyy, width, image.length / width, k2);
        float[] hxxplushyy = BIJmatrix.addElements(hxx, hyy);
        float[] hxxminhyy = BIJmatrix.sub(hxx, hyy);
        float[] sqrhxxminhyy = BIJmatrix.mulElements(hxxminhyy, hxxminhyy);
        float[] hxytimeshxy4 = BIJmatrix.mulElements(hxy, hxy);
        BIJmatrix.mulElements(hxytimeshxy4, hxytimeshxy4, 4.0);
        float[] sum = BIJmatrix.addElements(sqrhxxminhyy, hxytimeshxy4);
        float[] sqrt = new float[sum.length];
        BIJmatrix.pow(sqrt, sum, 0.5);
        float[] l1 = BIJmatrix.addElements(hxxplushyy, sqrt);
        float[] l2 = BIJmatrix.sub(hxxplushyy, sqrt);
        float[] det = BIJmatrix.mulElements(l1, l2);
        return det;
    }
}

