/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import QuickPALM.MyIO;
import QuickPALM.ReconstructionViewer;
import ij.IJ;
import ij.ImagePlus;
import ij.io.DirectoryChooser;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Reconstruct_Dataset
implements PlugIn {
    ImagePlus imp;
    ImageProcessor ip;
    MyDialogs dg = new MyDialogs();
    MyFunctions f = new MyFunctions();
    MyIO io = new MyIO();
    ReconstructionViewer viewer;
    String imagedir = "";

    public void run(String arg) {
        IJ.register(Reconstruct_Dataset.class);
        if (!this.dg.reconstructDataset()) {
            return;
        }
        if (this.f.ptable.getCounter() == 0 || !this.f.ptable.columnExists(13)) {
            IJ.error((String)"Not able to detect a valid 'Particles Table', please load one");
            return;
        }
        this.viewer = new ReconstructionViewer("PALM/STORM Reconstruction", this.dg, this.f);
        this.viewer.imp.show();
        int zcounter = 0;
        int fcounter = 0;
        if (!this.dg.viewer_do3d && !this.dg.viewer_doMovie) {
            this.viewer.clear();
            this.viewer.draw(1, this.viewer.nframes, this.viewer.minZ, this.viewer.maxZ);
            return;
        }
        if (this.dg.viewer_do3d && !this.dg.viewer_doMovie) {
            zcounter = 0;
            for (double z = this.viewer.minZ; z <= this.viewer.maxZ; z += this.dg.viewer_zstep) {
                this.viewer.clear();
                this.viewer.draw(1, this.viewer.nframes, z - this.dg.viewer_zstep / 2.0, z + this.dg.viewer_zstep / 2.0);
                this.save("imgrec_z" + this.zfill(zcounter) + ".tif");
                ++zcounter;
            }
        } else if (this.dg.viewer_doMovie) {
            zcounter = 0;
            fcounter = 0;
            for (int f = 1; f <= this.viewer.nframes; ++f) {
                if (f % this.dg.viewer_update != 0) continue;
                if (!this.dg.viewer_do3d) {
                    this.viewer.clear();
                    if (this.dg.viewer_accumulate == 0) {
                        this.viewer.draw(1, f, this.viewer.minZ, this.viewer.maxZ);
                    } else {
                        this.viewer.draw(Math.round(f - this.dg.viewer_accumulate / 2), Math.round(f + this.dg.viewer_accumulate / 2), this.viewer.minZ, this.viewer.maxZ);
                    }
                    this.save("imgrec_f" + this.zfill(fcounter) + ".tif");
                } else {
                    double z;
                    zcounter = 0;
                    if (this.dg.viewer_accumulate == 0) {
                        for (z = this.viewer.minZ; z <= this.viewer.maxZ; z += this.dg.viewer_zstep) {
                            this.viewer.clear();
                            this.viewer.draw(1, f, z - this.dg.viewer_zstep / 2.0, z + this.dg.viewer_zstep / 2.0);
                            this.save("imgrec_z" + this.zfill(zcounter) + "_f" + this.zfill(fcounter) + ".tif");
                            ++zcounter;
                        }
                    } else {
                        for (z = this.viewer.minZ; z <= this.viewer.maxZ; z += this.dg.viewer_zstep) {
                            this.viewer.clear();
                            if (this.dg.viewer_mergebellow != 0.0 && z == this.viewer.minZ) {
                                this.viewer.draw(Math.round(f - this.dg.viewer_accumulate / 2), Math.round(f + this.dg.viewer_accumulate / 2), -9999999.0, z + this.dg.viewer_zstep / 2.0);
                            } else if (this.dg.viewer_mergebellow != 0.0 && z + this.dg.viewer_zstep > this.viewer.maxZ) {
                                this.viewer.draw(Math.round(f - this.dg.viewer_accumulate / 2), Math.round(f + this.dg.viewer_accumulate / 2), z - this.dg.viewer_zstep / 2.0, 9999999.0);
                            } else {
                                this.viewer.draw(Math.round(f - this.dg.viewer_accumulate / 2), Math.round(f + this.dg.viewer_accumulate / 2), z - this.dg.viewer_zstep / 2.0, z + this.dg.viewer_zstep / 2.0);
                            }
                            this.save("imgrec_z" + this.zfill(zcounter) + "_f" + this.zfill(fcounter) + ".tif");
                            ++zcounter;
                        }
                    }
                }
                ++fcounter;
            }
        }
        if (this.viewer.imp != null) {
            this.viewer.imp.close();
        }
        if (zcounter == 0) {
            zcounter = 1;
        }
        if (fcounter == 0) {
            fcounter = 1;
        }
        int nframes = zcounter * fcounter;
        IJ.run((String)"Image Sequence...", (String)("open=" + this.imagedir + "imgrec_f000000.tif number=" + nframes + " starting=1 increment=1 scale=100 file=[.tif] or=[] sort use"));
    }

    void save(String filename) {
        if (this.imagedir == "") {
            DirectoryChooser chooser = new DirectoryChooser("Choose directory to save the images on");
            this.imagedir = chooser.getDirectory();
        }
        IJ.save((ImagePlus)this.imp, (String)(this.imagedir + filename));
    }

    String zfill(int n) {
        String txt = "" + n;
        while (txt.length() < 6) {
            txt = "0" + txt;
        }
        return txt;
    }
}

