/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.PointOverlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.overlay.PointFigure;
import net.imagej.ui.swing.tools.SwingPointTool;
import org.jhotdraw.draw.Figure;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;
import org.scijava.util.ColorRGB;

@Plugin(type=JHotDrawAdapter.class, priority=94.0)
public class PointJHotDrawOverlay
extends AbstractJHotDrawAdapter<PointOverlay, PointFigure> {
    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingPointTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof PointOverlay)) {
            return false;
        }
        return figure == null || figure instanceof PointFigure;
    }

    @Override
    public PointOverlay createNewOverlay() {
        return new PointOverlay(this.getContext());
    }

    @Override
    public Figure createDefaultFigure() {
        PointFigure figure = new PointFigure();
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateFigure(OverlayView view, PointFigure figure) {
        super.updateFigure(view, figure);
        PointFigure pointFigure = figure;
        Overlay overlay = view.getData();
        assert (overlay instanceof PointOverlay);
        PointOverlay pointOverlay = (PointOverlay)overlay;
        pointFigure.setFillColor(pointOverlay.getFillColor());
        pointFigure.setLineColor(pointOverlay.getLineColor());
        pointFigure.setPoints(pointOverlay.getPoints());
    }

    @Override
    public void updateOverlay(PointFigure figure, OverlayView view) {
        Overlay overlay = view.getData();
        assert (overlay instanceof PointOverlay);
        PointOverlay pointOverlay = (PointOverlay)overlay;
        ColorRGB fillColor = overlay.getFillColor();
        ColorRGB lineColor = overlay.getLineColor();
        super.updateOverlay(figure, view);
        pointOverlay.setFillColor(fillColor);
        pointOverlay.setLineColor(lineColor);
        pointOverlay.setPoints(figure.getPoints());
        pointOverlay.update();
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<PointFigure>(display, this);
    }

    @Override
    public Shape toShape(PointFigure figure) {
        throw new UnsupportedOperationException();
    }
}

