/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import java.util.ArrayList;
import math3d.Point3d;
import vib.FloatMatrix;
import vib.app.ImageMetaData;
import vib.app.module.Module;
import vib.app.module.State;
import vib.app.module.TissueStatistics;

public class CenterTransformation
extends Module {
    @Override
    public String getName() {
        return "CenterTransformation";
    }

    @Override
    protected String getMessage() {
        return "Calculating center transformation";
    }

    @Override
    protected void run(State state, int index) {
        new TissueStatistics().runOnOneImage(state, -1);
        new TissueStatistics().runOnOneImage(state, index);
        this.prereqsDone(state, index);
        String statisticsPath = state.getStatisticsPath(index);
        String templStatisticsPath = state.getStatisticsPath(-1);
        ImageMetaData stats = new ImageMetaData(statisticsPath);
        String transformLabel = state.getTransformLabel(2);
        if (stats.upToDate(templStatisticsPath, transformLabel)) {
            return;
        }
        ImageMetaData templStats = new ImageMetaData(templStatisticsPath);
        ArrayList<Point3d> templCenters = new ArrayList<Point3d>();
        ArrayList<Point3d> centers = new ArrayList<Point3d>();
        for (int i = 1; i < templStats.materials.length; ++i) {
            String name;
            ImageMetaData.Material m2;
            ImageMetaData.Material m1 = templStats.materials[i];
            if (m1.count == 0 || (m2 = stats.getMaterial(name = m1.name)) == null || m2.count == 0) continue;
            Point3d center = new Point3d(m1.centerX, m1.centerY, m1.centerZ);
            templCenters.add(center);
            center = new Point3d(m2.centerX, m2.centerY, m2.centerZ);
            centers.add(center);
        }
        if (centers.size() == 0) {
            return;
        }
        if (centers.size() < 3) {
            throw new RuntimeException("Need at least 3 labels shared with the template!");
        }
        Point3d[] c1 = new Point3d[centers.size()];
        Point3d[] c2 = new Point3d[centers.size()];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = (Point3d)templCenters.get(i);
            c2[i] = (Point3d)centers.get(i);
        }
        FloatMatrix matrix = FloatMatrix.bestRigid(c2, c1);
        stats.setMatrix(transformLabel, matrix);
        if (!stats.saveTo(statisticsPath)) {
            throw new RuntimeException("Could not save " + statisticsPath);
        }
    }
}

