/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import java.io.File;
import java.util.List;
import octree.CubeData;
import octree.VolumeOctree;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;

public class Cube
implements AxisConstants,
Comparable<Cube> {
    public static final int RESOLUTION_SUFFICIENT = 0;
    public static final int RESOLUTION_UNSUFFICIENT = 1;
    public static final int OUTSIDE_CANVAS = 2;
    public static final double RES_THRESHOLD = 512.0;
    final int x;
    final int y;
    final int z;
    final int level;
    final String name;
    final String dir;
    private Cube[] children;
    private final Point3d midp;
    private final Point3d[] corners;
    private Point2d[] cornersInCanvas;
    private boolean visible = false;
    private boolean subtreeVisible = false;
    final CubeData cdata;
    final VolumeOctree octree;
    private double distSqFromEye;
    Point3d ptmp = new Point3d();

    public Cube(VolumeOctree oct, String dir, int x, int y, int z, int l) {
        this.dir = dir + "/";
        this.octree = oct;
        this.x = x;
        this.y = y;
        this.z = z;
        this.level = l;
        this.name = x + "_" + y + "_" + z + "_" + l;
        if (new File(this.dir + this.name + ".info").exists()) {
            this.cdata = new CubeData(this);
            this.corners = new Point3d[8];
            this.cornersInCanvas = new Point2d[8];
            for (int i = 0; i < 8; ++i) {
                this.cornersInCanvas[i] = new Point2d();
                this.corners[i] = new Point3d();
            }
            float[] min = this.cdata.min;
            float[] max = this.cdata.max;
            this.corners[0].set((double)min[0], (double)min[1], (double)min[2]);
            this.corners[7].set((double)max[0], (double)max[1], (double)max[2]);
            this.corners[1].set((double)max[0], (double)min[1], (double)min[2]);
            this.corners[2].set((double)min[0], (double)max[1], (double)min[2]);
            this.corners[3].set((double)max[0], (double)max[1], (double)min[2]);
            this.corners[4].set((double)min[0], (double)min[1], (double)max[2]);
            this.corners[5].set((double)max[0], (double)min[1], (double)max[2]);
            this.corners[6].set((double)min[0], (double)max[1], (double)max[2]);
            this.midp = new Point3d((double)(min[0] + (max[0] - min[0]) / 2.0f), (double)(min[1] + (max[1] - min[1]) / 2.0f), (double)(min[2] + (max[2] - min[2]) / 2.0f));
        } else {
            this.corners = null;
            this.cdata = null;
            this.midp = null;
        }
    }

    public Cube createCube(VolumeOctree oct, String dir, int x, int y, int z, int l) {
        String name = x + "_" + y + "_" + z + "_" + l;
        if (new File(dir, name + ".info").exists()) {
            return new Cube(oct, dir, x, y, z, l);
        }
        return null;
    }

    public Cube[] getChildren() {
        return this.children;
    }

    public void prepareForAxis(int axis, Point3d eyePosInLocal) {
        this.cdata.prepareForAxis(axis);
        if (this.children == null) {
            return;
        }
        for (Cube c : this.children) {
            if (c == null) continue;
            c.prepareForAxis(axis, eyePosInLocal);
            c.calcDistSqFromEye(eyePosInLocal);
        }
    }

    private void calcDistSqFromEye(Point3d eyePosInLocal) {
        this.distSqFromEye = eyePosInLocal.distanceSquared(this.midp);
    }

    public void collectCubes(List<Cube> cubes, int axis) {
        this.cdata.prepareForAxis(axis);
        cubes.add(this);
        if (this.children == null) {
            return;
        }
        for (Cube c : this.children) {
            if (c == null) continue;
            c.collectCubes(cubes, axis);
        }
    }

    public void hideSelf() {
        if (this.visible) {
            this.cdata.hide();
            this.visible = false;
        }
    }

    public void hideSubtree() {
        if (this.subtreeVisible) {
            this.subtreeVisible = false;
            if (this.children == null) {
                return;
            }
            for (Cube localCube : this.children) {
                if (localCube == null) continue;
                localCube.hideSelf();
                localCube.hideSubtree();
            }
        }
    }

    private void showSelf() {
        if (!this.visible) {
            this.cdata.show();
            this.visible = true;
        }
    }

    public void update(Canvas3D canvas, Transform3D volToIP) {
        if (this.octree.stopUpdating) {
            return;
        }
        int i = this.checkResolution(canvas, volToIP);
        if (i == 2) {
            this.hideSelf();
            this.hideSubtree();
            return;
        }
        if (i == 1 && this.children != null) {
            this.subtreeVisible = true;
            this.hideSelf();
            for (Cube localCube : this.children) {
                if (localCube == null) continue;
                localCube.update(canvas, volToIP);
            }
        } else {
            this.hideSubtree();
            this.showSelf();
        }
    }

    public int checkResolution(Canvas3D canvas, Transform3D volToIP) {
        for (int i = 0; i < this.corners.length; ++i) {
            this.volumePointInCanvas(canvas, volToIP, this.corners[i], this.cornersInCanvas[i]);
        }
        if (this.outsideCanvas(canvas)) {
            return 2;
        }
        double d2 = this.cornersInCanvas[0].distance(this.cornersInCanvas[7]);
        double d1 = this.cornersInCanvas[1].distance(this.cornersInCanvas[6]);
        if (d1 > d2) {
            d2 = d1;
        }
        if ((d1 = this.cornersInCanvas[2].distance(this.cornersInCanvas[5])) > d2) {
            d2 = d1;
        }
        if ((d1 = this.cornersInCanvas[3].distance(this.cornersInCanvas[4])) > d2) {
            d2 = d1;
        }
        return d2 <= 512.0 ? 0 : 1;
    }

    public void createChildren() {
        if (this.level == 1) {
            return;
        }
        int l = this.level >> 1;
        int s = 128;
        this.children = new Cube[8];
        this.children[0] = this.createCube(this.octree, this.dir, this.x, this.y, this.z, l);
        this.children[1] = this.createCube(this.octree, this.dir, this.x + l * 128, this.y, this.z, l);
        this.children[2] = this.createCube(this.octree, this.dir, this.x, this.y + l * 128, this.z, l);
        this.children[3] = this.createCube(this.octree, this.dir, this.x + l * 128, this.y + l * 128, this.z, l);
        this.children[4] = this.createCube(this.octree, this.dir, this.x, this.y, this.z + l * 128, l);
        this.children[5] = this.createCube(this.octree, this.dir, this.x + l * 128, this.y, this.z + l * 128, l);
        this.children[6] = this.createCube(this.octree, this.dir, this.x, this.y + l * 128, this.z + l * 128, l);
        this.children[7] = this.createCube(this.octree, this.dir, this.x + l * 128, this.y + l * 128, this.z + l * 128, l);
        for (Cube cube : this.children) {
            if (cube == null) continue;
            cube.createChildren();
        }
    }

    private final void volumePointInCanvas(Canvas3D canvas, Transform3D volToIP, Point3d p, Point2d ret) {
        this.ptmp.set((Tuple3d)p);
        volToIP.transform(this.ptmp);
        canvas.getPixelLocationFromImagePlate(this.ptmp, ret);
    }

    private final boolean outsideCanvas(Canvas3D canvas) {
        int i;
        int i2;
        boolean found = true;
        for (i2 = 0; i2 < 8; ++i2) {
            if (!(this.cornersInCanvas[i2].x >= 0.0)) continue;
            found = false;
            break;
        }
        if (found) {
            return true;
        }
        found = true;
        for (i2 = 0; i2 < 8; ++i2) {
            if (!(this.cornersInCanvas[i2].y >= 0.0)) continue;
            found = false;
            break;
        }
        if (found) {
            return true;
        }
        int cw = canvas.getWidth();
        int ch = canvas.getHeight();
        found = true;
        for (i = 0; i < 8; ++i) {
            if (!(this.cornersInCanvas[i].x < (double)cw)) continue;
            found = false;
            break;
        }
        if (found) {
            return true;
        }
        found = true;
        for (i = 0; i < 8; ++i) {
            if (!(this.cornersInCanvas[i].y < (double)ch)) continue;
            found = false;
            break;
        }
        return found;
    }

    @Override
    public int compareTo(Cube other) {
        if (other == null) {
            return -1;
        }
        if (this.distSqFromEye < other.distSqFromEye) {
            return -1;
        }
        if (this.distSqFromEye > other.distSqFromEye) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.name;
    }
}

