/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.TypeConverter;
import java.awt.Color;
import java.awt.Frame;
import sc.fiji.i5d.Image5D;

public class Make_Montage
implements PlugIn {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static int borderWidth;
    private static double scale;
    private static boolean label;
    private static int saveID;
    private static boolean bDisplayedChannelsOnly;
    private static boolean bAllTimeFrames;
    private static boolean bOutputImage5D;
    private static boolean bDoScaling;

    public void run(String arg) {
        IJ.register(Make_Montage.class);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        this.makeMontage(imp);
    }

    public void makeMontage(ImagePlus imp) {
        if (!(imp instanceof Image5D)) {
            IJ.error((String)"Make Montage", (String)"Image5D required");
            return;
        }
        Image5D i5d = (Image5D)imp;
        int nSlices = imp.getStackSize();
        if (columns == 0 || imp.getID() != saveID) {
            rows = columns = (int)Math.sqrt(nSlices);
            int n = nSlices - columns * rows;
            if (n > 0) {
                columns += (int)Math.ceil((double)n / (double)rows);
            }
            scale = 1.0;
            if (imp.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imp.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = nSlices;
        }
        GenericDialog gd = new GenericDialog("Make Montage", (Frame)IJ.getInstance());
        gd.addNumericField("Columns:", (double)columns, 0);
        gd.addNumericField("Rows:", (double)rows, 0);
        gd.addNumericField("Scale Factor:", scale, 2);
        gd.addNumericField("First Slice:", (double)first, 0);
        gd.addNumericField("Last Slice:", (double)last, 0);
        gd.addNumericField("Increment:", (double)inc, 0);
        gd.addNumericField("Border Width:", (double)borderWidth, 0);
        gd.addCheckbox("Label Slices", label);
        gd.addCheckbox("Displayed Channels only", bDisplayedChannelsOnly);
        gd.addCheckbox("All Time Frames", bAllTimeFrames);
        gd.addCheckbox("Output as Image5D", bOutputImage5D);
        gd.addCheckbox("Copy Contrast and Brightness", bDoScaling);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        columns = (int)gd.getNextNumber();
        rows = (int)gd.getNextNumber();
        scale = gd.getNextNumber();
        first = (int)gd.getNextNumber();
        last = (int)gd.getNextNumber();
        inc = (int)gd.getNextNumber();
        borderWidth = (int)gd.getNextNumber();
        if (borderWidth < 0) {
            borderWidth = 0;
        }
        if (first < 1) {
            first = 1;
        }
        if (last > nSlices) {
            last = nSlices;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (gd.invalidNumber()) {
            IJ.error((String)"Invalid number");
            return;
        }
        label = gd.getNextBoolean();
        this.setDisplayedChannelsOnly(gd.getNextBoolean());
        this.setAllTimeFrames(gd.getNextBoolean());
        this.setOutputImage5D(gd.getNextBoolean());
        this.setDoScaling(gd.getNextBoolean());
        saveID = imp.getID();
        long tstart = System.currentTimeMillis();
        if (bOutputImage5D) {
            Image5D resultI5D = this.doI5DMontage(i5d, columns, rows, scale, first, last, inc, borderWidth, label);
            if (resultI5D != null) {
                resultI5D.show();
            }
        } else {
            ImagePlus resultImage = this.doMontage(i5d, columns, rows, scale, first, last, inc, borderWidth, label);
            if (resultImage != null) {
                resultImage.show();
            }
        }
        long tstop = System.currentTimeMillis();
        IJ.showStatus((String)("Montage: " + IJ.d2s((double)((double)(tstop - tstart) / 1000.0), (int)2) + " seconds"));
    }

    public void setDisplayedChannelsOnly(boolean displayedChannelsOnly) {
        bDisplayedChannelsOnly = displayedChannelsOnly;
    }

    public void setAllTimeFrames(boolean allTimeFrames) {
        bAllTimeFrames = allTimeFrames;
    }

    public void setOutputImage5D(boolean outputImage5D) {
        bOutputImage5D = outputImage5D;
    }

    public void setDoScaling(boolean doScaling) {
        bDoScaling = doScaling;
    }

    ImagePlus doMontage(Image5D i5d, int columns, int rows, double scale, int first, int last, int inc, int borderWidth, boolean labels) {
        if (!i5d.lock()) {
            return null;
        }
        Image5D imp = i5d;
        int width = (int)((double)i5d.getWidth() * scale);
        int height = (int)((double)i5d.getHeight() * scale);
        int montageImageWidth = width * columns + borderWidth / 2;
        int montageImageHeight = height * rows + borderWidth / 2;
        int currentChannel = i5d.getCurrentChannel();
        int currentSlice = i5d.getCurrentSlice();
        int currentFrame = i5d.getCurrentFrame();
        int nMontagedChannels = 0;
        int[] montagedChannels = new int[i5d.getNChannels()];
        for (int c = 1; c <= i5d.getNChannels(); ++c) {
            i5d.storeChannelProperties(c);
            if (bDisplayedChannelsOnly && (i5d.getDisplayMode() == 2 && !i5d.getChannelDisplayProperties(c).isDisplayedInOverlay() || i5d.getDisplayMode() != 2 && c != currentChannel)) continue;
            montagedChannels[nMontagedChannels] = c;
            ++nMontagedChannels;
        }
        if (bDisplayedChannelsOnly && nMontagedChannels == 0) {
            return null;
        }
        int startFrame = i5d.getCurrentFrame();
        int nFrames = 1;
        if (bAllTimeFrames) {
            startFrame = 1;
            nFrames = i5d.getNFrames();
        }
        byte[] reds = new byte[montageImageWidth * montageImageHeight];
        byte[] greens = new byte[montageImageWidth * montageImageHeight];
        byte[] blues = new byte[montageImageWidth * montageImageHeight];
        String newTitle = WindowManager.makeUniqueName((String)(imp.getTitle() + " Montage"));
        ImagePlus resultImp = IJ.createImage((String)newTitle, (String)"rgb black", (int)montageImageWidth, (int)montageImageHeight, (int)nFrames);
        resultImp.setCalibration(imp.getCalibration().copy());
        for (int frame = startFrame; frame < startFrame + nFrames; ++frame) {
            for (int destChannel = 1; destChannel <= nMontagedChannels; ++destChannel) {
                int srcChannel = montagedChannels[destChannel - 1];
                i5d.setCurrentPosition(0, 0, srcChannel - 1, currentSlice - 1, frame - 1);
                ImageStack tmp = i5d.getStack();
                ImagePlus tempImg = new ImagePlus(imp.getTitle() + " Montage", tmp);
                ImagePlus montage = this.makeMontage(tempImg, columns, rows, scale, first, last, inc, borderWidth, label);
                tempImg.flush();
                if (bDoScaling) {
                    montage.getProcessor().setMinAndMax(i5d.getChannelDisplayProperties(srcChannel).getMinValue(), i5d.getChannelDisplayProperties(srcChannel).getMaxValue());
                } else {
                    montage.getProcessor().resetMinAndMax();
                }
                ColorProcessor proc = (ColorProcessor)new TypeConverter(montage.getProcessor(), bDoScaling).convertToRGB();
                int[] rgb = new int[3];
                for (int x = 0; x < montageImageWidth; ++x) {
                    for (int y = 0; y < montageImageHeight; ++y) {
                        int pos = x + montageImageWidth * y;
                        proc.getPixel(x, y, rgb);
                        int newval = rgb[0] + (0xFF & reds[pos]);
                        reds[pos] = newval < 256 ? (int)newval : -1;
                        newval = rgb[1] + (0xFF & greens[pos]);
                        greens[pos] = newval < 256 ? (int)newval : -1;
                        newval = rgb[2] + (0xFF & blues[pos]);
                        blues[pos] = newval < 256 ? (int)newval : -1;
                    }
                }
                montage.flush();
            }
            ColorProcessor cp = new ColorProcessor(montageImageWidth, montageImageHeight);
            cp.setRGB(reds, greens, blues);
            resultImp.setSlice(frame - startFrame + 1);
            resultImp.setProcessor(null, (ImageProcessor)cp);
            for (int i = 0; i < montageImageWidth * montageImageHeight; ++i) {
                reds[i] = 0;
                greens[i] = 0;
                blues[i] = 0;
            }
        }
        i5d.setCurrentPosition(0, 0, currentChannel - 1, currentSlice - 1, currentFrame - 1);
        i5d.unlock();
        return resultImp;
    }

    Image5D doI5DMontage(Image5D i5d, int columns, int rows, double scale, int first, int last, int inc, int borderWidth, boolean labels) {
        if (!i5d.lock()) {
            return null;
        }
        Image5D imp = i5d;
        int width = (int)((double)i5d.getWidth() * scale);
        int height = (int)((double)i5d.getHeight() * scale);
        int montageImageWidth = width * columns + borderWidth / 2;
        int montageImageHeight = height * rows + borderWidth / 2;
        int currentChannel = i5d.getCurrentChannel();
        int currentSlice = i5d.getCurrentSlice();
        int currentFrame = i5d.getCurrentFrame();
        int nMontagedChannels = 0;
        int[] montagedChannels = new int[i5d.getNChannels()];
        for (int c = 1; c <= i5d.getNChannels(); ++c) {
            i5d.storeChannelProperties(c);
            if (bDisplayedChannelsOnly && (i5d.getDisplayMode() == 2 && !i5d.getChannelDisplayProperties(c).isDisplayedInOverlay() || i5d.getDisplayMode() != 2 && c != currentChannel)) continue;
            montagedChannels[nMontagedChannels] = c;
            ++nMontagedChannels;
        }
        if (bDisplayedChannelsOnly && nMontagedChannels == 0) {
            return null;
        }
        int startFrame = i5d.getCurrentFrame();
        int nFrames = 1;
        if (bAllTimeFrames) {
            startFrame = 1;
            nFrames = i5d.getNFrames();
        }
        String newTitle = WindowManager.makeUniqueName((String)(imp.getTitle() + " Montage"));
        Image5D resultI5D = new Image5D(newTitle, i5d.getType(), montageImageWidth, montageImageHeight, nMontagedChannels, 1, nFrames, false);
        resultI5D.setCalibration(i5d.getCalibration().copy());
        for (int frame = startFrame; frame < startFrame + nFrames; ++frame) {
            for (int destChannel = 1; destChannel <= nMontagedChannels; ++destChannel) {
                int srcChannel = montagedChannels[destChannel - 1];
                i5d.setCurrentPosition(0, 0, srcChannel - 1, currentSlice - 1, frame - 1);
                ImagePlus tempImg = new ImagePlus(imp.getTitle() + " Montage", i5d.getStack());
                ImagePlus montage = this.makeMontage(tempImg, columns, rows, scale, first, last, inc, borderWidth, label);
                tempImg.flush();
                resultI5D.setPixels(montage.getProcessor().getPixels(), destChannel, 1, frame - startFrame + 1);
                montage.flush();
                if (frame != startFrame) continue;
                if (destChannel == resultI5D.getCurrentChannel()) {
                    resultI5D.setChannelCalibration(destChannel, i5d.getChannelCalibration(srcChannel).copy());
                    resultI5D.setChannelDisplayProperties(destChannel, i5d.getChannelDisplayProperties(srcChannel).copy());
                    resultI5D.restoreCurrentChannelProperties();
                } else {
                    resultI5D.setChannelCalibration(destChannel, i5d.getChannelCalibration(srcChannel).copy());
                    resultI5D.setChannelDisplayProperties(destChannel, i5d.getChannelDisplayProperties(srcChannel).copy());
                    resultI5D.restoreChannelProperties(destChannel);
                }
                if (bDoScaling) continue;
                resultI5D.getProcessor(destChannel).resetMinAndMax();
            }
        }
        i5d.setCurrentPosition(0, 0, currentChannel - 1, currentSlice - 1, currentFrame - 1);
        i5d.unlock();
        return resultI5D;
    }

    public ImagePlus makeMontage(ImagePlus imp, int columns, int rows, double scale, int first, int last, int inc, int borderWidth, boolean labels) {
        boolean blackBackground;
        int stackWidth = imp.getWidth();
        int stackHeight = imp.getHeight();
        int width = (int)((double)stackWidth * scale);
        int height = (int)((double)stackHeight * scale);
        int montageWidth = width * columns;
        int montageHeight = height * rows;
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor montage = ip.createProcessor(montageWidth + borderWidth / 2, montageHeight + borderWidth / 2);
        ImageStatistics is = imp.getStatistics();
        boolean bl = blackBackground = is.mode < 200;
        if (imp.isInvertedLut()) {
            boolean bl2 = blackBackground = !blackBackground;
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            blackBackground = true;
        }
        if (blackBackground) {
            boolean signed16Bit;
            float[] cTable = imp.getCalibration().getCTable();
            boolean bl3 = signed16Bit = cTable != null && cTable[0] == -32768.0f;
            if (signed16Bit) {
                montage.setValue(32768.0);
            } else {
                montage.setColor(Color.black);
            }
            montage.fill();
            montage.setColor(Color.white);
        } else {
            montage.setColor(Color.white);
            montage.fill();
            montage.setColor(Color.black);
        }
        ImageStack stack = imp.getStack();
        int x = 0;
        int y = 0;
        for (int slice = first; slice <= last; slice += inc) {
            ImageProcessor aSlice = stack.getProcessor(slice);
            if (scale != 1.0) {
                aSlice = aSlice.resize(width, height);
            }
            montage.insert(aSlice, x, y);
            String label = stack.getShortSliceLabel(slice);
            if (borderWidth > 0) {
                this.drawBorder(montage, x, y, width, height, borderWidth);
            }
            if (labels) {
                this.drawLabel(montage, slice, label, x, y, width, height);
            }
            if ((x += width) >= montageWidth) {
                x = 0;
                if ((y += height) >= montageHeight) break;
            }
            IJ.showProgress((double)((double)(slice - first) / (double)(last - first)));
        }
        if (borderWidth > 0) {
            int w2 = borderWidth / 2;
            this.drawBorder(montage, w2, w2, montageWidth - w2, montageHeight - w2, borderWidth);
        }
        IJ.showProgress((double)1.0);
        ImagePlus imp2 = new ImagePlus("Montage", montage);
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        if (cal.scaled()) {
            cal.pixelWidth /= scale;
            cal.pixelHeight /= scale;
        }
        return imp2;
    }

    void drawBorder(ImageProcessor montage, int x, int y, int width, int height, int borderWidth) {
        montage.setLineWidth(borderWidth);
        montage.moveTo(x, y);
        montage.lineTo(x + width, y);
        montage.lineTo(x + width, y + height);
        montage.lineTo(x, y + height);
        montage.lineTo(x, y);
    }

    void drawLabel(ImageProcessor montage, int slice, String label, int x, int y, int width, int height) {
        if (label != null && !label.equals("") && montage.getStringWidth(label) >= width) {
            while ((label = label.substring(0, label.length() - 1)).length() > 1 && montage.getStringWidth(label) >= width) {
            }
        }
        if (label == null || label.equals("")) {
            label = "" + slice;
        }
        int swidth = montage.getStringWidth(label);
        montage.moveTo(x += width / 2 - swidth / 2, y += height);
        montage.drawString(label);
    }

    static {
        bDisplayedChannelsOnly = false;
        bAllTimeFrames = false;
        bOutputImage5D = false;
        bDoScaling = true;
    }
}

