/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.cooccurrenceMatrix;

import java.util.Arrays;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.image.cooccurrenceMatrix.MatrixOrientation;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.CooccurrenceMatrix.class)
public class CooccurrenceMatrix2D<T extends RealType<T>>
extends AbstractUnaryFunctionOp<IterableInterval<T>, double[][]>
implements Ops.Image.CooccurrenceMatrix,
Contingent {
    @Parameter(label="Number of Gray Levels", min="0", max="128", stepSize="1", initializer="32")
    private int nrGreyLevels;
    @Parameter(label="Distance", min="0", max="128", stepSize="1", initializer="1")
    private int distance;
    @Parameter(label="Matrix Orientation")
    private MatrixOrientation orientation;
    private UnaryFunctionOp<IterableInterval<T>, Pair<T, T>> minmax;

    @Override
    public void initialize() {
        super.initialize();
        this.minmax = Functions.unary(this.ops(), Ops.Stats.MinMax.class, Pair.class, this.in(), new Object[0]);
    }

    @Override
    public double[][] calculate(IterableInterval<T> input) {
        double[][] output = new double[this.nrGreyLevels][this.nrGreyLevels];
        Cursor cursor = input.localizingCursor();
        Pair<T, T> minMax = this.minmax.calculate(input);
        double localMin = ((RealType)minMax.getA()).getRealDouble();
        double localMax = ((RealType)minMax.getB()).getRealDouble();
        int[][] pixels = new int[(int)input.dimension(1)][(int)input.dimension(0)];
        for (int i = 0; i < pixels.length; ++i) {
            Arrays.fill(pixels[i], Integer.MAX_VALUE);
        }
        int minimumX = (int)input.min(0);
        int minimumY = (int)input.min(1);
        double diff = localMax - localMin;
        while (cursor.hasNext()) {
            cursor.fwd();
            int bin = (int)((((RealType)cursor.get()).getRealDouble() - localMin) / diff * (double)this.nrGreyLevels);
            pixels[cursor.getIntPosition((int)1) - minimumY][cursor.getIntPosition((int)0) - minimumX] = bin < this.nrGreyLevels - 1 ? bin : this.nrGreyLevels - 1;
        }
        int nrPairs = 0;
        int orientationAtX = this.orientation.getValueAtDim(0) * this.distance;
        int orientationAtY = this.orientation.getValueAtDim(1) * this.distance;
        for (int y = 0; y < pixels.length; ++y) {
            for (int x = 0; x < pixels[y].length; ++x) {
                if (pixels[y][x] == Integer.MAX_VALUE) continue;
                int sx = x + orientationAtX;
                int sy = y + orientationAtY;
                if (sx < 0 || sy < 0 || sy >= pixels.length || sx >= pixels[sy].length || pixels[sy][sx] == Integer.MAX_VALUE) continue;
                double[] dArray = output[pixels[y][x]];
                int n = pixels[sy][sx];
                dArray[n] = dArray[n] + 1.0;
                ++nrPairs;
            }
        }
        if (nrPairs > 0) {
            double divisor = 1.0 / (double)nrPairs;
            for (int row = 0; row < output.length; ++row) {
                int col = 0;
                while (col < output[row].length) {
                    double[] dArray = output[row];
                    int n = col++;
                    dArray[n] = dArray[n] * divisor;
                }
            }
        }
        return output;
    }

    @Override
    public boolean conforms() {
        return ((IterableInterval)this.in()).numDimensions() == 2 && this.orientation.isCompatible(2);
    }
}

