/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.invert;

import java.math.BigInteger;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.types.UnboundedIntegerType;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.Invert.class, priority=100.0)
public class InvertIIInteger<T extends IntegerType<T>>
extends AbstractUnaryComputerOp<IterableInterval<T>, IterableInterval<T>>
implements Contingent,
Ops.Image.Invert {
    @Parameter(required=false)
    private T min;
    @Parameter(required=false)
    private T max;
    private UnaryComputerOp<IterableInterval<T>, IterableInterval<T>> mapper;

    @Override
    public void compute(IterableInterval<T> input, IterableInterval<T> output) {
        if (this.mapper == null) {
            BigInteger minValue = this.min == null ? ((IntegerType)InvertIIInteger.minValue((RealType)input.firstElement())).getBigInteger() : this.min.getBigInteger();
            BigInteger maxValue = this.max == null ? ((IntegerType)InvertIIInteger.maxValue((RealType)input.firstElement())).getBigInteger() : this.max.getBigInteger();
            final BigInteger minMax = minValue.add(maxValue);
            this.mapper = Computers.unary(this.ops(), Ops.Map.class, output, input, new AbstractUnaryComputerOp<T, T>(){

                @Override
                public void compute(T in, T out) {
                    BigInteger inverted = minMax.subtract(in.getBigInteger());
                    if (inverted.compareTo(((IntegerType)InvertIIInteger.minValue(out)).getBigInteger()) <= 0) {
                        out.set(InvertIIInteger.minValue(out));
                    } else if (inverted.compareTo(((IntegerType)InvertIIInteger.maxValue(out)).getBigInteger()) >= 0) {
                        out.set(InvertIIInteger.maxValue(out));
                    } else {
                        out.setBigInteger(inverted);
                    }
                }
            });
        }
        this.mapper.compute(input, output);
    }

    public static <T extends RealType<T>> T minValue(T type) {
        RealType min = (RealType)type.createVariable();
        if (type instanceof UnboundedIntegerType) {
            min.setReal(0.0f);
        } else {
            min.setReal(min.getMinValue());
        }
        return (T)min;
    }

    public static <T extends RealType<T>> T maxValue(T type) {
        RealType max = (RealType)type.createVariable();
        if (max instanceof Unsigned128BitType) {
            Unsigned128BitType t = (Unsigned128BitType)max;
            t.set(t.getMaxBigIntegerValue());
        } else if (max instanceof UnsignedLongType) {
            UnsignedLongType t = (UnsignedLongType)max;
            t.set(t.getMaxBigIntegerValue());
        } else if (max instanceof UnboundedIntegerType) {
            max.setReal(0.0f);
        } else {
            max.setReal(type.getMaxValue());
        }
        return (T)max;
    }

    @Override
    public boolean conforms() {
        Object inType = ((IterableInterval)this.in()).firstElement();
        if (!(inType instanceof IntegerType)) {
            return false;
        }
        IntegerType copy = (IntegerType)((IntegerType)((IterableInterval)this.in()).firstElement()).createVariable();
        copy.setInteger(Long.MAX_VALUE);
        return copy.getIntegerLong() == Long.MAX_VALUE;
    }
}

