/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.scijava.Cancelable;

public class EdgeFeatureCalculator
extends MultiThreadedBenchmarkAlgorithm
implements Cancelable {
    private static final String BASE_ERROR_MSG = "[EdgeFeatureCalculator] ";
    private final Settings settings;
    private final Model model;
    private boolean isCanceled;
    private String cancelReason;
    private final boolean doLogIt;

    public EdgeFeatureCalculator(Model model, Settings settings, boolean doLogIt) {
        this.settings = settings;
        this.model = model;
        this.doLogIt = doLogIt;
    }

    public boolean checkInput() {
        if (null == this.model) {
            this.errorMessage = "[EdgeFeatureCalculator] Model object is null.";
            return false;
        }
        if (null == this.settings) {
            this.errorMessage = "[EdgeFeatureCalculator] Settings object is null.";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        for (EdgeAnalyzer analyzer : this.settings.getEdgeAnalyzers()) {
            List features = analyzer.getFeatures();
            Map featureNames = analyzer.getFeatureNames();
            Map featureShortNames = analyzer.getFeatureShortNames();
            Map featureDimensions = analyzer.getFeatureDimensions();
            Map isIntFeature = analyzer.getIsIntFeature();
            this.model.getFeatureModel().declareEdgeFeatures(features, featureNames, featureShortNames, featureDimensions, isIntFeature);
        }
        this.computeEdgeFeaturesAgent(this.model.getTrackModel().edgeSet(), this.settings.getEdgeAnalyzers(), this.doLogIt);
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public void computeEdgesFeatures(Collection<DefaultWeightedEdge> edges, boolean doLogIt) {
        List<EdgeAnalyzer> spotFeatureAnalyzers = this.settings.getEdgeAnalyzers();
        this.computeEdgeFeaturesAgent(edges, spotFeatureAnalyzers, doLogIt);
    }

    private void computeEdgeFeaturesAgent(Collection<DefaultWeightedEdge> edges, List<EdgeAnalyzer> analyzers, boolean doLogIt) {
        this.isCanceled = false;
        this.cancelReason = null;
        Logger logger = this.model.getLogger();
        if (doLogIt) {
            logger.log("Computing edge features:\n", Logger.BLUE_COLOR);
        }
        for (EdgeAnalyzer analyzer : analyzers) {
            if (this.isCanceled()) {
                return;
            }
            if (analyzer.isManualFeature()) continue;
            analyzer.setNumThreads(this.numThreads);
            analyzer.process(edges, this.model);
            if (!doLogIt) continue;
            logger.log("  - " + analyzer.getName() + " in " + analyzer.getProcessingTime() + " ms.\n");
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

