/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AnnotationChangeEvent;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;

public class XYTextSimpleAnnotation
extends AbstractXYAnnotation {
    private static final long serialVersionUID = 1L;
    private float x;
    private float y;
    private String text;
    private Font font;
    private Color color;
    private final ChartPanel chartPanel;
    private final boolean paintBackground;

    public XYTextSimpleAnnotation(ChartPanel chartPanel) {
        this(chartPanel, false);
    }

    public XYTextSimpleAnnotation(ChartPanel chartPanel, boolean paintBackground) {
        this.chartPanel = chartPanel;
        this.paintBackground = paintBackground;
    }

    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        Rectangle2D box = this.chartPanel.getScreenDataArea();
        float sx = (float)plot.getDomainAxis().valueToJava2D((double)this.x, box, plot.getDomainAxisEdge());
        int stringWidth = g2.getFontMetrics().stringWidth(this.text);
        float maxXLim = (float)box.getWidth() - (float)stringWidth;
        if (sx > maxXLim) {
            sx = maxXLim;
        }
        if ((double)sx < box.getMinX()) {
            sx = (float)box.getMinX();
        }
        float sy = (float)plot.getRangeAxis().valueToJava2D((double)this.y, this.chartPanel.getScreenDataArea(), plot.getRangeAxisEdge());
        g2.setTransform(new AffineTransform());
        if (this.paintBackground) {
            g2.setColor(this.chartPanel.getBackground());
            int height = g2.getFontMetrics().getHeight();
            g2.fillRect((int)((double)sx - 0.1 * (double)stringWidth), (int)((double)sy - 1.1 * (double)height), (int)(1.25 * (double)stringWidth), (int)(1.3 * (double)height));
        }
        g2.setColor(this.color);
        g2.setFont(this.font);
        g2.drawString(this.text, sx, sy);
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
        this.notifyListeners(new AnnotationChangeEvent((Object)this, (Annotation)this));
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setColor(Color color) {
        this.color = color;
        this.notifyListeners(new AnnotationChangeEvent((Object)this, (Annotation)this));
    }
}

