/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.model;

import bdv.tools.InitializeViewerState;
import bdv.util.Affine3DHelpers;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import bdv.viewer.animate.AbstractTransformAnimator;
import bdv.viewer.animate.SimilarityTransformAnimator;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.ui.models.TransformationModel;

public class TMTransformationModel
extends TransformationModel {
    private ViewerPanel viewerPanel;
    private final boolean isTimeSeries;

    public TMTransformationModel(boolean isTimeSeries) {
        super(isTimeSeries);
        this.isTimeSeries = isTimeSeries;
    }

    public void initialize(ViewerPanel viewerPanel) {
        this.viewerPanel = viewerPanel;
    }

    public void transformToShowInterval(Interval interval, AffineTransform3D sourceTransform) {
        if (this.viewerPanel == null) {
            return;
        }
        if (this.isTimeSeries) {
            int lastDim = interval.numDimensions() - 1;
            long meanTimePoint = (interval.min(lastDim) + interval.max(lastDim)) / 2L;
            if (this.viewerPanel != null) {
                this.viewerPanel.setTimepoint((int)meanTimePoint);
            }
            interval = RevampUtils.removeLastDimension((Interval)interval);
        }
        int width = this.viewerPanel.getWidth();
        int height = this.viewerPanel.getHeight();
        double cX = (double)width / 2.0;
        double cY = (double)height / 2.0;
        AffineTransform3D c = TMTransformationModel.calculateCurrentTransform((ViewerState)this.viewerPanel.state(), cX, cY);
        AffineTransform3D t = TMTransformationModel.calculateTargetTransform(interval, sourceTransform, cX, cY);
        this.viewerPanel.setTransformAnimator((AbstractTransformAnimator)new SimilarityTransformAnimator(c, t, cX, cY, 300L));
    }

    public void resetView() {
        int width = this.viewerPanel.getWidth();
        int height = this.viewerPanel.getHeight();
        double cX = (double)width / 2.0;
        double cY = (double)height / 2.0;
        AffineTransform3D c = TMTransformationModel.calculateCurrentTransform((ViewerState)this.viewerPanel.state(), cX, cY);
        AffineTransform3D t = InitializeViewerState.initTransform((int)width, (int)height, (boolean)false, (ViewerState)this.viewerPanel.state());
        t.set(t.get(0, 3) - cX, 0, 3);
        t.set(t.get(1, 3) - cY, 1, 3);
        this.viewerPanel.setTransformAnimator((AbstractTransformAnimator)new SimilarityTransformAnimator(c, t, cX, cY, 300L));
    }

    private static AffineTransform3D calculateCurrentTransform(ViewerState state, double cX, double cY) {
        AffineTransform3D c = new AffineTransform3D();
        state.getViewerTransform(c);
        c.set(c.get(0, 3) - cX, 0, 3);
        c.set(c.get(1, 3) - cY, 1, 3);
        return c;
    }

    private static AffineTransform3D calculateTargetTransform(Interval interval, AffineTransform3D sourceTransform, double cX, double cY) {
        double sX0 = interval.min(0);
        double sX1 = interval.max(0);
        double sY0 = interval.min(1);
        double sY1 = interval.max(1);
        double sX = (sX0 + sX1) / 2.0;
        double sY = (sY0 + sY1) / 2.0;
        double sZ = 0.0;
        double[][] m = new double[3][4];
        double[] qSource = new double[4];
        double[] qViewer = new double[4];
        Affine3DHelpers.extractApproximateRotationAffine((AffineTransform3D)sourceTransform, (double[])qSource, (int)2);
        LinAlgHelpers.quaternionInvert((double[])qSource, (double[])qViewer);
        LinAlgHelpers.quaternionToR((double[])qViewer, (double[][])m);
        double[] centerSource = new double[]{sX, sY, 0.0};
        double[] centerGlobal = new double[3];
        double[] translation = new double[3];
        sourceTransform.apply(centerSource, centerGlobal);
        LinAlgHelpers.quaternionApply((double[])qViewer, (double[])centerGlobal, (double[])translation);
        LinAlgHelpers.scale((double[])translation, (double)-1.0, (double[])translation);
        LinAlgHelpers.setCol((int)3, (double[])translation, (double[][])m);
        AffineTransform3D t = new AffineTransform3D();
        t.set(m);
        double[] pSource = new double[]{sX1 + 0.5, sY1 + 0.5, 0.0};
        double[] pGlobal = new double[3];
        double[] pScreen = new double[3];
        sourceTransform.apply(pSource, pGlobal);
        t.apply(pGlobal, pScreen);
        double scaleX = cX / pScreen[0];
        double scaleY = cY / pScreen[1];
        boolean zoomedIn = true;
        double scale = Math.max(scaleX, scaleY);
        t.scale(scale);
        t.set(t.get(0, 3) + cX - 0.5, 0, 3);
        t.set(t.get(1, 3) + cY - 0.5, 1, 3);
        t.set(t.get(0, 3) - cX, 0, 3);
        t.set(t.get(1, 3) - cY, 1, 3);
        return t;
    }
}

