/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.hyperstack;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.visualization.hyperstack.SpotEditTool;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class SpotEditToolConfigPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Logger logger;
    private final JFormattedTextField jNFQualityThreshold;
    private final JFormattedTextField jNFDistanceTolerance;
    private final JFormattedTextField jNFNFrames;
    private final JFormattedTextField jNFNStepwiseTime;
    private final SpotEditTool.SpotEditToolParams params;
    final JButton buttonSelectTrackDown;
    final JButton buttonSelectTrackUp;
    final JButton buttonSemiAutoTracking;
    final JButton buttonSelectTrack;

    public SpotEditToolConfigPanel(SpotEditTool.SpotEditToolParams params) {
        this.params = params;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotEditToolConfigPanel.this.updateParamsFromTextFields();
            }
        };
        FocusListener fl = new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                SpotEditToolConfigPanel.this.updateParamsFromTextFields();
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        };
        this.setTitle("TrackMate tools");
        this.setIconImage(Icons.TRACK_ICON.getImage());
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        JPanel mainPanel = new JPanel();
        this.getContentPane().add(mainPanel);
        mainPanel.setLayout(null);
        JLabel lblTitle = new JLabel("TrackMate tools");
        lblTitle.setBounds(6, 6, 395, 33);
        lblTitle.setFont(Fonts.BIG_FONT);
        lblTitle.setIcon(Icons.TRACK_ICON_64x64);
        mainPanel.add(lblTitle);
        JPanel panelSemiAutoParams = new JPanel();
        panelSemiAutoParams.setBorder(new LineBorder(new Color(252, 117, 0), 1, false));
        panelSemiAutoParams.setBounds(6, 51, 192, 142);
        mainPanel.add(panelSemiAutoParams);
        panelSemiAutoParams.setLayout(null);
        JLabel lblSemiAutoTracking = new JLabel("Semi-automatic tracking");
        lblSemiAutoTracking.setBounds(6, 6, 180, 16);
        lblSemiAutoTracking.setFont(Fonts.FONT.deriveFont(1));
        panelSemiAutoParams.add(lblSemiAutoTracking);
        JLabel lblQualityThreshold = new JLabel("Quality threshold");
        lblQualityThreshold.setToolTipText("<html>The fraction of the initial spot quality <br>found spots must have to be considered for linking. <br>The higher, the more stringent.</html>");
        lblQualityThreshold.setBounds(6, 66, 119, 16);
        lblQualityThreshold.setFont(Fonts.SMALL_FONT);
        panelSemiAutoParams.add(lblQualityThreshold);
        this.jNFQualityThreshold = new JFormattedTextField(params.qualityThreshold);
        this.jNFQualityThreshold.setHorizontalAlignment(0);
        this.jNFQualityThreshold.setFont(Fonts.SMALL_FONT);
        this.jNFQualityThreshold.setBounds(137, 64, 49, 18);
        this.jNFQualityThreshold.addActionListener(al);
        this.jNFQualityThreshold.addFocusListener(fl);
        panelSemiAutoParams.add(this.jNFQualityThreshold);
        JLabel lblDistanceTolerance = new JLabel("Distance tolerance");
        lblDistanceTolerance.setToolTipText("<html>The maximal distance above which found spots are rejected, <br>expressed in units of the initial spot radius.</html>");
        lblDistanceTolerance.setBounds(6, 86, 119, 16);
        lblDistanceTolerance.setFont(Fonts.SMALL_FONT);
        panelSemiAutoParams.add(lblDistanceTolerance);
        this.jNFDistanceTolerance = new JFormattedTextField(params.distanceTolerance);
        this.jNFDistanceTolerance.setHorizontalAlignment(0);
        this.jNFDistanceTolerance.setFont(Fonts.SMALL_FONT);
        this.jNFDistanceTolerance.setBounds(137, 84, 49, 18);
        this.jNFDistanceTolerance.addActionListener(al);
        this.jNFDistanceTolerance.addFocusListener(fl);
        panelSemiAutoParams.add(this.jNFDistanceTolerance);
        JLabel lblNFrames = new JLabel("Max nFrames");
        lblNFrames.setToolTipText("<html>How many frames to process at max. <br/>Make it 0 or negative for no limit.</html>");
        lblNFrames.setBounds(6, 104, 119, 16);
        lblNFrames.setFont(Fonts.SMALL_FONT);
        panelSemiAutoParams.add(lblNFrames);
        this.jNFNFrames = new JFormattedTextField((Object)params.nFrames);
        this.jNFNFrames.setBounds(137, 104, 49, 18);
        this.jNFNFrames.setHorizontalAlignment(0);
        this.jNFNFrames.setFont(Fonts.SMALL_FONT);
        this.jNFNFrames.addActionListener(al);
        this.jNFNFrames.addFocusListener(fl);
        panelSemiAutoParams.add(this.jNFNFrames);
        this.buttonSemiAutoTracking = new JButton(Icons.SPOT_ICON_64x64);
        this.buttonSemiAutoTracking.setBounds(6, 31, 33, 23);
        panelSemiAutoParams.add(this.buttonSemiAutoTracking);
        JLabel labelSemiAutoTracking = new JLabel("Semi-automatic tracking");
        labelSemiAutoTracking.setToolTipText("Launch semi-automatic tracking on selected spots.");
        labelSemiAutoTracking.setFont(Fonts.SMALL_FONT);
        labelSemiAutoTracking.setBounds(49, 31, 137, 23);
        panelSemiAutoParams.add(labelSemiAutoTracking);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBounds(210, 51, 264, 328);
        mainPanel.add(scrollPane);
        final JTextPane textPane = new JTextPane();
        textPane.setFont(Fonts.SMALL_FONT);
        textPane.setEditable(false);
        textPane.setBackground(this.getBackground());
        scrollPane.setViewportView(textPane);
        JPanel panelButtons = new JPanel();
        panelButtons.setBounds(6, 262, 192, 117);
        panelButtons.setBorder(new LineBorder(new Color(252, 117, 0), 1, false));
        mainPanel.add(panelButtons);
        panelButtons.setLayout(null);
        JLabel lblSelectionTools = new JLabel("Selection tools");
        lblSelectionTools.setFont(Fonts.FONT.deriveFont(1));
        lblSelectionTools.setBounds(6, 11, 172, 14);
        panelButtons.add(lblSelectionTools);
        this.buttonSelectTrack = new JButton(Icons.SELECT_TRACK_ICON);
        this.buttonSelectTrack.setBounds(10, 36, 33, 23);
        panelButtons.add(this.buttonSelectTrack);
        JLabel lblSelectTrack = new JLabel("Select track");
        lblSelectTrack.setBounds(53, 36, 129, 23);
        lblSelectTrack.setFont(Fonts.SMALL_FONT);
        lblSelectTrack.setToolTipText("Select the whole tracks selected spots belong to.");
        panelButtons.add(lblSelectTrack);
        this.buttonSelectTrackUp = new JButton(Icons.SELECT_TRACK_ICON_UPWARDS);
        this.buttonSelectTrackUp.setBounds(10, 61, 33, 23);
        panelButtons.add(this.buttonSelectTrackUp);
        JLabel lblSelectTrackUpward = new JLabel("Select track upward");
        lblSelectTrackUpward.setBounds(53, 61, 129, 23);
        lblSelectTrackUpward.setFont(Fonts.SMALL_FONT);
        lblSelectTrackUpward.setToolTipText("<html>Select the whole tracks selected spots <br>belong to, backward in time.</html>");
        panelButtons.add(lblSelectTrackUpward);
        this.buttonSelectTrackDown = new JButton(Icons.SELECT_TRACK_ICON_DOWNWARDS);
        this.buttonSelectTrackDown.setBounds(10, 86, 33, 23);
        panelButtons.add(this.buttonSelectTrackDown);
        JLabel lblSelectTrackDown = new JLabel("Select track downward");
        lblSelectTrackDown.setBounds(53, 86, 129, 23);
        lblSelectTrackDown.setFont(Fonts.SMALL_FONT);
        lblSelectTrackDown.setToolTipText("<html>Select the whole tracks selected spots <br>belong to, forward in time.</html>");
        panelButtons.add(lblSelectTrackDown);
        JPanel panel = new JPanel();
        panel.setBorder(new LineBorder(new Color(252, 117, 0)));
        panel.setBounds(6, 201, 192, 53);
        mainPanel.add(panel);
        panel.setLayout(null);
        JLabel lblNavigationTools = new JLabel("Navigation tools");
        lblNavigationTools.setBounds(6, 6, 172, 14);
        lblNavigationTools.setFont(Fonts.FONT.deriveFont(1));
        panel.add(lblNavigationTools);
        this.jNFNStepwiseTime = new JFormattedTextField((Object)params.stepwiseTimeBrowsing);
        this.jNFNStepwiseTime.setBounds(137, 26, 49, 18);
        this.jNFNStepwiseTime.setHorizontalAlignment(0);
        this.jNFNStepwiseTime.setFont(Fonts.SMALL_FONT);
        this.jNFNStepwiseTime.addActionListener(al);
        this.jNFNStepwiseTime.addFocusListener(fl);
        panel.add(this.jNFNStepwiseTime);
        JLabel lblJumpByb = new JLabel("Stepwise time browsing");
        lblJumpByb.setBounds(10, 29, 120, 14);
        lblJumpByb.setFont(Fonts.SMALL_FONT);
        panel.add(lblJumpByb);
        this.logger = new Logger(this){

            @Override
            public void error(String message) {
                this.log(message, Logger.ERROR_COLOR);
            }

            @Override
            public void log(final String message, final Color color) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textPane.setEditable(true);
                        StyleContext sc = StyleContext.getDefaultStyleContext();
                        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
                        int len = textPane.getDocument().getLength();
                        textPane.setCaretPosition(len);
                        textPane.setCharacterAttributes(aset, false);
                        textPane.replaceSelection(message);
                        textPane.setEditable(false);
                    }
                });
            }

            @Override
            public void setStatus(String status) {
                this.log(status, Logger.GREEN_COLOR);
            }

            @Override
            public void setProgress(double val) {
            }
        };
        this.setSize(487, 418);
        this.setDefaultCloseOperation(1);
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void updateParamsFromTextFields() {
        this.params.distanceTolerance = ((Number)this.jNFDistanceTolerance.getValue()).doubleValue();
        this.params.qualityThreshold = ((Number)this.jNFQualityThreshold.getValue()).doubleValue();
        this.params.nFrames = ((Number)this.jNFNFrames.getValue()).intValue();
        this.params.stepwiseTimeBrowsing = ((Number)this.jNFNStepwiseTime.getValue()).intValue();
    }
}

