/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxGdCodec;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.util.png.mxPngEncodeParam;
import com.mxgraph.util.png.mxPngImageEncoder;
import com.mxgraph.view.mxGraph;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.DefaultFileFilter;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeFrame;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphComponent;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeSvgCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;

public class SaveAction
extends AbstractAction {
    private static final long serialVersionUID = 7672151690754466760L;
    protected String lastDir = null;
    private final TrackScheme trackScheme;

    public SaveAction(TrackScheme trackScheme) {
        this.putValue("SmallIcon", Icons.CAMERA_EXPORT_ICON);
        this.trackScheme = trackScheme;
    }

    protected void saveXmlPng(TrackSchemeFrame frame, String filename, Color bg) throws IOException {
        TrackSchemeGraphComponent graphComponent = this.trackScheme.getGUI().graphComponent;
        JGraphXAdapter graph = this.trackScheme.getGraph();
        BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)bg, (boolean)graphComponent.isAntiAlias(), null, (mxGraphics2DCanvas)graphComponent.getCanvas());
        mxCodec codec = new mxCodec();
        String xml = URLEncoder.encode(mxXmlUtils.getXml((Node)codec.encode((Object)graph.getModel())), "UTF-8");
        mxPngEncodeParam param = mxPngEncodeParam.getDefaultEncodeParam((RenderedImage)image);
        param.setCompressedText(new String[]{"mxGraphModel", xml});
        try (FileOutputStream outputStream = new FileOutputStream(new File(filename));){
            mxPngImageEncoder encoder = new mxPngImageEncoder((OutputStream)outputStream, param);
            if (image != null) {
                encoder.encode((RenderedImage)image);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)graphComponent), "No Image Data");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ext;
        int i;
        TrackSchemeGraphComponent graphComponent = this.trackScheme.getGUI().graphComponent;
        JGraphXAdapter graph = this.trackScheme.getGraph();
        FileFilter selectedFilter = null;
        DefaultFileFilter xmlPngFilter = new DefaultFileFilter(".png", "PNG+XML file (.png)");
        DefaultFileFilter vmlFileFilter = new DefaultFileFilter(".html", "VML file (.html)");
        Object filename = null;
        boolean dialogShown = false;
        String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
        JFileChooser fc = new JFileChooser(wd);
        DefaultFileFilter defaultFilter = xmlPngFilter;
        fc.addChoosableFileFilter(defaultFilter);
        fc.addChoosableFileFilter(new DefaultFileFilter(".pdf", "PDF file (.pdf)"));
        fc.addChoosableFileFilter(new DefaultFileFilter(".svg", "SVG file (.svg)"));
        fc.addChoosableFileFilter(new DefaultFileFilter(".html", "HTML file (.html)"));
        fc.addChoosableFileFilter(vmlFileFilter);
        fc.addChoosableFileFilter(new DefaultFileFilter(".txt", "Graph Drawing file (.txt)"));
        fc.addChoosableFileFilter(new DefaultFileFilter(".mxe", "mxGraph Editor file (.mxe)"));
        Object[] imageFormats = ImageIO.getReaderFormatNames();
        HashSet<String> formats = new HashSet<String>();
        for (i = 0; i < imageFormats.length; ++i) {
            ext = imageFormats[i].toString().toLowerCase();
            formats.add(ext);
        }
        imageFormats = formats.toArray();
        for (i = 0; i < imageFormats.length; ++i) {
            ext = imageFormats[i].toString();
            fc.addChoosableFileFilter(new DefaultFileFilter("." + ext, ext.toUpperCase() + " File  (." + ext + ")"));
        }
        fc.addChoosableFileFilter(new DefaultFileFilter.ImageFileFilter("All Images"));
        fc.setFileFilter(defaultFilter);
        int rc = fc.showDialog(null, "Save");
        dialogShown = true;
        if (rc != 0) {
            return;
        }
        this.lastDir = fc.getSelectedFile().getParent();
        filename = fc.getSelectedFile().getAbsolutePath();
        selectedFilter = fc.getFileFilter();
        if (selectedFilter instanceof DefaultFileFilter) {
            ext = ((DefaultFileFilter)selectedFilter).getExtension();
            if (!((String)filename).toLowerCase().endsWith(ext)) {
                filename = (String)filename + ext;
            }
        }
        if (new File((String)filename).exists() && JOptionPane.showConfirmDialog((Component)((Object)graphComponent), "Overwrite existing file?") != 0) {
            return;
        }
        try {
            ext = ((String)filename).substring(((String)filename).lastIndexOf(46) + 1);
            if (ext.equalsIgnoreCase("svg")) {
                mxSvgCanvas canvas = (mxSvgCanvas)mxCellRenderer.drawCells((mxGraph)graph, null, (double)1.0, null, (mxCellRenderer.CanvasFactory)new mxCellRenderer.CanvasFactory(this){

                    public mxICanvas createCanvas(int width, int height) {
                        TrackSchemeSvgCanvas lCanvas = new TrackSchemeSvgCanvas(mxDomUtils.createSvgDocument((int)width, (int)height));
                        lCanvas.setEmbedded(true);
                        return lCanvas;
                    }
                });
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)canvas.getDocument()), (String)filename);
            } else if (selectedFilter == vmlFileFilter) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxCellRenderer.createVmlDocument((mxGraph)graph, null, (double)1.0, null, null).getDocumentElement()), (String)filename);
            } else if (ext.equalsIgnoreCase("html")) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxCellRenderer.createHtmlDocument((mxGraph)graph, null, (double)1.0, null, null).getDocumentElement()), (String)filename);
            } else if (ext.equalsIgnoreCase("mxe") || ext.equalsIgnoreCase("xml")) {
                mxCodec codec = new mxCodec();
                String xml = mxXmlUtils.getXml((Node)codec.encode((Object)graph.getModel()));
                mxUtils.writeFile((String)xml, (String)filename);
            } else if (ext.equalsIgnoreCase("txt")) {
                String content = mxGdCodec.encode((mxGraph)graph);
                mxUtils.writeFile((String)content, (String)filename);
            } else if (ext.equalsIgnoreCase("pdf")) {
                this.exportGraphToPdf((String)filename);
            } else {
                Color bg = null;
                if (!ext.equalsIgnoreCase("gif") && !ext.equalsIgnoreCase("png") || JOptionPane.showConfirmDialog((Component)((Object)graphComponent), "Transparent Background?") != 0) {
                    bg = graphComponent.getBackground();
                }
                if (selectedFilter == xmlPngFilter || ext.equalsIgnoreCase("png") && !dialogShown) {
                    this.saveXmlPng(this.trackScheme.getGUI(), (String)filename, bg);
                } else {
                    BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)bg, (boolean)graphComponent.isAntiAlias(), null, (mxGraphics2DCanvas)graphComponent.getCanvas());
                    if (image != null) {
                        ImageIO.write((RenderedImage)image, ext, new File((String)filename));
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)graphComponent), "No Image Data");
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)graphComponent), ex.toString(), "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportGraphToPdf(String filename) {
        java.awt.Rectangle bounds = new java.awt.Rectangle(this.trackScheme.getGUI().graphComponent.getViewport().getViewSize());
        Rectangle pageSize = new Rectangle((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height);
        Document document = new Document(pageSize);
        PdfWriter writer = null;
        Graphics g2 = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            document.open();
            PdfContentByte canvas = writer.getDirectContent();
            g2 = new PdfGraphics2D(canvas, pageSize.getWidth(), pageSize.getHeight());
            this.trackScheme.getGUI().graphComponent.getViewport().paintComponents(g2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        finally {
            if (null != g2) {
                g2.dispose();
            }
            document.close();
        }
    }
}

