/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.appose;

import java.util.Objects;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.appose.DTypes;
import net.imglib2.appose.ShmImg;
import net.imglib2.appose.WrappedNDArray;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.nio.BufferAccess;
import net.imglib2.img.basictypeaccess.nio.BufferDataAccessFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Cast;
import net.imglib2.util.Fraction;
import org.apposed.appose.NDArray;

public class NDArrays {
    public static <T extends NativeType<T>> NDArray ndArray(T type, int ... dimensions) {
        return new NDArray(DTypes.dtype(type), new NDArray.Shape(NDArray.Shape.Order.F_ORDER, dimensions));
    }

    public static <T extends NativeType<T>> ArrayImg<T, ?> asArrayImg(NDArray ndArray) {
        return NDArrays.asArrayImg(ndArray, (NativeType)Cast.unchecked(DTypes.type(ndArray.dType()).get()));
    }

    public static <T extends NativeType<T>, A extends BufferAccess<A>> ArrayImg<T, A> asArrayImg(NDArray ndArray, T type) {
        if (!Objects.equals(type.getNativeTypeFactory().getPrimitiveType(), DTypes.primitiveType(ndArray.dType()))) {
            throw new IllegalArgumentException();
        }
        long[] dimensions = ndArray.shape().toLongArray(NDArray.Shape.Order.F_ORDER);
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        NativeTypeFactory typeFactory = type.getNativeTypeFactory();
        BufferAccess access = BufferDataAccessFactory.get((NativeTypeFactory)typeFactory);
        BufferAccess data = (BufferAccess)access.newInstance(ndArray.buffer(), true);
        ArrayImg img = new ArrayImg((DataAccess)data, dimensions, entitiesPerPixel);
        img.setLinkedType(typeFactory.createLinkedType((NativeImg)img));
        return img;
    }

    public static <T extends NativeType<T>> NDArray asNDArray(RandomAccessibleInterval<T> rai, boolean allowCopy) {
        if (rai instanceof WrappedNDArray) {
            return ((WrappedNDArray)rai).ndArray();
        }
        if (allowCopy) {
            return ShmImg.copyOf(rai).ndArray();
        }
        throw new IllegalArgumentException("The provided RandomAccessibleInterval does not wrap an NDArray");
    }

    public static <T extends NativeType<T>> NDArray asNDArray(RandomAccessibleInterval<T> rai) {
        return NDArrays.asNDArray(rai, true);
    }
}

