/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import net.imglib2.roi.AbstractIterableRegionOfInterest;
import net.imglib2.roi.GeneralPathSegmentHandler;

@Deprecated
public class GeneralPathRegionOfInterest
extends AbstractIterableRegionOfInterest
implements GeneralPathSegmentHandler {
    private GeneralPath path = new GeneralPath();
    private long[] stripes;
    private int index;

    public GeneralPathRegionOfInterest() {
        super(2);
    }

    @Override
    public void moveTo(double x, double y) {
        this.path.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        this.path.lineTo(x, y);
    }

    @Override
    public void quadTo(double x1, double y1, double x, double y) {
        this.path.quadTo(x1, y1, x, y);
    }

    @Override
    public void cubicTo(double x1, double y1, double x2, double y2, double x, double y) {
        this.path.curveTo(x1, y1, x2, y2, x, y);
    }

    @Override
    public void close() {
        this.path.closePath();
    }

    public void reset() {
        this.path.reset();
    }

    public void setGeneralPath(GeneralPath path) {
        this.path = path;
        this.stripes = null;
    }

    public GeneralPath getGeneralPath() {
        return this.path;
    }

    public void iteratePath(GeneralPathSegmentHandler handler) {
        double[] coords = new double[6];
        PathIterator iterator = this.path.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    handler.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    handler.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    handler.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    handler.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    handler.close();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported segment type: " + type);
                }
            }
            iterator.next();
        }
    }

    @Override
    protected boolean nextRaster(long[] position, long[] end) {
        this.ensureStripes();
        if (this.index >= this.stripes.length) {
            this.index = 0;
            return false;
        }
        position[0] = this.stripes[this.index];
        end[0] = this.stripes[this.index + 1];
        position[1] = end[1] = this.stripes[this.index + 2];
        this.index += 3;
        return true;
    }

    @Override
    public boolean contains(double[] position) {
        return this.path.contains(position[0], position[1]);
    }

    private void ensureStripes() {
        if (this.stripes != null) {
            return;
        }
        if (this.path.getPathIterator(null).isDone()) {
            this.stripes = new long[0];
            return;
        }
        Rectangle2D bounds = this.path.getBounds2D();
        int left = (int)Math.floor(bounds.getMinX());
        int top = (int)Math.floor(bounds.getMinY());
        int width = (int)(Math.ceil(bounds.getMaxX()) - (double)left);
        int height = (int)(Math.ceil(bounds.getMaxY()) - (double)top);
        byte[] pixels = new byte[width * height];
        IndexColorModel colorModel = new IndexColorModel(1, 2, new byte[]{0, 1}, new byte[]{0, 1}, new byte[]{0, 1});
        MultiPixelPackedSampleModel sampleModel = new MultiPixelPackedSampleModel(0, width, height, 8);
        DataBufferByte dataBuffer = new DataBufferByte(pixels, width * height);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        GeneralPath transformed = new GeneralPath(this.path);
        transformed.transform(AffineTransform.getTranslateInstance(-bounds.getMinX(), -bounds.getMinY()));
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(Color.WHITE);
        g2d.setStroke(new BasicStroke(0.0f));
        g2d.fill(transformed);
        long[] strps = new long[3 * (width == 1 ? 2 : width) * height / 2];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            long start = -1L;
            for (int x = 0; x < width; ++x) {
                boolean inside;
                boolean bl = inside = pixels[x + width * y] != 0;
                if (start < 0L) {
                    if (!inside) continue;
                    start = x;
                    strps[i] = x + left;
                    strps[i + 2] = y + top;
                    continue;
                }
                if (inside) continue;
                start = -1L;
                strps[i + 1] = x + left;
                i += 3;
            }
            if (start < 0L) continue;
            start = -1L;
            strps[i + 1] = width + left;
            i += 3;
        }
        this.stripes = new long[i];
        System.arraycopy(strps, 0, this.stripes, 0, i);
        this.index = 0;
    }

    @Override
    public void move(double displacement, int d) {
        if (d != 0 && d != 1) {
            throw new IllegalArgumentException("Cannot move 2D ROI in dimension " + d);
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(d == 0 ? displacement : 0.0, d == 1 ? displacement : 0.0);
        this.path.transform(transform);
    }

    @Override
    public void move(double[] displacement) {
        if (displacement.length != 2) {
            throw new IllegalArgumentException("Cannot move 2D ROI in " + displacement.length + " dimensions");
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(displacement[0], displacement[1]);
        this.path.transform(transform);
    }
}

