/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector;

import net.imagej.ImageJService;
import net.imagej.ImgPlus;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.ops.OpService;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class ImageUtilService
extends AbstractService
implements ImageJService {
    @Parameter
    private LogService log;
    @Parameter
    private OpService op;

    public ImgPlus<? extends RealType<?>> cropAlongAxis(ImgPlus<? extends RealType<?>> img, AxisType axis, long index) {
        if (img.dimensionIndex(axis) == -1) {
            return img;
        }
        int nDim = img.numDimensions();
        long[] intervalsArray = new long[nDim * 2];
        for (int i = 0; i < nDim; ++i) {
            if (((CalibratedAxis)img.axis(i)).type().equals(axis)) {
                intervalsArray[i] = index;
                intervalsArray[i + nDim] = index;
                continue;
            }
            intervalsArray[i] = 0L;
            intervalsArray[i + nDim] = img.dimension(i) - 1L;
        }
        FinalInterval interval = Intervals.createMinMax((long[])intervalsArray);
        return (ImgPlus)this.op.transform().crop(img, (Interval)interval);
    }
}

