/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Shape;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.SpringMesh;
import mpicbg.models.TransformMesh;
import mpicbg.models.Vertex;

public class Transform_SpringMesh
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener {
    private static int numX = 32;
    private static String rawFileName = "figure";
    ImagePlus imp;
    ImageProcessor ip;
    ImageProcessor ipOrig;
    protected TransformMeshMapping mapping;
    final ArrayList<Point> hooks = new ArrayList();
    PointRoi handles;
    protected SpringMesh mesh;
    int targetIndex = -1;
    boolean pleaseOptimize = false;
    boolean pleaseIllustrate = false;
    boolean showMesh = false;
    boolean showSprings = false;
    final Vector<Roi> displayList = new Vector();
    private Thread opt;
    private Thread ill;

    public void run(String arg) {
        this.hooks.clear();
        this.imp = IJ.getImage();
        this.ip = this.imp.getProcessor();
        this.ipOrig = this.ip.duplicate();
        GenericDialog gd = new GenericDialog("Elastic Moving Least Squares Transform");
        gd.addNumericField("Vertices_per_row :", (double)numX, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        numX = (int)gd.getNextNumber();
        this.mesh = new SpringMesh(numX, (double)this.imp.getWidth(), (double)this.imp.getHeight(), (double)0.01f, 3.4028234663852886E38, (double)0.9f);
        Random rnd = new Random(0L);
        for (int i = 0; i < 5; ++i) {
            this.mesh.addPassiveVertex(new Vertex(new double[]{rnd.nextInt(this.imp.getWidth() - 1), rnd.nextInt(this.imp.getHeight() - 1)}));
        }
        this.mapping = new TransformMeshMapping((TransformMesh)this.mesh);
        Toolbar.getInstance().setTool(Toolbar.getInstance().addTool("Add_and_drag_handles."));
        this.opt = new OptimizeThread();
        this.ill = new IllustrateThread();
        this.opt.start();
        this.ill.start();
        this.imp.getCanvas().addMouseListener((MouseListener)this);
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.imp.getCanvas().addKeyListener((KeyListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void illustrate() {
        Vector<Roi> vector = this.displayList;
        synchronized (vector) {
            this.displayList.clear();
            SpringMesh springMesh = this.mesh;
            synchronized (springMesh) {
                ShapeRoi roi;
                Shape shape;
                if (this.showSprings) {
                    shape = this.mesh.illustrateSprings();
                    roi = new ShapeRoi(shape);
                    roi.setInstanceColor(Color.red);
                    this.displayList.addElement((Roi)roi);
                }
                if (this.showMesh) {
                    shape = this.mesh.illustrateMesh();
                    roi = new ShapeRoi(shape);
                    roi.setInstanceColor(Color.white);
                    this.displayList.addElement((Roi)roi);
                }
                this.imp.getCanvas().setDisplayList(this.displayList);
            }
        }
    }

    public void apply() {
    }

    private void updateRoi() {
        int[] x = new int[this.hooks.size()];
        int[] y = new int[this.hooks.size()];
        for (int i = 0; i < this.hooks.size(); ++i) {
            double[] l = this.hooks.get(i).getW();
            x[i] = (int)l[0];
            y[i] = (int)l[1];
        }
        this.handles = new PointRoi(x, y, this.hooks.size());
        this.imp.setRoi((Roi)this.handles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.opt.interrupt();
            this.showMesh = false;
            this.showSprings = false;
            this.ill.interrupt();
            this.pleaseIllustrate = false;
            if (this.imp != null) {
                this.imp.getCanvas().removeMouseListener((MouseListener)this);
                this.imp.getCanvas().removeMouseMotionListener((MouseMotionListener)this);
                this.imp.getCanvas().removeKeyListener((KeyListener)this);
                this.imp.getCanvas().setDisplayList(null);
                this.imp.setRoi((Roi)null);
            }
            if (e.getKeyCode() == 27) {
                this.imp.setProcessor(null, this.ipOrig);
            }
        } else if (e.getKeyCode() == 89 || e.getKeyCode() == 85) {
            if (e.getKeyCode() == 89) {
                boolean bl = this.showMesh = !this.showMesh;
            }
            if (e.getKeyCode() == 85) {
                boolean bl = this.showSprings = !this.showSprings;
            }
            if (this.showMesh || this.showSprings) {
                Thread thread = this.ill;
                synchronized (thread) {
                    if (!this.pleaseIllustrate) {
                        this.illustrate();
                    } else {
                        this.ill.notify();
                    }
                }
            } else {
                this.pleaseIllustrate = false;
                Thread thread = this.ill;
                synchronized (thread) {
                    this.ill.interrupt();
                    this.imp.getCanvas().setDisplayList(null);
                }
            }
        } else if (e.getKeyCode() == 71) {
            SaveDialog sd = new SaveDialog("Save as ...", rawFileName, ".svg");
            String directory = sd.getDirectory();
            String name = sd.getFileName();
            rawFileName = name.replaceAll("\\.svg$", "");
            if (name == null || name == "") {
                IJ.error((String)"No filename selected.");
                return;
            }
            String fileName = directory + name;
            String g = this.mesh.illustrateMeshSVG();
            try {
                InputStream is = this.getClass().getResourceAsStream("template.svg");
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                String svg = new String(bytes);
                svg = svg.replaceAll("<!--g-->", g);
                IJ.log((String)svg);
                PrintStream ps = new PrintStream(fileName);
                ps.print(svg);
                ps.close();
            }
            catch (Exception ex) {
                IJ.error((String)("Error writing svg-file '" + fileName + "'.\n" + ex.getMessage()));
            }
        } else if (e.getKeyCode() != 112 || e.getSource() instanceof TextField) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        this.targetIndex = -1;
        if (e.getButton() == 1) {
            double[] l;
            ImageWindow win = WindowManager.getCurrentWindow();
            int xm = win.getCanvas().offScreenX(e.getX());
            int ym = win.getCanvas().offScreenY(e.getY());
            double target_d = Double.MAX_VALUE;
            for (int i = 0; i < this.hooks.size(); ++i) {
                double dy;
                l = this.hooks.get(i).getW();
                double dx = win.getCanvas().getMagnification() * (l[0] - (double)xm);
                double d = dx * dx + (dy = win.getCanvas().getMagnification() * (l[1] - (double)ym)) * dy;
                if (!(d < 64.0) || !(d < target_d)) continue;
                this.targetIndex = i;
                target_d = d;
            }
            if (this.targetIndex == -1) {
                double[] w = new double[]{xm, ym};
                l = this.mesh.findClosestTargetVertex(w).getL();
                SpringMesh springMesh = this.mesh;
                synchronized (springMesh) {
                    Vertex p = new Vertex(l, w);
                    this.hooks.add((Point)p);
                    this.mesh.addVertex(p, 1.0);
                }
                this.updateRoi();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.targetIndex >= 0) {
            Thread thread;
            ImageWindow win = WindowManager.getCurrentWindow();
            int xm = win.getCanvas().offScreenX(e.getX());
            int ym = win.getCanvas().offScreenY(e.getY());
            double[] l = this.hooks.get(this.targetIndex).getW();
            l[0] = xm;
            l[1] = ym;
            this.updateRoi();
            if (this.showMesh || this.showSprings) {
                thread = this.ill;
                synchronized (thread) {
                    this.pleaseIllustrate = true;
                    this.ill.notify();
                }
            }
            thread = this.opt;
            synchronized (thread) {
                this.pleaseOptimize = true;
                this.opt.notify();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta (right button) ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        if ((s = s + "]").equals(" [ ]")) {
            s = " [no modifiers]";
        }
        return s;
    }

    final class IllustrateThread
    extends Thread {
        IllustrateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    IllustrateThread illustrateThread = this;
                    synchronized (illustrateThread) {
                        Transform_SpringMesh.this.illustrate();
                        if (Transform_SpringMesh.this.pleaseIllustrate) {
                            this.wait(100L);
                        } else {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Transform_SpringMesh.this.illustrate();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    final class OptimizeThread
    extends Thread {
        OptimizeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    if (Transform_SpringMesh.this.pleaseOptimize) {
                        Transform_SpringMesh.this.mesh.optimize(Double.MAX_VALUE, 10000, 1000);
                        Transform_SpringMesh.this.pleaseIllustrate = false;
                        Transform_SpringMesh.this.apply();
                    }
                    OptimizeThread optimizeThread = this;
                    synchronized (optimizeThread) {
                        this.wait();
                    }
                }
                catch (NotEnoughDataPointsException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

