/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.util.Intervals;

public abstract class AbstractInterval
extends AbstractEuclideanSpace
implements Interval {
    protected final long[] min;
    protected final long[] max;

    public AbstractInterval(int n) {
        super(n);
        this.min = new long[n];
        this.max = new long[n];
    }

    public AbstractInterval(Interval interval) {
        this(interval.numDimensions());
        interval.min(this.min);
        interval.max(this.max);
    }

    public AbstractInterval(Dimensions dimensions) {
        this(dimensions.numDimensions());
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = dimensions.dimension(d) - 1L;
        }
    }

    public AbstractInterval(long[] min, long[] max, boolean copy) {
        super(min.length);
        assert (min.length == max.length);
        this.min = copy ? (long[])min.clone() : min;
        this.max = copy ? (long[])max.clone() : max;
    }

    public AbstractInterval(long[] min, long[] max) {
        this(min, max, true);
    }

    public AbstractInterval(Localizable min, Localizable max) {
        this(min.positionAsLongArray(), max.positionAsLongArray(), false);
    }

    public AbstractInterval(long[] dimensions) {
        this(dimensions.length);
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = dimensions[d] - 1L;
        }
    }

    @Override
    public double realMin(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.min[d];
    }

    @Override
    public void realMin(double[] minimum) {
        assert (minimum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            minimum[d] = this.min[d];
        }
    }

    @Override
    public void realMin(RealPositionable minimum) {
        assert (minimum.numDimensions() == this.n);
        minimum.setPosition(this.min);
    }

    @Override
    public double realMax(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.max[d];
    }

    @Override
    public void realMax(double[] maximum) {
        assert (maximum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            maximum[d] = this.max[d];
        }
    }

    @Override
    public void realMax(RealPositionable m) {
        assert (m.numDimensions() == this.n);
        m.setPosition(this.max);
    }

    @Override
    public long min(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.min[d];
    }

    @Override
    public void min(long[] minimum) {
        assert (minimum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            minimum[d] = this.min[d];
        }
    }

    @Override
    public void min(Positionable m) {
        assert (m.numDimensions() == this.n);
        m.setPosition(this.min);
    }

    @Override
    public long max(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.max[d];
    }

    @Override
    public void max(long[] maximum) {
        assert (maximum.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            maximum[d] = this.max[d];
        }
    }

    @Override
    public void max(Positionable m) {
        assert (m.numDimensions() == this.n);
        m.setPosition(this.max);
    }

    @Override
    public void dimensions(long[] dimensions) {
        assert (dimensions.length == this.n);
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.max[d] - this.min[d] + 1L;
        }
    }

    @Override
    public long dimension(int d) {
        assert (d >= 0);
        assert (d < this.n);
        return this.max[d] - this.min[d] + 1L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + Intervals.toString(this);
    }
}

