/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;

class RealARGBColorConverterFactory {
    private static ClassCopyProvider<RealARGBColorConverter> provider;

    RealARGBColorConverterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <R extends RealType<?>> RealARGBColorConverter<R> create(R type, double min, double max) {
        if (provider != null) return provider.newInstanceForKey(type.getClass(), min, max);
        Class<RealARGBColorConverterFactory> clazz = RealARGBColorConverterFactory.class;
        synchronized (RealARGBColorConverterFactory.class) {
            if (provider != null) return provider.newInstanceForKey(type.getClass(), min, max);
            provider = new ClassCopyProvider<RealARGBColorConverter>(Imp.class, RealARGBColorConverter.class, Double.TYPE, Double.TYPE);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return provider.newInstanceForKey(type.getClass(), min, max);
        }
    }

    public static class Imp<R extends RealType<?>>
    implements RealARGBColorConverter<R> {
        private double min = 0.0;
        private double max = 1.0;
        private final ARGBType color = new ARGBType(ARGBType.rgba(255, 255, 255, 255));
        private int A;
        private double scaleR;
        private double scaleG;
        private double scaleB;
        private int black;

        public Imp(double min, double max) {
            this.min = min;
            this.max = max;
            this.update();
        }

        @Override
        public ARGBType getColor() {
            return this.color.copy();
        }

        @Override
        public void setColor(ARGBType c) {
            this.color.set(c);
            this.update();
        }

        @Override
        public boolean supportsColor() {
            return true;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }

        @Override
        public void setMax(double max) {
            this.max = max;
            this.update();
        }

        @Override
        public void setMin(double min) {
            this.min = min;
            this.update();
        }

        private void update() {
            double scale = 1.0 / (this.max - this.min);
            int value = this.color.get();
            this.A = ARGBType.alpha(value);
            this.scaleR = (double)ARGBType.red(value) * scale;
            this.scaleG = (double)ARGBType.green(value) * scale;
            this.scaleB = (double)ARGBType.blue(value) * scale;
            this.black = ARGBType.rgba(0, 0, 0, this.A);
        }

        @Override
        public void convert(R input, ARGBType output) {
            double v = input.getRealDouble() - this.min;
            if (v < 0.0) {
                output.set(this.black);
            } else {
                int r0 = (int)(this.scaleR * v + 0.5);
                int g0 = (int)(this.scaleG * v + 0.5);
                int b0 = (int)(this.scaleB * v + 0.5);
                int r = Math.min(255, r0);
                int g = Math.min(255, g0);
                int b = Math.min(255, b0);
                output.set(ARGBType.rgba(r, g, b, this.A));
            }
        }
    }
}

