/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.stream.Stream;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.RealViewsSimplifyUtils;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.realtransform.Translation;
import net.imglib2.realtransform.Translation2D;
import net.imglib2.realtransform.Translation3D;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;

public class TransformationUtils {
    public static AffineGet tranformsToAffine(OmeNgffMultiScaleMetadata.OmeNgffDataset dataset, CoordinateTransformation<?>[] transforms) {
        Stream s = Stream.empty();
        if (dataset.coordinateTransformations != null) {
            s = Streams.concat((Stream[])new Stream[]{s, Arrays.stream(dataset.coordinateTransformations)});
        }
        if (transforms != null) {
            s = Streams.concat((Stream[])new Stream[]{s, Arrays.stream(transforms)});
        }
        return TransformationUtils.buildTransform((CoordinateTransformation[])s.toArray(CoordinateTransformation[]::new));
    }

    public static AffineGet buildTransform(CoordinateTransformation<?>[] transforms) {
        AffineTransform out = null;
        for (CoordinateTransformation<?> ct : transforms) {
            if (out == null) {
                out = new AffineTransform(ct.getTransform().numSourceDimensions());
            }
            out.preConcatenate(ct.getTransform());
        }
        if (out == null) {
            return null;
        }
        return TransformationUtils.simplifyAffineGet(out);
    }

    private static AffineGet simplifyAffineGet(AffineGet affineGet) {
        int n = affineGet.numDimensions();
        if (RealViewsSimplifyUtils.isExlusiveTranslation((AffineGet)affineGet)) {
            double[] translations = new double[n];
            for (int d = 0; d < n; ++d) {
                translations[d] = affineGet.get(d, n);
            }
            if (n == 2) {
                return new Translation2D(translations);
            }
            if (n == 3) {
                return new Translation3D(translations);
            }
            return new Translation(translations);
        }
        if (RealViewsSimplifyUtils.isExclusiveScale((AffineGet)affineGet)) {
            double[] scalings = new double[n];
            for (int d = 0; d < n; ++d) {
                scalings[d] = affineGet.get(d, d);
            }
            if (n == 2) {
                return new Scale2D(scalings);
            }
            if (n == 3) {
                return new Scale3D(scalings);
            }
            return new Scale(scalings);
        }
        if (RealViewsSimplifyUtils.isExclusiveScaleAndTranslation((AffineGet)affineGet)) {
            double[] s = new double[n];
            double[] t = new double[n];
            for (int d = 0; d < n; ++d) {
                s[d] = affineGet.get(d, d);
                t[d] = affineGet.get(d, n);
            }
            return new ScaleAndTranslation(s, t);
        }
        return affineGet.copy();
    }
}

