/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import fiji.util.DistanceComparator;
import fiji.util.KDTree;
import fiji.util.node.Leaf;
import fiji.util.node.Node;
import fiji.util.node.NonLeaf;
import java.util.ArrayList;
import java.util.Collections;

public class RadiusNeighborSearch<T extends Leaf<T>> {
    protected final KDTree<T> kdTree;
    protected ArrayList<T> pointsWithinRadius;
    protected double radius;

    public RadiusNeighborSearch(KDTree<T> kdTree) {
        this.kdTree = kdTree;
    }

    public KDTree<T> getKDTree() {
        return this.kdTree;
    }

    public ArrayList<T> findNeighborsUnsorted(T point, double r) {
        this.pointsWithinRadius = new ArrayList();
        this.radius = r;
        this.findNeighbors(point, this.kdTree.getRoot(), 0);
        return this.pointsWithinRadius;
    }

    public ArrayList<T> findNeighborsSorted(T point, double r) {
        this.findNeighborsUnsorted(point, r);
        Collections.sort(this.pointsWithinRadius, new DistanceComparator<T>(point));
        return this.pointsWithinRadius;
    }

    protected void findNeighbors(T point, Node<T> node, int depth) {
        if (node.isLeaf()) {
            Leaf leaf = (Leaf)node;
            double distance = leaf.distanceTo(point);
            if (distance <= this.radius) {
                this.pointsWithinRadius.add(leaf);
            }
        } else {
            int k = depth % this.kdTree.getDimension();
            NonLeaf nonLeaf = (NonLeaf)node;
            if (nonLeaf.right == null) {
                this.findNeighbors(point, nonLeaf.left, depth + 1);
            } else if (nonLeaf.left == null) {
                this.findNeighbors(point, nonLeaf.right, depth + 1);
            } else {
                float projectedDistance = nonLeaf.coordinate - point.get(k);
                boolean lookRight = projectedDistance < 0.0f;
                this.findNeighbors(point, lookRight ? nonLeaf.right : nonLeaf.left, depth + 1);
                if ((double)Math.abs(projectedDistance) <= this.radius) {
                    this.findNeighbors(point, lookRight ? nonLeaf.left : nonLeaf.right, depth + 1);
                }
            }
        }
    }
}

